/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.celleditor;

import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.RenderErrorHandling;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ControlDecorationProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.EditorSelectionEnum;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractStyledTextCellEditor
extends AbstractCellEditor {
    private StyledText text = null;
    private boolean editable = true;
    private final boolean commitOnUpDown;
    private final boolean moveSelectionOnEnter;
    private EditorSelectionEnum selectionMode;
    protected final ControlDecorationProvider decorationProvider = new ControlDecorationProvider();
    private IEditErrorHandler inputConversionErrorHandler = new RenderErrorHandling(this.decorationProvider);
    private IEditErrorHandler inputValidationErrorHandler = new RenderErrorHandling(this.decorationProvider);
    protected boolean commitOnEnter = true;

    public AbstractStyledTextCellEditor() {
        this(false);
    }

    public AbstractStyledTextCellEditor(boolean commitOnUpDown) {
        this(commitOnUpDown, false);
    }

    public AbstractStyledTextCellEditor(boolean commitOnUpDown, boolean moveSelectionOnEnter) {
        this.commitOnUpDown = commitOnUpDown;
        this.moveSelectionOnEnter = moveSelectionOnEnter;
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.text = this.createEditorControl(parent);
        if (originalCanonicalValue instanceof Character) {
            this.text.setText(originalCanonicalValue.toString());
            this.selectText(this.selectionMode != null ? this.selectionMode : EditorSelectionEnum.END);
        } else {
            this.setCanonicalValue(originalCanonicalValue);
            this.selectText(this.selectionMode != null ? this.selectionMode : EditorSelectionEnum.ALL);
        }
        if (!this.isEditable()) {
            this.text.setEditable(false);
        }
        this.decorationProvider.createErrorDecorationIfRequired((Control)this.text);
        if (this.inputConversionErrorHandler instanceof RenderErrorHandling) {
            IStyle conversionErrorStyle = (IStyle)this.configRegistry.getConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, "EDIT", this.labelStack.getLabels());
            ((RenderErrorHandling)this.inputConversionErrorHandler).setErrorStyle(conversionErrorStyle);
        }
        if (this.inputValidationErrorHandler instanceof RenderErrorHandling) {
            IStyle validationErrorStyle = (IStyle)this.configRegistry.getConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_STYLE, "EDIT", this.labelStack.getLabels());
            ((RenderErrorHandling)this.inputValidationErrorHandler).setErrorStyle(validationErrorStyle);
        }
        this.text.forceFocus();
        return this.text;
    }

    public Object getEditorValue() {
        return this.text.getText();
    }

    public void setEditorValue(Object value) {
        this.text.setText(value != null && value.toString().length() > 0 ? value.toString() : "");
    }

    public StyledText getEditorControl() {
        return this.text;
    }

    public StyledText createEditorControl(Composite parent) {
        int style = HorizontalAlignmentEnum.getSWTStyle((IStyle)this.cellStyle);
        if (this.editMode == EditModeEnum.DIALOG) {
            style |= 0x800;
        }
        return this.createEditorControl(parent, style);
    }

    protected StyledText createStyledText(Composite parent, int style) {
        return new StyledText(parent, style);
    }

    protected StyledText createEditorControl(final Composite parent, int style) {
        final StyledText textControl = this.createStyledText(parent, style);
        textControl.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (textControl.isDisposed()) {
                    event.doit = false;
                }
            }
        });
        textControl.setBackground((Color)this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        textControl.setForeground((Color)this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        textControl.setFont((Font)this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        textControl.setCursor(new Cursor((Device)Display.getDefault(), 19));
        textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (AbstractStyledTextCellEditor.this.commitOnEnter && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                    SelectionLayer.MoveDirectionEnum move = SelectionLayer.MoveDirectionEnum.NONE;
                    if (AbstractStyledTextCellEditor.this.moveSelectionOnEnter && AbstractStyledTextCellEditor.this.editMode == EditModeEnum.INLINE) {
                        if (event.stateMask == 0) {
                            move = SelectionLayer.MoveDirectionEnum.DOWN;
                        } else if (event.stateMask == 131072) {
                            move = SelectionLayer.MoveDirectionEnum.UP;
                        }
                    }
                    AbstractStyledTextCellEditor.this.commit(move);
                    if (AbstractStyledTextCellEditor.this.editMode == EditModeEnum.DIALOG) {
                        parent.forceFocus();
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    AbstractStyledTextCellEditor.this.close();
                } else if (AbstractStyledTextCellEditor.this.commitOnUpDown && AbstractStyledTextCellEditor.this.editMode == EditModeEnum.INLINE) {
                    if (event.keyCode == 0x1000001) {
                        AbstractStyledTextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.UP);
                    } else if (event.keyCode == 0x1000002) {
                        AbstractStyledTextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.DOWN);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                try {
                    Object canonicalValue = AbstractStyledTextCellEditor.this.getCanonicalValue(AbstractStyledTextCellEditor.this.inputConversionErrorHandler);
                    AbstractStyledTextCellEditor.this.validateCanonicalValue(canonicalValue, AbstractStyledTextCellEditor.this.inputValidationErrorHandler);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return textControl;
    }

    public void close() {
        super.close();
        this.decorationProvider.dispose();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public final EditorSelectionEnum getSelectionMode() {
        return this.selectionMode;
    }

    public final void setSelectionMode(EditorSelectionEnum selectionMode) {
        this.selectionMode = selectionMode;
    }

    private void selectText(EditorSelectionEnum selectionMode) {
        int textLength = this.text.getText().length();
        if (textLength > 0) {
            if (selectionMode == EditorSelectionEnum.ALL) {
                this.text.setSelection(0, textLength);
            } else if (selectionMode == EditorSelectionEnum.END) {
                this.text.setSelection(textLength, textLength);
            } else if (selectionMode == EditorSelectionEnum.START) {
                this.text.setSelection(0);
            }
        }
    }

    public ControlDecorationProvider getDecorationProvider() {
        return this.decorationProvider;
    }

    public void setErrorDecorationEnabled(boolean enabled) {
        this.decorationProvider.setErrorDecorationEnabled(enabled);
    }

    public void setErrorDecorationText(String errorText) {
        this.decorationProvider.setErrorDecorationText(errorText);
    }

    public void showErrorDecorationHover(String customErrorText) {
        this.decorationProvider.showErrorDecorationHover(customErrorText);
    }

    public void setDecorationPositionOverride(int decorationPositionOverride) {
        this.decorationProvider.setDecorationPositionOverride(decorationPositionOverride);
    }

    public IEditErrorHandler getInputConversionErrorHandler() {
        return this.inputConversionErrorHandler;
    }

    public void setInputConversionErrorHandler(IEditErrorHandler inputConversionErrorHandler) {
        this.inputConversionErrorHandler = inputConversionErrorHandler;
    }

    public IEditErrorHandler getInputValidationErrorHandler() {
        return this.inputValidationErrorHandler;
    }

    public void setInputValidationErrorHandler(IEditErrorHandler inputValidationErrorHandler) {
        this.inputValidationErrorHandler = inputValidationErrorHandler;
    }
}

