/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.providers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.uml.diagram.common.providers.BaseViewInfo;
import org.eclipse.papyrus.uml.diagram.common.providers.RootViewInfo;
import org.eclipse.papyrus.uml.diagram.common.providers.ViewInfo;
import org.eclipse.papyrus.uml.diagram.common.util.ExtensionPointParser;

public class ViewInfoRegistry {
    private static final ViewInfoRegistry INSTANCE = new ViewInfoRegistry();
    private static final String extensionPointID = "es.cv.gvcase.mdt.common.viewInfo";
    private static Map<String, RootViewInfo> mapEditorID2RootViewInfo = null;

    private ViewInfoRegistry() {
    }

    public static ViewInfoRegistry getInstance() {
        return INSTANCE;
    }

    protected static String getExtensionPointID() {
        return extensionPointID;
    }

    protected static Map<String, RootViewInfo> getMapEditorID2RootViewInfo() {
        if (mapEditorID2RootViewInfo == null) {
            mapEditorID2RootViewInfo = new HashMap<String, RootViewInfo>();
        }
        return mapEditorID2RootViewInfo;
    }

    public Map<String, RootViewInfo> getEditorIdsToViewInfos() {
        return this.readMapEditorID2RootViewInfo();
    }

    public Collection<String> getAllEditorIDs() {
        return this.readMapEditorID2RootViewInfo().keySet();
    }

    public Collection<RootViewInfo> getAllRootViewInfos() {
        return this.readMapEditorID2RootViewInfo().values();
    }

    public RootViewInfo getRootViewInfoForEditor(String editorID) {
        return this.readMapEditorID2RootViewInfo().get(editorID);
    }

    public ViewInfo getHeadViewInfoForEditor(String editorID) {
        RootViewInfo rootViewInfo = this.readMapEditorID2RootViewInfo().get(editorID);
        if (rootViewInfo != null && rootViewInfo.headViewInfo != null && rootViewInfo.headViewInfo.getType() == 0) {
            return rootViewInfo.headViewInfo;
        }
        return null;
    }

    public ViewInfo getViewInfoForVisualIDForEditor(String editorID, int visualID) {
        if (editorID == null || editorID.length() <= 0) {
            return null;
        }
        ViewInfo headViewInfo = this.getHeadViewInfoForEditor(editorID);
        if (headViewInfo == null) {
            return null;
        }
        return this.findViewInfoByVisualIDInChildren(headViewInfo, visualID);
    }

    protected ViewInfo findViewInfoByVisualIDInChildren(ViewInfo viewInfo, int visualID) {
        if (viewInfo.getVisualID() == visualID) {
            return viewInfo;
        }
        ViewInfo foundViewInfo = null;
        for (ViewInfo childrenViewInfo : viewInfo.getChildren()) {
            foundViewInfo = this.findViewInfoByVisualIDInChildren(childrenViewInfo, visualID);
            if (foundViewInfo == null) continue;
            return foundViewInfo;
        }
        return null;
    }

    protected Map<String, RootViewInfo> readMapEditorID2RootViewInfo() {
        Map<String, RootViewInfo> map = ViewInfoRegistry.getMapEditorID2RootViewInfo();
        ExtensionPointParser parser = new ExtensionPointParser(ViewInfoRegistry.getExtensionPointID(), new Class[]{RootViewInfo.class, BaseViewInfo.class});
        for (Object object : parser.parseExtensionPoint()) {
            RootViewInfo rootViewInfo = (RootViewInfo)Platform.getAdapterManager().getAdapter(object, RootViewInfo.class);
            if (rootViewInfo == null || !this.processRootViewInfo(rootViewInfo)) continue;
            map.put(rootViewInfo.editorID, rootViewInfo);
        }
        return map;
    }

    protected boolean processRootViewInfo(RootViewInfo rootViewInfo) {
        if (rootViewInfo == null || rootViewInfo.BaseViewInfo == null || rootViewInfo.BaseViewInfo.size() <= 0) {
            return false;
        }
        BaseViewInfo headViewInfo = this.findHeadNodeInRootViewInfo(rootViewInfo);
        if (headViewInfo == null) {
            return false;
        }
        rootViewInfo.headViewInfo = headViewInfo;
        return this.addKnownTypesViewInfo(rootViewInfo);
    }

    protected BaseViewInfo findHeadNodeInRootViewInfo(RootViewInfo rootViewInfo) {
        if (rootViewInfo == null || rootViewInfo.BaseViewInfo == null || rootViewInfo.BaseViewInfo.size() <= 0) {
            return null;
        }
        for (Object object : rootViewInfo.BaseViewInfo) {
            BaseViewInfo baseViewInfo = (BaseViewInfo)Platform.getAdapterManager().getAdapter(object, BaseViewInfo.class);
            if (baseViewInfo == null || baseViewInfo.getType() != 0) continue;
            baseViewInfo.rootViewInfo = rootViewInfo;
            return baseViewInfo;
        }
        return null;
    }

    protected boolean addKnownTypesViewInfo(RootViewInfo rootViewInfo) {
        if (rootViewInfo.headViewInfo == null || rootViewInfo == null || rootViewInfo.BaseViewInfo == null || rootViewInfo.BaseViewInfo.size() <= 0) {
            return false;
        }
        ViewInfo headViewInfo = rootViewInfo.headViewInfo;
        for (Object object : rootViewInfo.BaseViewInfo) {
            BaseViewInfo baseViewInfo = (BaseViewInfo)Platform.getAdapterManager().getAdapter(object, BaseViewInfo.class);
            if (baseViewInfo == null || baseViewInfo.getType() == 0 || -1 == baseViewInfo.getType()) continue;
            baseViewInfo.rootViewInfo = rootViewInfo;
            headViewInfo.addNode(Integer.valueOf(baseViewInfo.parent), baseViewInfo);
        }
        return true;
    }
}

