/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.actions.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionContext;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramGlobalActionHandler;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.common.commands.AbstractCommonTransactionalCommmand;
import org.eclipse.papyrus.uml.diagram.common.commands.AddEObjectReferencesToDiagram;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ViewAndFeatureResolver;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.util.MDTUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ClipboardActionHandler
extends DiagramGlobalActionHandler {
    private static boolean isCut = false;
    private static EObject container = null;
    protected static List<EObject> clipboard = new ArrayList<EObject>();
    protected static List<EditPart> editPartsInClipboard = new ArrayList<EditPart>();
    protected static List<Object> clipboardElements = new ArrayList<Object>();

    public void setContainer(EObject container) {
        ClipboardActionHandler.container = container;
    }

    public EObject getContainer() {
        return container;
    }

    public boolean getIsCut() {
        return isCut;
    }

    public void setIsCut(boolean isCut) {
        ClipboardActionHandler.isCut = isCut;
    }

    protected boolean canCopy(IGlobalActionContext cntxt) {
        EObject eobject;
        Object firstElement;
        if (cntxt.getSelection() instanceof StructuredSelection && (firstElement = ((StructuredSelection)cntxt.getSelection()).getFirstElement()) instanceof IGraphicalEditPart && (eobject = ((IGraphicalEditPart)firstElement).resolveSemanticElement()) != null) {
            List elements = ((StructuredSelection)cntxt.getSelection()).toList();
            ArrayList<EObject> eobjects = new ArrayList<EObject>();
            for (Object o : elements) {
                EObject eobj = ((IGraphicalEditPart)o).resolveSemanticElement();
                eobjects.add(eobj);
            }
            if (!this.allElementsSameType(eobjects, eobject)) {
                return false;
            }
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            return !(editorPart instanceof DiagramEditor) || !((DiagramEditor)editorPart).getDiagram().getElement().equals(eobject);
        }
        return false;
    }

    protected boolean canCut(IGlobalActionContext cntxt) {
        return this.canCopy(cntxt);
    }

    protected boolean canPaste(IGlobalActionContext cntxt) {
        Object[] objects;
        EObject firstObjectToBePasted;
        EStructuralFeature feature;
        TransactionalEditingDomain domain;
        IGraphicalEditPart pasteDestination;
        Object firstElement;
        return cntxt.getSelection() instanceof StructuredSelection && (firstElement = ((StructuredSelection)cntxt.getSelection()).getFirstElement()) instanceof IGraphicalEditPart && (pasteDestination = (IGraphicalEditPart)firstElement) != null && pasteDestination.resolveSemanticElement() != null && (!pasteDestination.resolveSemanticElement().equals(container) || !isCut) && (domain = pasteDestination.getEditingDomain()).getClipboard() != null && domain.getClipboard().size() > 0 && (feature = this.getFeature(firstObjectToBePasted = (EObject)(objects = domain.getClipboard().toArray())[0], (EditPart)pasteDestination)) != null && feature.getEType().getInstanceClass().isInstance(firstObjectToBePasted);
    }

    public ICommand getCommand(IGlobalActionContext cntxt) {
        IWorkbenchPart part = cntxt.getActivePart();
        if (!(part instanceof IDiagramWorkbenchPart)) {
            return null;
        }
        IDiagramWorkbenchPart diagramPart = (IDiagramWorkbenchPart)part;
        String actionId = cntxt.getActionId();
        if (actionId.equals(GlobalActionId.COPY)) {
            isCut = false;
            return this.getCopyCommand(cntxt, diagramPart, false);
        }
        if (actionId.equals(GlobalActionId.CUT)) {
            isCut = true;
            return this.getCutCommand(cntxt, diagramPart);
        }
        if (actionId.equals(GlobalActionId.PASTE)) {
            if (isCut) {
                isCut = false;
                return this.getExecutePasteAfterCutCommand(cntxt);
            }
            isCut = false;
            return this.getExecutePasteAfterCopyCommand(cntxt);
        }
        return super.getCommand(cntxt);
    }

    protected ICommand getCopyCommand(IGlobalActionContext cntxt, IDiagramWorkbenchPart diagramPart, boolean isUndoable) {
        if (cntxt.getSelection() instanceof StructuredSelection) {
            Object firstElement = ((StructuredSelection)cntxt.getSelection()).getFirstElement();
            EObject eobject = ((IGraphicalEditPart)firstElement).resolveSemanticElement();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)eobject);
            List elements = ((StructuredSelection)cntxt.getSelection()).toList();
            ArrayList<EObject> eobjects = new ArrayList<EObject>();
            editPartsInClipboard.clear();
            for (Object o : elements) {
                EObject eobj = ((IGraphicalEditPart)o).resolveSemanticElement();
                eobjects.add(eobj);
                container = eobj.eContainer();
                for (Object view : DiagramEditPartsUtil.getEObjectViews(eobj)) {
                    if (!(view instanceof View)) continue;
                    EditPart editpart = DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)firstElement);
                    editPartsInClipboard.add(editpart);
                }
            }
            clipboard.clear();
            clipboard.addAll(eobjects);
            final ArrayList<EObject> eobjects2 = eobjects;
            CopyToClipboardCommand copyCommand = new CopyToClipboardCommand((EditingDomain)domain, eobjects){

                public void doExecute() {
                    ArrayList<EObject> list = new ArrayList<EObject>();
                    for (EObject eobj : eobjects2) {
                        EObject eo = EcoreUtil.copy((EObject)eobj);
                        list.add(eo);
                    }
                    this.oldClipboard = this.domain.getClipboard();
                    this.domain.setClipboard(list);
                }
            };
            if (copyCommand != null) {
                return new EMFtoGMFCommandWrapper((Command)copyCommand);
            }
        }
        return super.getCopyCommand(cntxt, diagramPart, isUndoable);
    }

    protected ICommand getCutCommand(IGlobalActionContext cntxt, IDiagramWorkbenchPart diagramPart) {
        if (cntxt.getSelection() instanceof StructuredSelection) {
            Object firstElement = ((StructuredSelection)cntxt.getSelection()).getFirstElement();
            EObject eobject = ((IGraphicalEditPart)firstElement).resolveSemanticElement();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)eobject);
            List elements = ((StructuredSelection)cntxt.getSelection()).toList();
            ArrayList<EObject> eobjects = new ArrayList<EObject>();
            editPartsInClipboard.clear();
            for (Object o : elements) {
                EObject eobj = ((IGraphicalEditPart)o).resolveSemanticElement();
                eobjects.add(eobj);
                container = eobj.eContainer();
                for (Object view : DiagramEditPartsUtil.getEObjectViews(eobj)) {
                    if (!(view instanceof View)) continue;
                    EditPart editpart = DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)firstElement);
                    editPartsInClipboard.add(editpart);
                }
            }
            clipboard.clear();
            clipboard.addAll(eobjects);
            final ArrayList<EObject> eobjects2 = eobjects;
            CopyToClipboardCommand cutCommand = new CopyToClipboardCommand((EditingDomain)domain, eobjects){

                public void doExecute() {
                    ArrayList<EObject> list = new ArrayList<EObject>();
                    for (EObject eobj : eobjects2) {
                        list.add(eobj);
                    }
                    this.oldClipboard = this.domain.getClipboard();
                    this.domain.setClipboard(list);
                }
            };
            if (cutCommand != null) {
                return new EMFtoGMFCommandWrapper((Command)cutCommand);
            }
        }
        return super.getCutCommand(cntxt, diagramPart);
    }

    protected void prepareEObject(EObject eObject) {
    }

    protected ICommand getExecutePasteAfterCopyCommand(IGlobalActionContext cntxt) {
        Object firstElement;
        IGraphicalEditPart editPart;
        TransactionalEditingDomain domain;
        if (!(cntxt.getSelection() instanceof StructuredSelection)) {
            return null;
        }
        Object first = ((StructuredSelection)cntxt.getSelection()).getFirstElement();
        if (!(first instanceof IGraphicalEditPart)) {
            return null;
        }
        IGraphicalEditPart pasteDestination = (IGraphicalEditPart)first;
        TransactionalEditingDomain editingDomain = pasteDestination.getEditingDomain();
        AbstractCommonTransactionalCommmand command = new AbstractCommonTransactionalCommmand(editingDomain, "Paste after copy", null, domain = editingDomain, editPart = pasteDestination, firstElement = first){
            private final /* synthetic */ TransactionalEditingDomain val$domain;
            private final /* synthetic */ IGraphicalEditPart val$editPart;
            private final /* synthetic */ Object val$firstElement;
            {
                this.val$domain = transactionalEditingDomain;
                this.val$editPart = iGraphicalEditPart;
                this.val$firstElement = object;
                super($anonymous0, $anonymous1, $anonymous2);
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (this.val$domain.getClipboard() != null && this.val$domain.getClipboard().size() > 0) {
                    Object[] objects = this.val$domain.getClipboard().toArray();
                    EObject firstObjectToBePasted = (EObject)objects[0];
                    EStructuralFeature feature = ClipboardActionHandler.this.getFeature(firstObjectToBePasted, (EditPart)this.val$editPart);
                    Command pasteCommand = PasteFromClipboardCommand.create((EditingDomain)this.val$domain, (Object)this.val$editPart.resolveSemanticElement(), (Object)feature);
                    this.val$domain.getCommandStack().execute(pasteCommand);
                    ArrayList<EObject> eobjects = new ArrayList<EObject>();
                    for (Object o : pasteCommand.getAffectedObjects()) {
                        if (!(o instanceof EObject)) continue;
                        ClipboardActionHandler.this.prepareEObject((EObject)o);
                        eobjects.add((EObject)o);
                    }
                    AddEObjectReferencesToDiagram command = new AddEObjectReferencesToDiagram(this.val$domain, DiagramEditPartsUtil.findDiagramFromEditPart((EditPart)((IGraphicalEditPart)this.val$firstElement)), eobjects);
                    this.val$domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
                    DiagramEditPartsUtil.updateEditPart(this.val$editPart);
                    return CommandResult.newOKCommandResult();
                }
                return CommandResult.newCancelledCommandResult();
            }
        };
        return command.canExecute() ? command : null;
    }

    protected ICommand getExecutePasteAfterCutCommand(IGlobalActionContext cntxt) {
        Object firstElement;
        IGraphicalEditPart editPart;
        TransactionalEditingDomain domain;
        if (!(cntxt.getSelection() instanceof StructuredSelection)) {
            return null;
        }
        Object first = ((StructuredSelection)cntxt.getSelection()).getFirstElement();
        if (!(first instanceof IGraphicalEditPart)) {
            return null;
        }
        IGraphicalEditPart pasteDestination = (IGraphicalEditPart)first;
        TransactionalEditingDomain editingDomain = pasteDestination.getEditingDomain();
        AbstractCommonTransactionalCommmand command = new AbstractCommonTransactionalCommmand(editingDomain, "Paste after cut", null, domain = editingDomain, editPart = pasteDestination, firstElement = first){
            private final /* synthetic */ TransactionalEditingDomain val$domain;
            private final /* synthetic */ IGraphicalEditPart val$editPart;
            private final /* synthetic */ Object val$firstElement;
            {
                this.val$domain = transactionalEditingDomain;
                this.val$editPart = iGraphicalEditPart;
                this.val$firstElement = object;
                super($anonymous0, $anonymous1, $anonymous2);
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (this.val$domain.getClipboard() != null && this.val$domain.getClipboard().size() > 0) {
                    Object[] objects = this.val$domain.getClipboard().toArray();
                    EObject firstObjectToBePasted = (EObject)objects[0];
                    EStructuralFeature feature = ClipboardActionHandler.this.getFeature(firstObjectToBePasted, (EditPart)this.val$editPart);
                    CompoundCommand cc = new CompoundCommand("Paste");
                    Command removeCommand = RemoveCommand.create((EditingDomain)this.val$domain, (Object)container, (Object)feature, clipboard);
                    if (!removeCommand.canExecute()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    cc.append(removeCommand);
                    for (EditPart ep : editPartsInClipboard) {
                        Command c = ClipboardActionHandler.this.getDeleteViewCommand(ep);
                        if (c != null && !c.canExecute()) {
                            return CommandResult.newCancelledCommandResult();
                        }
                        cc.append(c);
                    }
                    for (Object obj : this.val$domain.getClipboard()) {
                        Command addCommand = AddCommand.create((EditingDomain)this.val$domain, (Object)this.val$editPart.resolveSemanticElement(), (Object)feature, (Object)obj);
                        if (!addCommand.canExecute()) {
                            return CommandResult.newCancelledCommandResult();
                        }
                        cc.append(addCommand);
                    }
                    ArrayList<EObject> eobjects = new ArrayList<EObject>();
                    for (Object o : this.val$domain.getClipboard()) {
                        if (!(o instanceof EObject)) continue;
                        eobjects.add((EObject)o);
                    }
                    AddEObjectReferencesToDiagram command = new AddEObjectReferencesToDiagram(this.val$domain, DiagramEditPartsUtil.findDiagramFromEditPart((EditPart)((IGraphicalEditPart)this.val$firstElement)), eobjects);
                    if (!command.canExecute()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    cc.append((Command)new GMFtoEMFCommandWrapper((ICommand)command));
                    if (!cc.canExecute()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    this.val$domain.getCommandStack().execute((Command)cc);
                    this.val$domain.setClipboard(new ArrayList());
                    clipboard.clear();
                    editPartsInClipboard.clear();
                    DiagramEditPartsUtil.updateEditPart(this.val$editPart);
                    return CommandResult.newOKCommandResult();
                }
                return CommandResult.newCancelledCommandResult();
            }
        };
        return command.canExecute() ? command : null;
    }

    private PreferencesHint getDiagramPreferencesHint(IGraphicalEditPart editPart) {
        return editPart.getDiagramPreferencesHint();
    }

    private boolean allElementsSameType(List<EObject> eobjects, EObject eobject) {
        for (EObject o : eobjects) {
            if (o != null) {
                if (o.eClass().equals(eobject.eClass())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected Command getDeleteViewCommand(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        GroupRequest deleteViewRequest = new GroupRequest((Object)"delete");
        org.eclipse.gef.commands.Command command = editPart.getCommand((Request)deleteViewRequest);
        return new GEFtoEMFCommandWrapper(command);
    }

    protected Collection<EditPart> getEditPartsInClipboard(Collection<Object> clipboard) {
        if (clipboard != null && clipboard.size() > 0) {
            ArrayList<EditPart> editParts = new ArrayList<EditPart>();
            for (Object object : clipboard) {
                if (!(object instanceof EditPart)) continue;
                editParts.add((EditPart)object);
            }
            return editParts;
        }
        return Collections.EMPTY_LIST;
    }

    public EStructuralFeature getFeature(EObject objectToBePasted, EditPart pasteDestination) {
        if (objectToBePasted == null || pasteDestination == null) {
            return null;
        }
        EObject element = MDTUtil.resolveSemantic(pasteDestination);
        return this.getFeature(element, objectToBePasted, pasteDestination);
    }

    protected EStructuralFeature getFeature(EObject element, EObject objectToBePasted, EditPart editPart) {
        if (element != MDTUtil.resolveSemantic(editPart)) {
            return null;
        }
        EStructuralFeature feature = null;
        Object adapter = editPart.getAdapter(ViewAndFeatureResolver.class);
        ViewAndFeatureResolver resolver = null;
        if (adapter instanceof ViewAndFeatureResolver) {
            resolver = (ViewAndFeatureResolver)adapter;
        }
        if (resolver != null) {
            feature = resolver.getEStructuralFeatureForEClass(objectToBePasted.eClass());
        }
        if (feature == null) {
            for (Object child : editPart.getChildren()) {
                if (child instanceof EditPart) {
                    feature = this.getFeature(element, objectToBePasted, (EditPart)child);
                }
                if (feature != null) break;
            }
        }
        return feature;
    }
}

