/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.Attribute;
import org.eclipse.papyrus.infra.gmfdiag.css.CssFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.Declaration;
import org.eclipse.papyrus.infra.gmfdiag.css.Ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css.Stylesheet;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.AbstractStyleDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.AbstractStyleHandler;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.StyleCreationDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.helper.XtextStylesheetHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateStyleHandler
extends AbstractStyleHandler {
    @Override
    protected AbstractStyleDialog createStyleDialog(Shell shell, Map<Declaration, Boolean> declarations, Map<Attribute, Boolean> conditions, String selectorName, View context) {
        return new StyleCreationDialog(shell, conditions, declarations, selectorName, context);
    }

    @Override
    protected Ruleset getRuleset(AbstractStyleDialog dialog) {
        return CssFactory.eINSTANCE.createRuleset();
    }

    @Override
    protected Stylesheet getStyleSheet(AbstractStyleDialog dialog, View contextView) {
        Stylesheet xtextStylesheet;
        Resource resource;
        StyleSheet styleSheet = ((StyleCreationDialog)dialog).getStyleSheet();
        if (styleSheet == null) {
            MessageDialog.open((int)1, (Shell)dialog.getShell(), (String)"Stylesheet error", (String)"Invalid stylesheet", (int)0);
            return null;
        }
        if (styleSheet instanceof StyleSheetReference) {
            resource = XtextStylesheetHelper.loadStylesheet((StyleSheetReference)styleSheet, null, contextView, dialog.getShell());
            if (resource == null) {
                return null;
            }
        } else {
            MessageDialog.open((int)1, (Shell)dialog.getShell(), (String)"Stylesheet error", (String)"Embedded stylesheets are not yet supported", (int)0);
            return null;
        }
        if (resource.getContents().isEmpty()) {
            xtextStylesheet = CssFactory.eINSTANCE.createStylesheet();
            xtextStylesheet.setCharset("UTF-8");
            resource.getContents().add((Object)xtextStylesheet);
        } else {
            xtextStylesheet = (Stylesheet)resource.getContents().get(0);
        }
        return xtextStylesheet;
    }
}

