/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.wizard;

import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.customization.display.DisplayManager;
import org.eclipse.papyrus.customization.messages.Messages;
import org.eclipse.papyrus.customization.model.customizationplugin.CustomizationConfiguration;
import org.eclipse.papyrus.customization.model.customizationplugin.CustomizationPluginFactory;
import org.eclipse.papyrus.customization.wizard.CreateNewCustomizationPluginWizard;
import org.eclipse.papyrus.views.properties.runtime.EmbeddedDisplayEngine;
import org.eclipse.papyrus.views.properties.runtime.ViewConstraintEngine;
import org.eclipse.papyrus.views.properties.widgets.layout.PropertiesLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CustomizationPage
extends WizardPage {
    private CustomizationConfiguration configuration;

    protected CustomizationPage() {
        this(null);
    }

    protected CustomizationPage(CustomizationConfiguration configuration) {
        super(Messages.CustomizationPage_Customization);
        this.setDescription("Select your customization configuration files");
        this.setTitle(Messages.CustomizationPage_Customization);
        this.configuration = configuration;
    }

    protected void setConfiguration(CustomizationConfiguration configuration) {
        this.configuration = configuration;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new PropertiesLayout());
        if (this.configuration == null) {
            this.configuration = CustomizationPluginFactory.eINSTANCE.createCustomizationConfiguration();
        }
        StructuredSelection selection = new StructuredSelection((Object)this.configuration);
        ViewConstraintEngine constraintEngine = DisplayManager.instance.constraintEngine;
        Set views = constraintEngine.getViews((ISelection)selection);
        Composite self = new Composite(container, 2048);
        self.setLayoutData((Object)new GridData(4, 1, true, false));
        self.setLayout((Layout)new FillLayout());
        EmbeddedDisplayEngine display = new EmbeddedDisplayEngine();
        display.display(views, self, (ISelection)selection, 0);
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.configuration.setPlugin(this.getWizard().getPluginId());
        }
        super.setVisible(visible);
    }

    public CreateNewCustomizationPluginWizard getWizard() {
        return (CreateNewCustomizationPluginWizard)super.getWizard();
    }

    public CustomizationConfiguration getConfiguration() {
        return this.configuration;
    }
}

