/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.utils;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ocl.examples.debug.vm.utils.IVMStackTraceElement;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceElement;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;

public class VMRuntimeException
extends EvaluationHaltedException {
    private static final long serialVersionUID = -8903219155434276631L;
    private List<VMStackTraceElement> fVMStackTrace;

    public VMRuntimeException() {
        this(null, null);
    }

    public VMRuntimeException(String message) {
        this(message, null);
    }

    public VMRuntimeException(Exception cause) {
        this(null, cause);
    }

    public VMRuntimeException(String message, Exception cause) {
        super(message, (Throwable)cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printVMStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            pw.println((Object)this);
            VMRuntimeException.printVMStackTrace(pw, this.getVMStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printVMStackTrace(PrintWriter pw, List<? extends IVMStackTraceElement> elements) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            int counter = 0;
            for (IVMStackTraceElement iVMStackTraceElement : elements) {
                if (counter++ > 0) {
                    pw.println();
                }
                pw.print("\tat " + iVMStackTraceElement);
            }
        }
    }

    public List<VMStackTraceElement> getVMStackTrace() {
        if (this.fVMStackTrace != null) {
            return Collections.unmodifiableList(this.fVMStackTrace);
        }
        return Collections.emptyList();
    }

    public void setStackVMTrace(List<VMStackTraceElement> stackTrace) {
        if (this.fVMStackTrace != null) {
            throw new IllegalStateException("Can't reassign stack elements");
        }
        this.fVMStackTrace = null;
        if (stackTrace != null) {
            this.fVMStackTrace = new ArrayList<VMStackTraceElement>(stackTrace);
        }
    }
}

