/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.srclookup;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;

public abstract class VMSourcePathComputer
implements ISourcePathComputer {
    public static IFile getIFile(String fileUnderWorkspace) {
        Path location = new Path(fileUnderWorkspace);
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)location);
        return ifile;
    }

    public static IFile getWorkspaceFile(String name) {
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(name));
            return file;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IFile getWorkspaceFile(URI uri) {
        IFile wsfile;
        String uriPath = uri.isFile() ? uri.toFileString() : (uri.isPlatform() ? uri.toPlatformString(true) : uri.toString());
        IFile ifile = VMSourcePathComputer.getWorkspaceFile(uriPath);
        if ((ifile == null || !ifile.exists()) && uri.isFile() && (wsfile = VMSourcePathComputer.getIFile(uriPath)) != null && wsfile.exists()) {
            return wsfile;
        }
        return ifile;
    }

    @NonNull
    public abstract String getId();

    @NonNull
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        Object sourceContainer;
        Object moduleFile;
        assert (configuration != null);
        URI moduleURI = this.getModuleFile(configuration);
        if (moduleURI.isFile()) {
            moduleFile = new File(moduleURI.toFileString());
            sourceContainer = new DirectorySourceContainer(((File)moduleFile).getParentFile(), false){

                public Object[] findSourceElements(String name) throws CoreException {
                    URI nameURI = URI.createFileURI((String)name);
                    URI directoryURI = URI.createFileURI((String)(String.valueOf(this.getDirectory().toString()) + "/"));
                    URI relativeURI = nameURI.deresolve(directoryURI);
                    return super.findSourceElements(relativeURI.toString());
                }

                protected Object[] findSourceElements(String name, ISourceContainer[] containers) throws CoreException {
                    return super.findSourceElements(name, containers);
                }
            };
        } else {
            moduleFile = VMSourcePathComputer.getWorkspaceFile(moduleURI);
            sourceContainer = moduleFile != null && moduleFile.exists() ? new ProjectSourceContainer(moduleFile.getProject(), false) : new WorkspaceSourceContainer();
        }
        ArrayList<WorkspaceSourceContainer> result = new ArrayList<WorkspaceSourceContainer>();
        result.add((WorkspaceSourceContainer)sourceContainer);
        return result.toArray(new ISourceContainer[result.size()]);
    }

    protected abstract URI getModuleFile(@NonNull ILaunchConfiguration var1) throws CoreException;
}

