/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.core.IVMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugElement;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.debug.vm.data.VMValueData;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.request.VMDetailRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMVariableRequest;
import org.eclipse.ocl.examples.debug.vm.response.VMDetailResponse;
import org.eclipse.ocl.examples.debug.vm.response.VMResponse;
import org.eclipse.ocl.examples.debug.vm.response.VMVariableResponse;

public class VMValue
extends VMDebugElement
implements IValue {
    final VMVariableData vmVar;
    private VMValueData vmValue;
    private long frameID;

    VMValue(IVMDebugTarget debugTarget, VMVariableData vmVar, long frameID) {
        super(debugTarget);
        this.vmVar = vmVar;
        this.vmValue = vmVar.value;
        this.frameID = frameID;
    }

    public boolean hasVariables() throws DebugException {
        return this.vmValue != null && this.vmValue.hasVariables;
    }

    public IVariable[] getVariables() throws DebugException {
        List<VMVariableData> variables = this.requestVariables();
        ArrayList<VMVariable> result = new ArrayList<VMVariable>();
        for (VMVariableData nextVar : variables) {
            result.add(new VMVariable(this.getOCLDebugTarget(), nextVar, this.frameID));
        }
        return result.toArray(new IVariable[result.size()]);
    }

    public String getValueString() throws DebugException {
        return this.vmValue != null ? String.valueOf(this.vmValue.value) : "null";
    }

    public String getReferenceTypeName() throws DebugException {
        return this.vmVar.type.actualType;
    }

    public String computeDetail() throws DebugException {
        URI varURI = URI.createURI((String)this.getVariableURIForVMRequest());
        VMDetailRequest request = new VMDetailRequest(varURI);
        VMResponse response = this.getOCLDebugTarget().sendRequest(request);
        if (response instanceof VMDetailResponse) {
            VMDetailResponse detailResponse = (VMDetailResponse)response;
            return detailResponse.getDetail();
        }
        return "";
    }

    @NonNull
    private String getVariableURIForVMRequest() {
        String variableURI = this.vmVar.variableURI;
        if (variableURI == null) {
            variableURI = this.vmVar.name;
        }
        return variableURI;
    }

    List<VMVariableData> requestVariables() throws DebugException {
        String variableURI = this.getVariableURIForVMRequest();
        VMVariableRequest request = new VMVariableRequest(this.frameID, variableURI, true);
        VMResponse response = this.getOCLDebugTarget().sendRequest(request);
        if (response instanceof VMVariableResponse) {
            VMVariableResponse variableResponse = (VMVariableResponse)response;
            if (variableResponse.childVariables != null) {
                return Arrays.asList(variableResponse.childVariables);
            }
        }
        return Collections.emptyList();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }
}

