/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.data.VMTypeData;
import org.eclipse.ocl.examples.debug.vm.data.VMValueData;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.request.VMVariableRequest;
import org.eclipse.ocl.examples.debug.vm.response.VMResponse;
import org.eclipse.ocl.examples.debug.vm.response.VMVariableResponse;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;

public class VariableFinder {
    @NonNull
    private final IVMEvaluationEnvironment<?> fEvalEnv;
    private final boolean fIsStoreValues;
    @Nullable
    private VMVariableData fTargetVar;
    @Nullable
    private String fRootDeclaredType;

    @Nullable
    public static String computeDetail(@NonNull URI variableURI, @NonNull IVMEvaluationEnvironment<?> fEvalEnv) {
        VariableFinder finder = new VariableFinder(fEvalEnv, true);
        String[] variablePath = VariableFinder.getVariablePath(variableURI);
        Object valueObject = finder.findStackObject(variablePath);
        if (valueObject != null) {
            try {
                return valueObject.toString();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    @NonNull
    public static URI createURI(@NonNull String[] varPath) {
        return VariableFinder.createURI(varPath, varPath.length - 1);
    }

    @NonNull
    public static URI createURI(@NonNull String[] varPath, int endIndex) {
        String[] segments = new String[endIndex + 1];
        int i = 0;
        while (i < segments.length) {
            segments[i] = URI.encodeSegment((String)varPath[i], (boolean)true);
            ++i;
        }
        URI hierarchicalURI = URI.createHierarchicalURI((String[])segments, null, null);
        return hierarchicalURI;
    }

    @NonNull
    public static List<EStructuralFeature> getAllFeatures(@NonNull EClass eClass) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        features.addAll((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
        Collections.sort(features, new Comparator<EStructuralFeature>(){

            @Override
            public int compare(EStructuralFeature var1, EStructuralFeature var2) {
                String n1 = var1.getName();
                String n2 = var2.getName();
                if (n1 == null) {
                    n1 = "";
                }
                if (n2 == null) {
                    n2 = "";
                }
                return n1.compareTo(n2);
            }
        });
        return features;
    }

    @NonNull
    private static String getOCLType(@NonNull EStructuralFeature feature) {
        return VariableFinder.getOCLType(feature.getEType(), feature.isUnique(), feature.isOrdered(), feature.getLowerBound(), feature.getUpperBound());
    }

    @NonNull
    private static String getOCLType(@Nullable EClassifier eType, boolean isUnique, boolean isOrdered, int lowerBound, int upperBound) {
        StringBuilder s = new StringBuilder();
        if (eType == null) {
            s.append("null");
        } else if (upperBound != 1) {
            if (isUnique) {
                s.append(isOrdered ? "OrderedSet" : "Set");
            } else {
                s.append(isOrdered ? "Sequence" : "Bag");
            }
            s.append("(");
            s.append(eType.getName());
            DomainUtil.formatMultiplicity((StringBuilder)s, (long)lowerBound, (long)upperBound);
            s.append(")");
        } else {
            s.append(eType.getName());
        }
        String string = s.toString();
        return string;
    }

    public static String getRootVarName(URI variableURI) {
        if (variableURI.segmentCount() == 0) {
            throw new IllegalArgumentException();
        }
        return URI.decode((String)variableURI.segment(0));
    }

    @NonNull
    public static List<VMVariableData> getVariables(@NonNull IVMEvaluationEnvironment<?> evalEnv) {
        VMVariableData var;
        ArrayList<VMVariableData> result = new ArrayList<VMVariableData>();
        for (DomainTypedElement variable : evalEnv.getVariables()) {
            String varName = variable.getName();
            if (variable instanceof OCLExpression) {
                OCLExpression oclExpression = (OCLExpression)variable;
                varName = VariableFinder.getTermVariableName(oclExpression);
                if (varName == null) continue;
                var = new VMVariableData(varName, null);
                var.kind = 0;
                Object value = null;
                try {
                    var.valueObject = value = evalEnv.getValueOf((DomainTypedElement)oclExpression);
                }
                catch (Throwable e) {
                    value = e;
                }
                Type declaredType = oclExpression.getType();
                VariableFinder.setValueAndType(var, value, (DomainType)declaredType, evalEnv);
                result.add(var);
                continue;
            }
            if (varName == null) continue;
            VMVariableData var2 = new VMVariableData(varName, null);
            if (VariableFinder.isPredefinedVar(varName, evalEnv)) {
                var2.kind = 3;
            }
            Object value = null;
            try {
                var2.valueObject = value = evalEnv.getValueOf(variable);
            }
            catch (Throwable e) {
                value = e;
            }
            DomainType declaredType = variable.getType();
            VariableFinder.setValueAndType(var2, value, declaredType, evalEnv);
            result.add(var2);
        }
        Map<String, Resource> modelParameterVariables = evalEnv.getModelParameterVariables();
        for (String modelParam : modelParameterVariables.keySet()) {
            if (modelParam == null) continue;
            Resource model = modelParameterVariables.get(modelParam);
            var = new VMVariableData(modelParam, null);
            VariableFinder.setValueAndType(var, (Object)model, model != null ? model.getURI().toString() : "$middle$", evalEnv);
            var.kind = 4;
            result.add(var);
        }
        return result;
    }

    private static boolean isPredefinedVar(String name, @NonNull IVMEvaluationEnvironment<?> evalEnv) {
        if (("self".equals(name) || "result".equals(name)) && evalEnv.getOperation() != null) {
            return true;
        }
        return "this".equals(name);
    }

    @NonNull
    public static String[] getVariablePath(@NonNull URI variableURI) {
        String[] ids = new String[variableURI.segmentCount()];
        int i = 0;
        while (i < ids.length) {
            ids[i] = URI.decode((String)variableURI.segment(i));
            ++i;
        }
        return ids;
    }

    @NonNull
    public static URI parseURI(String variableURI) throws IllegalArgumentException {
        return URI.createURI((String)variableURI);
    }

    public static VMResponse process(@NonNull VMVariableRequest request, @NonNull List<UnitLocation> stack, @NonNull IVMEvaluationEnvironment<?> fEvalEnv) {
        VMVariableData variable0;
        UnitLocation location = VMVirtualMachine.lookupEnvironmentByID(request.frameID, stack);
        if (location == null) {
            return VMResponse.createERROR();
        }
        String variableURIStr = request.variableURI;
        URI variableURI = VariableFinder.parseURI(variableURIStr);
        String[] variablePath = VariableFinder.getVariablePath(variableURI);
        VariableFinder variableManager = new VariableFinder(fEvalEnv, true);
        ArrayList<VMVariableData> variables = new ArrayList<VMVariableData>();
        variableManager.find(variablePath, request.includeChildVars, variables);
        if (variables.isEmpty()) {
            return VMResponse.createERROR();
        }
        VMVariableData[] children = null;
        int size = variables.size();
        if (size > 1) {
            children = variables.subList(1, size).toArray(new VMVariableData[size - 1]);
        }
        return (variable0 = (VMVariableData)variables.get(0)) != null ? new VMVariableResponse(variable0, children) : null;
    }

    private static EClass selectEClass(EClass eClass, int index) {
        EList superClasses;
        if (index > 0 && index < (superClasses = eClass.getEAllSuperTypes()).size()) {
            return (EClass)superClasses.get(index);
        }
        return eClass;
    }

    public static void setValueAndType(@NonNull VMVariableData variable, @Nullable Object value, @Nullable DomainType optDeclaredType, @NonNull EvaluationEnvironment evalEnv) {
        String declaredTypeName = optDeclaredType != null ? optDeclaredType.toString() : null;
        VariableFinder.setValueAndType(variable, value, declaredTypeName, evalEnv);
    }

    public static void setValueAndType(@NonNull VMVariableData variable, @Nullable Object value, @Nullable EClassifier optDeclaredType, @NonNull EvaluationEnvironment evalEnv) {
        String declaredTypeName = optDeclaredType != null ? optDeclaredType.getName() : null;
        VariableFinder.setValueAndType(variable, value, declaredTypeName, evalEnv);
    }

    public static void setValueAndType(@NonNull VMVariableData variable, @Nullable Object value, @Nullable String declaredTypeName, @NonNull EvaluationEnvironment evalEnv) {
        VMValueData vmValue;
        VMTypeData vmType;
        if (value == null) {
            vmType = new VMTypeData(0, "OclVoid", declaredTypeName);
            vmValue = null;
        } else if (value instanceof InvalidValueException) {
            vmValue = new VMValueData(3, "invalid - " + ((InvalidValueException)value).getMessage());
            vmType = new VMTypeData(0, "OclInvalid", declaredTypeName);
        } else if (value instanceof Resource) {
            Resource resource = (Resource)value;
            String strVal = String.valueOf(resource.getURI());
            vmValue = new VMValueData(4, strVal, true);
            String className = resource.getClass().getSimpleName();
            vmType = new VMTypeData(1, className, declaredTypeName);
        } else if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            EClass eClass = eObject.eClass();
            String qualifiedName = eClass != null ? String.valueOf(eClass.getEPackage().getName()) + "::" + eClass.getName() : eObject.getClass().getSimpleName();
            String strVal = String.valueOf(qualifiedName) + " @" + Integer.toHexString(System.identityHashCode(value));
            boolean hasVariables = eClass == null || !eClass.getEAllStructuralFeatures().isEmpty() || value instanceof Resource;
            vmValue = new VMValueData(1, strVal, hasVariables);
            String className = eClass != null ? eClass.getName() : eObject.getClass().getSimpleName();
            vmType = new VMTypeData(1, className, declaredTypeName);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Class<?> javaType = value.getClass();
            StringBuilder strVal = new StringBuilder();
            if (declaredTypeName != null) {
                strVal.append(declaredTypeName);
            } else {
                strVal.append(javaType.getSimpleName());
            }
            strVal.append('[').append(collection.size()).append(']');
            String string = strVal.toString();
            vmValue = new VMValueData(2, string, !collection.isEmpty());
            String className = javaType.getSimpleName();
            vmType = new VMTypeData(2, className, declaredTypeName);
        } else if (value instanceof CollectionValue) {
            CollectionValue collection = (CollectionValue)value;
            Class<?> javaType = value.getClass();
            StringBuilder strVal = new StringBuilder();
            if (declaredTypeName != null) {
                strVal.append(declaredTypeName);
            } else {
                strVal.append(javaType.getSimpleName());
            }
            strVal.append('[').append(collection.size()).append(']');
            String string = strVal.toString();
            vmValue = new VMValueData(2, string, collection.isEmpty() == false);
            String className = javaType.getSimpleName();
            vmType = new VMTypeData(2, className, declaredTypeName);
        } else {
            String valueOf = String.valueOf(value);
            if (value.getClass().equals(String.class)) {
                valueOf = "'" + valueOf + "'";
            }
            vmValue = new VMValueData(0, valueOf);
            String className = value.getClass().getSimpleName();
            vmType = new VMTypeData(0, className, declaredTypeName);
        }
        variable.type = vmType;
        variable.value = vmValue;
    }

    public VariableFinder(@NonNull IVMEvaluationEnvironment<?> fEvalEnv, boolean isStoreValues) {
        this.fEvalEnv = fEvalEnv;
        this.fIsStoreValues = isStoreValues;
    }

    public void collectChildVars(Object root, @NonNull String[] parentPath, @Nullable String containerType, @NonNull List<VMVariableData> result) {
        block5: {
            Collection elements;
            String[] childPath;
            block6: {
                block4: {
                    childPath = new String[parentPath.length + 1];
                    System.arraycopy(parentPath, 0, childPath, 0, parentPath.length);
                    if (root instanceof Resource) {
                        Resource model = (Resource)root;
                        root = model.getContents();
                        containerType = "(EClassifier)EcoreEnvironmentFactory.INSTANCE.createEnvironment().getOCLFactory().createSetType(QvtOperationalStdLibrary.INSTANCE.getElementType())";
                    }
                    if (!(root instanceof EObject)) break block4;
                    EObject eObject = (EObject)root;
                    EClass eClass = eObject.eClass();
                    StringBuilder uriBuf = new StringBuilder();
                    List<EStructuralFeature> eAllFeatures = VariableFinder.getAllFeatures(eClass);
                    EList superClasses = eClass.getEAllSuperTypes();
                    for (EStructuralFeature feature : eAllFeatures) {
                        EClass owner = feature.getEContainingClass();
                        int index = superClasses.indexOf(owner);
                        uriBuf.append(index < 0 ? 0 : index);
                        uriBuf.append('.').append(feature.getName());
                        childPath[childPath.length - 1] = uriBuf.toString();
                        VMVariableData elementVar = this.createFeatureVar(feature, this.getValue(feature, eObject), VariableFinder.createURI(childPath).toString());
                        result.add(elementVar);
                        uriBuf.setLength(0);
                    }
                    break block5;
                }
                if (!(root instanceof Collection)) break block6;
                elements = (Collection)root;
                String elementType = "(containerType instanceof CollectionType) ? ((CollectionType) containerType) .getElementType() : fFeatureAccessor.getStandardLibrary().getOclAny()";
                int i = 0;
                for (Object element : elements) {
                    childPath[childPath.length - 1] = String.valueOf(i);
                    VMVariableData elementVar = this.createCollectionElementVar(i, element, elementType, VariableFinder.createURI(childPath).toString());
                    result.add(elementVar);
                    ++i;
                }
                break block5;
            }
            if (!(root instanceof CollectionValue)) break block5;
            elements = (CollectionValue)root;
            String elementType = "(containerType instanceof CollectionType) ? ((CollectionType) containerType) .getElementType() : fFeatureAccessor.getStandardLibrary().getOclAny()";
            int i = 0;
            for (Object element : elements) {
                childPath[childPath.length - 1] = String.valueOf(i);
                VMVariableData elementVar = this.createCollectionElementVar(i, element, elementType, VariableFinder.createURI(childPath).toString());
                result.add(elementVar);
                ++i;
            }
        }
    }

    @NonNull
    private VMVariableData createCollectionElementVar(int elementIndex, Object element, @Nullable String elementType, String uri) {
        String varName = "[" + elementIndex + "]";
        int kind = 6;
        return this.createVariable(varName, kind, elementType, element, uri);
    }

    @NonNull
    private VMVariableData createFeatureVar(@NonNull EStructuralFeature feature, Object value, String uri) {
        String varName = (String)DomainUtil.nonNullModel((Object)feature.getName());
        String declaredType = VariableFinder.getOCLType(feature);
        int kind = 1;
        if (feature instanceof EReference) {
            kind = 2;
        }
        return this.createVariable(varName, kind, declaredType, value, uri);
    }

    @NonNull
    private VMVariableData createVariable(@NonNull String varName, int kind, @Nullable String declaredType, Object varObj, String uri) {
        VMVariableData result = new VMVariableData(varName, uri);
        result.kind = kind;
        VariableFinder.setValueAndType(result, varObj, declaredType, this.fEvalEnv);
        if (this.fIsStoreValues) {
            result.valueObject = varObj;
        }
        return result;
    }

    public void find(@NonNull String[] objectPath, boolean fetchChildVariables, @NonNull List<VMVariableData> result) {
        if (result.contains(null)) {
            throw new IllegalArgumentException("null result variables");
        }
        try {
            Object referencedObj = this.findStackObject(objectPath);
            VMVariableData variable = this.fTargetVar;
            if (variable != null) {
                result.add(variable);
                if (fetchChildVariables) {
                    this.collectChildVars(referencedObj, objectPath, this.fRootDeclaredType, result);
                }
            }
        }
        finally {
            this.fTargetVar = null;
        }
    }

    private Object findChildObject(Object parentObj, @Nullable String optParentDeclaredType, @NonNull String[] varTreePath, int pathIndex) {
        int nextIndex;
        Collection collection;
        URI uri = VariableFinder.createURI(varTreePath, pathIndex);
        VMVariableData childVar = null;
        Object nextObject = null;
        String nextDeclaredType = null;
        if (parentObj instanceof Resource) {
            parentObj = ((Resource)parentObj).getContents();
            nextDeclaredType = "QvtOperationalStdLibrary.INSTANCE.getElementType()";
        }
        if (parentObj instanceof EObject) {
            EObject eObject = (EObject)parentObj;
            EStructuralFeature eFeature = this.findFeature((String)DomainUtil.nonNullState((Object)varTreePath[pathIndex]), eObject.eClass());
            if (eFeature != null) {
                Object value = this.getValue(eFeature, eObject);
                childVar = this.createFeatureVar(eFeature, value, uri.toString());
                nextObject = value;
                nextDeclaredType = VariableFinder.getOCLType(eFeature);
            }
        } else if (parentObj instanceof Collection) {
            collection = (Collection)parentObj;
            int elementIndex = -1;
            try {
                elementIndex = Integer.parseInt(varTreePath[pathIndex]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
            if (elementIndex < 0 || elementIndex >= collection.size()) {
                throw new IllegalArgumentException();
            }
            nextDeclaredType = "OclAny";
            Object element = this.getElement(collection, elementIndex);
            childVar = this.createCollectionElementVar(elementIndex, element, nextDeclaredType, uri.toString());
            nextObject = element;
        } else if (parentObj instanceof CollectionValue) {
            collection = (CollectionValue)parentObj;
            int elementIndex = -1;
            try {
                elementIndex = Integer.parseInt(varTreePath[pathIndex]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
            if (elementIndex < 0 || elementIndex >= collection.intSize()) {
                throw new IllegalArgumentException();
            }
            nextDeclaredType = "OclAny";
            Object element = this.getElement(collection.getElements(), elementIndex);
            childVar = this.createCollectionElementVar(elementIndex, element, nextDeclaredType, uri.toString());
            nextObject = element;
        }
        if ((nextIndex = pathIndex + 1) < varTreePath.length) {
            if (nextObject != null) {
                return this.findChildObject(nextObject, nextDeclaredType, varTreePath, nextIndex);
            }
            return null;
        }
        this.fTargetVar = childVar;
        return nextObject;
    }

    @Nullable
    private Object findStackObject(@NonNull String[] varTreePath) {
        Object rootObj = null;
        boolean gotIt = false;
        String envVarName = (String)DomainUtil.nonNullState((Object)varTreePath[0]);
        if (envVarName.startsWith("$")) {
            IVMEvaluationEnvironment<?> evalEnv = this.fEvalEnv;
            while (evalEnv != null) {
                for (DomainTypedElement localVariable : evalEnv.getVariables()) {
                    OCLExpression oclExpression;
                    String varName;
                    if (!(localVariable instanceof OCLExpression) || !envVarName.equals(varName = VariableFinder.getTermVariableName(oclExpression = (OCLExpression)localVariable))) continue;
                    rootObj = this.fEvalEnv.getValueOf(localVariable);
                    gotIt = true;
                    break;
                }
                if (gotIt) break;
                evalEnv = evalEnv.getParentEvaluationEnvironment();
            }
        }
        if (!gotIt) {
            HashSet variables = new HashSet();
            IVMEvaluationEnvironment<?> evalEnv = this.fEvalEnv;
            while (evalEnv != null) {
                Set localVariables = evalEnv.getVariables();
                variables.addAll(localVariables);
                if (DomainUtil.getNamedElement((Iterable)localVariables, (String)"self") != null) break;
                evalEnv = evalEnv.getParentEvaluationEnvironment();
            }
            rootObj = DomainUtil.getNamedElement(variables, (String)envVarName);
            if (rootObj instanceof Variable) {
                rootObj = this.fEvalEnv.getValueOf((DomainTypedElement)rootObj);
                gotIt = true;
            }
        }
        if (!gotIt) {
            rootObj = this.fEvalEnv.getModelParameterVariables().get(envVarName);
        }
        this.fRootDeclaredType = rootObj instanceof EObject ? ((EObject)rootObj).eClass().getName() : (rootObj instanceof Value ? ((Value)rootObj).getTypeId().toString() : "evalEnv.getTypeOf(envVarName)");
        if (rootObj != null && varTreePath.length == 1) {
            String[] uri = new String[]{envVarName};
            this.fTargetVar = this.createVariable(envVarName, 0, this.fRootDeclaredType, rootObj, VariableFinder.createURI(uri).toString());
            return rootObj;
        }
        if (rootObj == null) {
            return null;
        }
        return this.findChildObject(rootObj, this.fRootDeclaredType, varTreePath, 1);
    }

    @Nullable
    private Object getElement(@NonNull Collection<?> collection, int index) {
        if (collection instanceof EList) {
            EList eList = (EList)collection;
            return eList.get(index);
        }
        int curr = 0;
        for (Object object : collection) {
            if (curr++ != index) continue;
            return object;
        }
        return null;
    }

    @Nullable
    private EStructuralFeature findFeature(@NonNull String featureRef, EClass actualTarget) {
        String featureName;
        int classIndex;
        String actualRef = featureRef.startsWith("+") ? featureRef.substring(1) : featureRef;
        boolean isIntermediate = featureRef.length() != actualRef.length();
        try {
            int delimiterPos = actualRef.indexOf(46);
            if (delimiterPos <= 0 || delimiterPos >= actualRef.length() - 1) {
                throw new IllegalArgumentException("navigatin feature: " + actualRef);
            }
            classIndex = Integer.parseInt(actualRef.substring(0, delimiterPos));
            featureName = actualRef.substring(delimiterPos + 1);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal feature reference: " + featureRef);
        }
        EClass featureOwner = VariableFinder.selectEClass(actualTarget, classIndex);
        if (featureOwner == null) {
            return null;
        }
        if (!isIntermediate) {
            return featureOwner.getEStructuralFeature(featureName);
        }
        return null;
    }

    protected static String getTermVariableName(@NonNull OCLExpression oclExpression) {
        Object eGet;
        EObject eContainer;
        EStructuralFeature eContainingFeature = oclExpression.eContainingFeature();
        if (eContainingFeature == null) {
            return null;
        }
        String varName = "$" + eContainingFeature.getName();
        if (eContainingFeature.isMany() && (eContainer = oclExpression.eContainer()) != null && (eGet = eContainer.eGet(eContainingFeature)) instanceof List) {
            int index = ((List)eGet).indexOf(oclExpression);
            varName = String.valueOf(varName) + "[" + index + "]";
        }
        return varName;
    }

    public Object getValue(EStructuralFeature feature, EObject target) {
        return this.navigateProperty(feature, null, target);
    }

    public Object navigateProperty(EStructuralFeature property, List<?> qualifiers, Object target) throws IllegalArgumentException {
        EStructuralFeature resolvedProperty = property;
        try {
            return this.superNavigateProperty(resolvedProperty, qualifiers, target);
        }
        catch (IllegalArgumentException e) {
            this.fEvalEnv.throwVMException(new VMRuntimeException("Unknown property '" + property.getName() + "'", e));
            return ValuesUtil.INVALID_VALUE;
        }
    }

    public Object superNavigateProperty(EStructuralFeature property, List<?> qualifiers, Object target) throws IllegalArgumentException {
        EObject etarget;
        if (target instanceof EObject && (etarget = (EObject)target).eClass().getEAllStructuralFeatures().contains((Object)property)) {
            if (property.getEType() instanceof VoidType) {
                return null;
            }
            return etarget.eGet(property);
        }
        throw new IllegalArgumentException();
    }
}

