/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.CompiledUnit;
import org.eclipse.ocl.examples.debug.vm.utils.LineNumberProvider;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;

public class ValidBreakpointLocator {
    @NonNull
    public static final Boolean IS_START = Boolean.TRUE;
    @NonNull
    public static final Boolean IS_END = Boolean.FALSE;
    @NonNull
    private static final List<Element> NO_ELEMENTS = Collections.emptyList();
    @NonNull
    private final AbstractExtendingVisitor<Boolean, Object> visitor;

    public ValidBreakpointLocator(@NonNull AbstractExtendingVisitor<Boolean, Object> visitor) {
        this.visitor = visitor;
    }

    @NonNull
    public List<Element> getBreakpointableElementsForLine(@NonNull CompiledUnit compiledModule, @NonNull LineNumberProvider lineNumbers, int lineNumber) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (NamedElement nextModule : compiledModule.getModules()) {
            TreeIterator tit = nextModule.eAllContents();
            while (tit.hasNext()) {
                int line;
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Element)) continue;
                Element element = (Element)eObject;
                boolean found = false;
                Boolean isStartNotEnd = (Boolean)element.accept(this.visitor);
                if (isStartNotEnd == IS_START && (line = lineNumbers.getLineNumber(ASTBindingHelper.getStartPosition(element))) == lineNumber) {
                    elements.add(element);
                    found = true;
                }
                if (found || isStartNotEnd != IS_END || (line = lineNumbers.getLineNumber(ASTBindingHelper.getEndPosition(element))) != lineNumber) continue;
                elements.add(element);
            }
        }
        if (!elements.isEmpty()) {
            return elements;
        }
        return NO_ELEMENTS;
    }

    public boolean isBreakpointableElementEnd(@NonNull Element element) {
        return element.accept(this.visitor) == IS_END;
    }

    public boolean isBreakpointableElementStart(@NonNull Element element) {
        return element.accept(this.visitor) == IS_START;
    }
}

