/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.event.VMEvent;
import org.eclipse.ocl.examples.debug.vm.request.VMConnectRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMRequest;
import org.eclipse.ocl.examples.debug.vm.response.VMConnectResponse;
import org.eclipse.ocl.examples.debug.vm.response.VMResponse;
import org.eclipse.ocl.examples.debug.vm.utils.SocketUtil;

class VMRemoteClient {
    public static final int CONNECT_ATTEMPTS = 100;
    public static final int CONNECT_ATTEMPT_DELAY = 200;
    @NonNull
    protected final VMDebugCore debugCore;
    private InetSocketAddress fAddress;
    private Socket fRequestSocket;
    private ObjectOutputStream fRequestOut;
    private ObjectInputStream fResponseIn;
    private InputStream fResponseIS;
    private Socket fEventSocket;
    private int fEventPort;
    private ObjectInputStream fEventObjInput;

    VMRemoteClient(@NonNull VMDebugCore debugCore, String host, int requestPort, Monitor monitor) throws IOException {
        this.debugCore = debugCore;
        this.fAddress = new InetSocketAddress(host, requestPort);
        this.fRequestSocket = this.connect(this.fAddress, 100, monitor);
        this.fRequestOut = new ObjectOutputStream(this.fRequestSocket.getOutputStream());
        this.fResponseIS = this.fRequestSocket.getInputStream();
        VMResponse response = this.sendRequest(new VMConnectRequest());
        if (!(response instanceof VMConnectResponse)) {
            throw new IOException("No free port for event dispatcher");
        }
        VMConnectResponse connectResponse = (VMConnectResponse)response;
        this.fEventPort = connectResponse.getEventPort();
    }

    VMEvent readEvent() throws IOException {
        if (this.fEventObjInput == null) {
            assert (this.fRequestSocket != null);
            InetSocketAddress eventSocketAddress = new InetSocketAddress(this.fAddress.getAddress(), this.fEventPort);
            int attemptCount = 3;
            Socket eventSocket = this.connect(eventSocketAddress, attemptCount, null);
            this.fEventObjInput = new ObjectInputStream(eventSocket.getInputStream());
        }
        try {
            return (VMEvent)this.fEventObjInput.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.toString());
        }
    }

    VMResponse sendRequest(VMRequest request) throws IOException {
        this.fRequestOut.writeObject(request);
        this.fRequestOut.flush();
        try {
            Object readObject;
            if (this.fResponseIn == null) {
                this.fResponseIn = new ObjectInputStream(this.fResponseIS);
            }
            if (!((readObject = this.fResponseIn.readObject()) instanceof VMResponse)) {
                return VMResponse.createERROR();
            }
            return (VMResponse)readObject;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.toString());
        }
    }

    void close() throws IOException {
        SocketUtil socketUtil = new SocketUtil(this.debugCore);
        socketUtil.close(this.fRequestOut);
        socketUtil.close(this.fResponseIn);
        socketUtil.close(this.fRequestSocket);
        socketUtil.close(this.fEventObjInput);
        socketUtil.close(this.fEventSocket);
    }

    private Socket connect(InetSocketAddress address, int attemptCount, Monitor monitor) throws IOException {
        Socket socket = null;
        int attempts = attemptCount;
        while (attempts-- > 0) {
            try {
                socket = new Socket(address.getAddress(), address.getPort());
                break;
            }
            catch (IOException e) {
                if (attempts == 0 || monitor != null && monitor.isCanceled()) {
                    throw e;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e2) {
                    Thread.interrupted();
                }
            }
        }
        assert (socket != null);
        return socket;
    }
}

