/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.emf.providers.EMFContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ProjectCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.provider.CSSStyleSheetLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.ModelStyleSheets;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsPackage;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.views.properties.creation.EcorePropertyEditorFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheetsPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final String PREFERENCE_PAGE_LABEL = Messages.getString("StyleSheetsPropertyPage.preference.page.label");
    private static final String PREFERENCE_PAGE_TITLE = Messages.getString("StyleSheetsPropertyPage.preference.page.title");
    private static final Image DELETE_ICON = Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"/icons/Delete_12x12.gif").createImage();
    private static final Image ADD_ICON = Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"/icons/Add_12x12.gif").createImage();
    private static final Image EDIT_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Edit_12x12.gif").createImage();
    private static final Image UP_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Up_12x12.gif").createImage();
    private static final Image DOWN_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Down_12x12.gif").createImage();
    private static final int ADD_BUTTON_ID = 1;
    private static final int DELETE_BUTTON_ID = 2;
    private static final int UP_BUTTON_ID = 3;
    private static final int DOWN_BUTTON_ID = 4;
    private static final int EDIT_BUTTON_ID = 0;
    private Resource resource = null;
    private ModelStyleSheets modelStyleSheets = null;
    private IContentProvider contentProvider = null;
    private ILabelProvider labelProvider = null;
    private TreeViewer styleSheetsViewer = null;
    private Map<Integer, Button> buttonsMap = new HashMap<Integer, Button>();
    private ReferenceValueFactory editorFactory = new EcorePropertyEditorFactory(StylesheetsPackage.Literals.MODEL_STYLE_SHEETS__STYLESHEETS);

    public StyleSheetsPropertyPage() {
        this.setPreferenceStore(null);
        this.noDefaultAndApplyButton();
    }

    private EList<EObject> getProjectStylesheets() {
        ProjectScope pageProject;
        IPath preferencePath;
        Object pageElement = this.getElement().getAdapter(IProject.class);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EList styleSheetsList = null;
        if (pageElement instanceof IProject && (preferencePath = (pageProject = new ProjectScope((IProject)pageElement)).getLocation().append(ProjectCSSEngine.PROJECT_STYLESHEETS)) != null) {
            IPath projectRelativePath = preferencePath.makeRelativeTo(((IProject)pageElement).getLocation());
            IFile preferenceFile = ((IProject)pageElement).getFile(projectRelativePath);
            if (preferenceFile.exists()) {
                this.resource = resourceSet.getResource(URI.createPlatformResourceURI((String)preferenceFile.getFullPath().toOSString(), (boolean)true), true);
                styleSheetsList = this.resource.getContents();
            } else {
                this.resource = resourceSet.createResource(URI.createPlatformResourceURI((String)preferenceFile.getFullPath().toOSString(), (boolean)true));
                styleSheetsList = this.resource.getContents();
            }
        }
        return styleSheetsList;
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(2, false);
        container.setLayout((Layout)containerLayout);
        this.initializeDataPage();
        this.initializeProviders();
        this.createLabelPage(container);
        this.createStyleSheetsPageViewer(container);
        this.createStyleSheetsPageButtons(container);
        this.updateButtons();
        return container;
    }

    private void createLabelPage(Composite parent) {
        Label labelPage = new Label(parent, 0);
        GridData layoutData = new GridData(4);
        layoutData.horizontalSpan = 2;
        labelPage.setLayoutData((Object)layoutData);
        labelPage.setText(PREFERENCE_PAGE_LABEL);
    }

    private void initializeDataPage() {
        EList<EObject> stylesheetsModel = this.getProjectStylesheets();
        this.modelStyleSheets = (ModelStyleSheets)StylesheetsPackage.eINSTANCE.getEFactoryInstance().create(StylesheetsPackage.Literals.MODEL_STYLE_SHEETS);
        this.modelStyleSheets.getStylesheets();
        ArrayList<EObject> mirrorList = new ArrayList<EObject>();
        mirrorList.addAll((Collection<EObject>)stylesheetsModel);
        for (EObject object : mirrorList) {
            if (!(object instanceof StyleSheet)) continue;
            this.modelStyleSheets.getStylesheets().add((Object)((StyleSheet)object));
        }
    }

    private void initializeProviders() {
        this.contentProvider = new EMFContentProvider((EObject)this.modelStyleSheets, (EStructuralFeature)StylesheetsPackage.eINSTANCE.getModelStyleSheets_Stylesheets()){

            protected IStructuredContentProvider getSemanticProvider(final EObject editedEObject, EStructuralFeature feature) {
                return new AbstractStaticContentProvider(){

                    public Object[] getElements() {
                        LinkedList result = new LinkedList();
                        if (editedEObject instanceof ModelStyleSheets) {
                            result.addAll(StyleSheetsPropertyPage.this.modelStyleSheets.getStylesheets());
                        }
                        return result.toArray();
                    }
                };
            }
        };
        this.labelProvider = new CSSStyleSheetLabelProvider();
    }

    private void createStyleSheetsPageViewer(Composite parent) {
        this.styleSheetsViewer = new TreeViewer(parent);
        this.styleSheetsViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.styleSheetsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StyleSheetsPropertyPage.this.updateButtons();
            }
        });
        this.styleSheetsViewer.setContentProvider(this.contentProvider);
        this.styleSheetsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.styleSheetsViewer.setInput((Object)this.modelStyleSheets);
    }

    private void createStyleSheetsPageButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayout((Layout)new GridLayout());
        buttonsComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        this.createButton(buttonsComposite, ADD_ICON, 1);
        this.createButton(buttonsComposite, DELETE_ICON, 2);
        this.createButton(buttonsComposite, UP_ICON, 3);
        this.createButton(buttonsComposite, DOWN_ICON, 4);
        this.createButton(buttonsComposite, EDIT_ICON, 0);
    }

    private void createButton(Composite parent, Image icon, int id) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(4, 4, true, true));
        button.setData((Object)new Integer(id));
        button.setImage(icon);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StyleSheetsPropertyPage.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        this.buttonsMap.put(id, button);
    }

    protected void refreshStyleSheets(Object[] result) {
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof StyleSheet) {
                this.modelStyleSheets.getStylesheets().add((Object)((StyleSheet)object));
            }
            ++n2;
        }
        this.styleSheetsViewer.setInput((Object)this.modelStyleSheets);
        this.updateButtons();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1: {
                this.addAction();
                break;
            }
            case 2: {
                this.deleteAction();
                break;
            }
            case 4: {
                this.downAction();
                break;
            }
            case 3: {
                this.upAction();
                break;
            }
            case 0: {
                this.editAction();
                break;
            }
        }
    }

    private void editAction() {
        Object selectedObject;
        ISelection selection = this.styleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof StyleSheet) {
            this.editorFactory.edit((Control)this.buttonsMap.get(0), selectedObject);
        }
    }

    private void upAction() {
        EList stylesheetsList;
        int index;
        Object selectedElement;
        ISelection selection = this.styleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof StyleSheet && (index = (stylesheetsList = this.modelStyleSheets.getStylesheets()).indexOf(selectedElement)) > 0) {
            stylesheetsList.move(--index, (Object)((StyleSheet)selectedElement));
            this.styleSheetsViewer.setInput((Object)stylesheetsList);
        }
    }

    private void downAction() {
        EList stylesheetsList;
        int index;
        Object selectedElement;
        ISelection selection = this.styleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof StyleSheet && (index = (stylesheetsList = this.modelStyleSheets.getStylesheets()).indexOf(selectedElement)) < stylesheetsList.size() - 1) {
            stylesheetsList.move(++index, (Object)((StyleSheet)selectedElement));
            this.styleSheetsViewer.setInput((Object)stylesheetsList);
        }
    }

    private void deleteAction() {
        ISelection selection = this.styleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement instanceof StyleSheet) {
                this.modelStyleSheets.getStylesheets().remove(firstElement);
            }
            this.styleSheetsViewer.setInput((Object)this.modelStyleSheets);
            this.updateButtons();
        }
    }

    private void addAction() {
        Object[] resultArray;
        ReferenceSelector selector = new ReferenceSelector(true);
        selector.setContentProvider((IStaticContentProvider)this.contentProvider);
        selector.setLabelProvider(this.labelProvider);
        MultipleValueSelectorDialog vDialog = new MultipleValueSelectorDialog(this.getShell(), (IElementSelector)selector, PREFERENCE_PAGE_TITLE);
        vDialog.setContextElement((Object)this.modelStyleSheets);
        vDialog.setLabelProvider(this.labelProvider);
        vDialog.setFactory(this.editorFactory);
        int result = vDialog.open();
        if (result == 0 && (resultArray = vDialog.getResult()) != null) {
            this.refreshStyleSheets(resultArray);
        }
    }

    protected void updateButtons() {
        ISelection selection = this.styleSheetsViewer.getSelection();
        boolean enabled = !selection.isEmpty();
        for (int idButton : this.buttonsMap.keySet()) {
            switch (idButton) {
                case 3: 
                case 4: {
                    EList stylesheets = this.modelStyleSheets.getStylesheets();
                    this.buttonsMap.get(idButton).setEnabled(enabled && !stylesheets.isEmpty() && stylesheets.size() > 1);
                    break;
                }
                case 0: 
                case 2: {
                    this.buttonsMap.get(idButton).setEnabled(enabled);
                    break;
                }
            }
        }
    }

    public boolean performOk() {
        boolean performOK = false;
        try {
            this.resource.getContents().addAll((Collection)this.modelStyleSheets.getStylesheets());
            this.resource.save(Collections.EMPTY_MAP);
            performOK = true;
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return performOK;
    }
}

