/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.extendedtypes.applystereotypeactionconfiguration;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.infra.extendedtypes.IActionCreationElementValidator;
import org.eclipse.papyrus.uml.tools.extendedtypes.applystereotypeactionconfiguration.ApplyStereotypeActionConfiguration;
import org.eclipse.papyrus.uml.tools.extendedtypes.applystereotypeactionconfiguration.StereotypeToApply;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyStereotypeActionCreationElementValidator
implements IActionCreationElementValidator<ApplyStereotypeActionConfiguration> {
    protected ApplyStereotypeActionConfiguration configuration;

    public boolean canCreate(CreateElementRequest request) {
        if (this.configuration == null) {
            return false;
        }
        if (!(request.getContainer() instanceof Element)) {
            return false;
        }
        Element container = (Element)request.getContainer();
        Package nearestPackage = container.getNearestPackage();
        if (nearestPackage == null) {
            return false;
        }
        EList appliedProfiles = nearestPackage.getAllAppliedProfiles();
        if (appliedProfiles == null) {
            return false;
        }
        ArrayList<String> appliedProfileNames = new ArrayList<String>();
        for (Profile profile : appliedProfiles) {
            appliedProfileNames.add(profile.getQualifiedName());
        }
        for (StereotypeToApply stereotypeToApply : this.configuration.getStereotypesToApply()) {
            EList<String> requiredProfiles = stereotypeToApply.getRequiredProfiles();
            if (requiredProfiles == null) continue;
            for (String requiredProfile : requiredProfiles) {
                if (appliedProfileNames.contains(requiredProfile)) continue;
                return false;
            }
        }
        return true;
    }

    public void init(ApplyStereotypeActionConfiguration configuration) {
        this.configuration = configuration;
    }
}

