/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import com.google.common.base.Optional;
import com.google.common.collect.MapMaker;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.AbstractReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyListener;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyEvent;
import org.eclipse.papyrus.infra.emf.readonly.IReadOnlyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyManager
implements IReadOnlyHandler2 {
    protected static final ConcurrentMap<EditingDomain, IReadOnlyHandler2> roHandlers = new MapMaker().weakKeys().weakValues().makeMap();
    private final CopyOnWriteArrayList<IReadOnlyListener> listeners = new CopyOnWriteArrayList();
    private IReadOnlyListener forwardingListener;
    protected static final Map<Class<?>, Set<ReadOnlyAxis>> orderedHandlerClasses;
    protected Map<ReadOnlyAxis, IReadOnlyHandler2[]> orderedHandlersByAxis;

    static {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.emf.readonly", "readOnlyHandler");
        LinkedList<HandlerPriorityPair> handlerPriorityPairs = new LinkedList<HandlerPriorityPair>();
        HashMap<String, HandlerPriorityPair> idMap = new HashMap<String, HandlerPriorityPair>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if ("readOnlyHandler".equals(elem.getName())) {
                try {
                    HandlerPriorityPair handlerPriorityPair = new HandlerPriorityPair();
                    String className = elem.getAttribute("class");
                    handlerPriorityPair.handlerClass = Platform.getBundle((String)elem.getContributor().getName()).loadClass(className);
                    handlerPriorityPair.priority = Integer.parseInt(elem.getAttribute("priority"));
                    IConfigurationElement[] affinities = elem.getChildren("affinity");
                    if (affinities == null || affinities.length == 0) {
                        handlerPriorityPair.axes = ReadOnlyAxis.anyAxis();
                    } else {
                        handlerPriorityPair.axes = EnumSet.noneOf(ReadOnlyAxis.class);
                        IConfigurationElement[] iConfigurationElementArray2 = affinities;
                        int n3 = affinities.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement next = iConfigurationElementArray2[n4];
                            handlerPriorityPair.axes.add(ReadOnlyAxis.valueOf((String)next.getAttribute("axis").toUpperCase()));
                            ++n4;
                        }
                    }
                    String id = elem.getAttribute("id");
                    if (id != null) {
                        HandlerPriorityPair oldHandler = (HandlerPriorityPair)idMap.get(id);
                        if (oldHandler == null) {
                            idMap.put(id, handlerPriorityPair);
                            handlerPriorityPairs.add(handlerPriorityPair);
                        } else if (oldHandler.priority < handlerPriorityPair.priority) {
                            handlerPriorityPairs.remove(oldHandler);
                            handlerPriorityPairs.add(handlerPriorityPair);
                        }
                    } else {
                        handlerPriorityPairs.add(handlerPriorityPair);
                    }
                }
                catch (Throwable t) {
                    Activator.log.error(t);
                }
            }
            ++n2;
        }
        Collections.sort(handlerPriorityPairs);
        orderedHandlerClasses = new LinkedHashMap();
        for (HandlerPriorityPair next : handlerPriorityPairs) {
            orderedHandlerClasses.put(next.handlerClass, next.axes);
        }
    }

    public static IReadOnlyHandler2 getReadOnlyHandler(EditingDomain editingDomain) {
        IReadOnlyHandler2 existing;
        IReadOnlyHandler2 roHandler = IReadOnlyHandler2.NULL;
        if (editingDomain != null && (roHandler = (IReadOnlyHandler2)roHandlers.get(editingDomain)) == null && (existing = roHandlers.putIfAbsent(editingDomain, roHandler = new ReadOnlyManager(editingDomain))) != null) {
            roHandler = existing;
        }
        return roHandler;
    }

    protected static IReadOnlyHandler2 create(Class<?> handlerClass, EditingDomain editingDomain) {
        boolean isEditingDomainConstructor = true;
        Constructor<?> constructor = null;
        try {
            constructor = handlerClass.getConstructor(EditingDomain.class);
            if (constructor == null) {
                isEditingDomainConstructor = false;
                constructor = handlerClass.getConstructor(new Class[0]);
            }
            if (IReadOnlyHandler2.class.isAssignableFrom(constructor.getDeclaringClass())) {
                if (isEditingDomainConstructor) {
                    return (IReadOnlyHandler2)constructor.newInstance(editingDomain);
                }
                return (IReadOnlyHandler2)constructor.newInstance(new Object[0]);
            }
            if (org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler.class.isAssignableFrom(constructor.getDeclaringClass())) {
                if (isEditingDomainConstructor) {
                    return AbstractReadOnlyHandler.adapt((org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler)((org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler)constructor.newInstance(editingDomain)), (EditingDomain)editingDomain);
                }
                return AbstractReadOnlyHandler.adapt((org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler)((org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler)constructor.newInstance(new Object[0])), (EditingDomain)editingDomain);
            }
            if (IReadOnlyHandler.class.isAssignableFrom(constructor.getDeclaringClass())) {
                return new OldStyleHandlerAdapter((IReadOnlyHandler)constructor.newInstance(new Object[0]), editingDomain);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public ReadOnlyManager(EditingDomain editingDomain) {
        EnumMap<ReadOnlyAxis, ArrayList<IReadOnlyHandler2>> handlers = new EnumMap<ReadOnlyAxis, ArrayList<IReadOnlyHandler2>>(ReadOnlyAxis.class);
        for (Map.Entry<Class<?>, Set<ReadOnlyAxis>> roClass : orderedHandlerClasses.entrySet()) {
            IReadOnlyHandler2 h = ReadOnlyManager.create(roClass.getKey(), editingDomain);
            if (h == null) continue;
            h.addReadOnlyListener(this.getForwardingListener());
            for (ReadOnlyAxis axis : roClass.getValue()) {
                ArrayList<IReadOnlyHandler2> list = (ArrayList<IReadOnlyHandler2>)handlers.get(axis);
                if (list == null) {
                    list = new ArrayList<IReadOnlyHandler2>();
                    handlers.put(axis, list);
                }
                list.add(h);
            }
        }
        this.orderedHandlersByAxis = new EnumMap<ReadOnlyAxis, IReadOnlyHandler2[]>(ReadOnlyAxis.class);
        ReadOnlyAxis[] readOnlyAxisArray = ReadOnlyAxis.values();
        int n = readOnlyAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReadOnlyAxis axis = readOnlyAxisArray[n2];
            List list = (List)handlers.get(axis);
            if (list == null) {
                this.orderedHandlersByAxis.put(axis, new IReadOnlyHandler2[0]);
            } else {
                this.orderedHandlersByAxis.put(axis, list.toArray(new IReadOnlyHandler2[list.size()]));
            }
            ++n2;
        }
    }

    public Optional<Boolean> anyReadOnly(Set<ReadOnlyAxis> axes, URI[] uris) {
        Optional<Boolean> result = Optional.absent();
        ReadOnlyAxis[] all = ReadOnlyAxis.values();
        int i = 0;
        while (i < all.length && !((Boolean)result.or((Object)Boolean.FALSE)).booleanValue()) {
            if (axes.contains(all[i])) {
                result = this.anyReadOnly(all[i], uris);
            }
            ++i;
        }
        return result.isPresent() ? result : Optional.of((Object)Boolean.FALSE);
    }

    private Optional<Boolean> anyReadOnly(ReadOnlyAxis axis, URI[] uris) {
        Set axes = axis.singleton();
        Optional result = Optional.absent();
        IReadOnlyHandler2[] orderedHandlers = this.orderedHandlersByAxis.get(axis);
        int i = 0;
        while (i < orderedHandlers.length && !result.isPresent()) {
            result = orderedHandlers[i].anyReadOnly(axes, uris);
            ++i;
        }
        return result.isPresent() ? result : Optional.of((Object)Boolean.FALSE);
    }

    public Optional<Boolean> isReadOnly(Set<ReadOnlyAxis> axes, EObject eObject) {
        Optional<Boolean> result = Optional.absent();
        ReadOnlyAxis[] all = ReadOnlyAxis.values();
        int i = 0;
        while (i < all.length && !((Boolean)result.or((Object)Boolean.FALSE)).booleanValue()) {
            if (axes.contains(all[i])) {
                result = this.isReadOnly(all[i], eObject);
            }
            ++i;
        }
        return result.isPresent() ? result : Optional.of((Object)Boolean.FALSE);
    }

    private Optional<Boolean> isReadOnly(ReadOnlyAxis axis, EObject eObject) {
        Set axes = axis.singleton();
        Optional result = Optional.absent();
        IReadOnlyHandler2[] orderedHandlers = this.orderedHandlersByAxis.get(axis);
        int i = 0;
        while (i < orderedHandlers.length && !result.isPresent()) {
            result = orderedHandlers[i].isReadOnly(axes, eObject);
            ++i;
        }
        return result.isPresent() ? result : Optional.of((Object)Boolean.FALSE);
    }

    public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        Boolean finalResult = true;
        ReadOnlyAxis[] all = ReadOnlyAxis.values();
        int i = 0;
        while (i < all.length && finalResult.booleanValue()) {
            if (axes.contains(all[i])) {
                finalResult = this.makeWritable(all[i], uris);
            }
            ++i;
        }
        return Optional.of((Object)finalResult);
    }

    private Boolean makeWritable(ReadOnlyAxis axis, URI[] uris) {
        Set axes = axis.singleton();
        Boolean finalResult = true;
        IReadOnlyHandler2[] orderedHandlers = this.orderedHandlersByAxis.get(axis);
        int i = 0;
        while (i < orderedHandlers.length) {
            Optional result;
            Optional isRO = orderedHandlers[i].anyReadOnly(axes, uris);
            if (((Boolean)isRO.or((Object)Boolean.FALSE)).booleanValue() && !((Boolean)(result = orderedHandlers[i].makeWritable(axes, uris)).or((Object)Boolean.FALSE)).booleanValue()) {
                finalResult = false;
                break;
            }
            ++i;
        }
        return finalResult;
    }

    public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, EObject eObject) {
        Boolean finalResult = true;
        ReadOnlyAxis[] all = ReadOnlyAxis.values();
        int i = 0;
        while (i < all.length && finalResult.booleanValue()) {
            if (axes.contains(all[i])) {
                finalResult = this.makeWritable(all[i], eObject);
            }
            ++i;
        }
        return Optional.of((Object)finalResult);
    }

    private Boolean makeWritable(ReadOnlyAxis axis, EObject eObject) {
        Set axes = axis.singleton();
        Boolean finalResult = true;
        IReadOnlyHandler2[] orderedHandlers = this.orderedHandlersByAxis.get(axis);
        int i = 0;
        while (i < orderedHandlers.length) {
            Optional result;
            Optional isRO = orderedHandlers[i].isReadOnly(axes, eObject);
            if (((Boolean)isRO.or((Object)Boolean.FALSE)).booleanValue() && !((Boolean)(result = orderedHandlers[i].makeWritable(axes, eObject)).or((Object)Boolean.FALSE)).booleanValue()) {
                finalResult = false;
                break;
            }
            ++i;
        }
        return finalResult;
    }

    public Optional<Boolean> canMakeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        Boolean result = false;
        ReadOnlyAxis[] all = ReadOnlyAxis.values();
        int i = 0;
        while (i < all.length && !result.booleanValue()) {
            if (axes.contains(all[i])) {
                result = this.canMakeWritable(all[i], uris);
            }
            ++i;
        }
        return Optional.of((Object)result);
    }

    private Boolean canMakeWritable(ReadOnlyAxis axis, URI[] uris) {
        Set axes = axis.singleton();
        Boolean result = false;
        IReadOnlyHandler2[] orderedHandlers = this.orderedHandlersByAxis.get(axis);
        int i = 0;
        while (i < orderedHandlers.length) {
            Optional canMakeWritable;
            if (((Boolean)orderedHandlers[i].anyReadOnly(axes, uris).or((Object)false)).booleanValue() && (canMakeWritable = orderedHandlers[i].canMakeWritable(axes, uris)).isPresent()) {
                result = (Boolean)canMakeWritable.get();
                break;
            }
            ++i;
        }
        return result;
    }

    public Optional<Boolean> canMakeWritable(Set<ReadOnlyAxis> axes, EObject object) {
        Boolean result = false;
        ReadOnlyAxis[] all = ReadOnlyAxis.values();
        int i = 0;
        while (i < all.length && !result.booleanValue()) {
            if (axes.contains(all[i])) {
                result = this.canMakeWritable(all[i], object);
            }
            ++i;
        }
        return Optional.of((Object)result);
    }

    private Boolean canMakeWritable(ReadOnlyAxis axis, EObject object) {
        Set axes = axis.singleton();
        Boolean result = false;
        IReadOnlyHandler2[] orderedHandlers = this.orderedHandlersByAxis.get(axis);
        int i = 0;
        while (i < orderedHandlers.length) {
            Optional canMakeWritable;
            if (((Boolean)orderedHandlers[i].isReadOnly(axes, object).or((Object)false)).booleanValue() && (canMakeWritable = orderedHandlers[i].canMakeWritable(axes, object)).isPresent()) {
                result = (Boolean)canMakeWritable.get();
                break;
            }
            ++i;
        }
        return result;
    }

    public void addReadOnlyListener(IReadOnlyListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeReadOnlyListener(IReadOnlyListener listener) {
        this.listeners.remove(listener);
    }

    private IReadOnlyListener getForwardingListener() {
        if (this.forwardingListener == null) {
            this.forwardingListener = new IReadOnlyListener(){

                public void readOnlyStateChanged(ReadOnlyEvent event) {
                    ReadOnlyEvent myEvent;
                    switch (event.getEventType()) {
                        case 1: {
                            myEvent = new ReadOnlyEvent((IReadOnlyHandler2)ReadOnlyManager.this, event.getAxis(), event.getObject(), event.isReadOnly());
                            break;
                        }
                        default: {
                            myEvent = new ReadOnlyEvent((IReadOnlyHandler2)ReadOnlyManager.this, event.getAxis(), event.getResourceURI(), event.isReadOnly());
                        }
                    }
                    ReadOnlyManager.this.notifyReadOnlyStateChanged(myEvent);
                }
            };
        }
        return this.forwardingListener;
    }

    protected void notifyReadOnlyStateChanged(ReadOnlyEvent event) {
        if (!this.listeners.isEmpty()) {
            for (IReadOnlyListener next : this.listeners) {
                try {
                    next.readOnlyStateChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in read-only state change listener.", (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    public Optional<Boolean> anyReadOnly(URI[] uris) {
        return this.anyReadOnly(ReadOnlyAxis.permissionAxes(), uris);
    }

    @Deprecated
    public Optional<Boolean> isReadOnly(EObject eObject) {
        return this.isReadOnly(ReadOnlyAxis.permissionAxes(), eObject);
    }

    @Deprecated
    public Optional<Boolean> makeWritable(URI[] uris) {
        return this.makeWritable((Set<ReadOnlyAxis>)ReadOnlyAxis.permissionAxes(), uris);
    }

    @Deprecated
    public Optional<Boolean> makeWritable(EObject eObject) {
        return this.makeWritable((Set<ReadOnlyAxis>)ReadOnlyAxis.permissionAxes(), eObject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HandlerPriorityPair
    implements Comparable<HandlerPriorityPair> {
        public Class<?> handlerClass;
        public int priority;
        public Set<ReadOnlyAxis> axes;

        protected HandlerPriorityPair() {
        }

        @Override
        public int compareTo(HandlerPriorityPair o) {
            if (o.priority > this.priority) {
                return 1;
            }
            if (o.priority < this.priority) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OldStyleHandlerAdapter
    extends AbstractReadOnlyHandler {
        private final IReadOnlyHandler delegate;

        OldStyleHandlerAdapter(IReadOnlyHandler handler, EditingDomain editingDomain) {
            super(editingDomain);
            this.delegate = handler;
        }

        public Optional<Boolean> anyReadOnly(Set<ReadOnlyAxis> axes, URI[] uris) {
            boolean delegateResult = axes.contains(ReadOnlyAxis.PERMISSION) && this.delegate.isReadOnly(uris, this.getEditingDomain());
            return delegateResult ? Optional.of((Object)Boolean.TRUE) : Optional.absent();
        }

        public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
            boolean delegateResult = axes.contains(ReadOnlyAxis.PERMISSION) && this.delegate.enableWrite(uris, this.getEditingDomain());
            return delegateResult ? Optional.absent() : Optional.of((Object)Boolean.FALSE);
        }
    }
}

