/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.extension.diagrameditor;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.extension.ExtensionException;
import org.eclipse.papyrus.infra.core.extension.ExtensionUtils;
import org.eclipse.papyrus.infra.core.extension.diagrameditor.EditorDescriptor;

public class EditorDescriptorExtensionFactory
extends ExtensionUtils {
    public static final EditorDescriptorExtensionFactory eINSTANCE = new EditorDescriptorExtensionFactory();
    public static final String EDITOR_DIAGRAM_EXTENSIONPOINT = "editorDiagram";
    public static final String FACTORYCLASS_ATTRIBUTE = "factoryClass";
    public static final String ACTIONBARCONTRIBUTORID_ATTRIBUTE = "actionBarContributorId";
    public static final String ICON_ATTRIBUTE = "icon";

    public static EditorDescriptorExtensionFactory getInstance() {
        return eINSTANCE;
    }

    public EditorDescriptor createNestedEditorDescriptor(IConfigurationElement element) throws ExtensionException {
        this.checkTagName(element, EDITOR_DIAGRAM_EXTENSIONPOINT);
        EditorDescriptor res = new EditorDescriptor();
        res.setEditorFactoryClass(this.parseClass(element, FACTORYCLASS_ATTRIBUTE, EDITOR_DIAGRAM_EXTENSIONPOINT));
        res.setActionBarContributorId(element.getAttribute(ACTIONBARCONTRIBUTORID_ATTRIBUTE));
        String iconPath = element.getAttribute(ICON_ATTRIBUTE);
        if (iconPath != null) {
            res.setIcon(element, iconPath, "org.eclipse.papyrus.infra.core");
        }
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("Read editor descriptor " + res);
        }
        return res;
    }
}

