/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractOperation;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryTernaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryUnaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class StringTokenizeOperation
extends AbstractOperation
implements LibraryUnaryOperation,
LibraryBinaryOperation,
LibraryTernaryOperation {
    @NonNull
    public static final StringTokenizeOperation INSTANCE = new StringTokenizeOperation();
    @NonNull
    private static final String DELIMS = " \t\n\r\f";

    @Nullable
    public Object dispatch(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue) {
        String delims = DELIMS;
        boolean returnDelims = false;
        TypeId typeId = callExp.getTypeId();
        List arguments = callExp.getArgument();
        if (arguments.size() > 0) {
            if (arguments.size() > 1) {
                if (arguments.size() > 2) {
                    throw new InvalidValueException(EvaluatorMessages.InvalidArgument, new Object[]{arguments.get(2)});
                }
                DomainExpression argument1 = (DomainExpression)arguments.get(1);
                assert (argument1 != null);
                Object secondArgument = evaluator.evaluate(argument1);
                returnDelims = StringTokenizeOperation.asBoolean((Object)secondArgument);
            }
            DomainExpression argument0 = (DomainExpression)arguments.get(0);
            assert (argument0 != null);
            Object firstArgument = evaluator.evaluate(argument0);
            delims = StringTokenizeOperation.asString((Object)firstArgument);
        }
        return this.evaluate(evaluator, (CollectionTypeId)typeId, sourceValue, delims, returnDelims);
    }

    @NonNull
    public SequenceValue evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        return this.evaluate(evaluator, (CollectionTypeId)returnTypeId, sourceValue, DELIMS, false);
    }

    @NonNull
    public SequenceValue evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object argumentValue) {
        String delims = StringTokenizeOperation.asString((Object)argumentValue);
        return this.evaluate(evaluator, (CollectionTypeId)returnTypeId, sourceValue, delims, false);
    }

    @NonNull
    public SequenceValue evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        String delims = StringTokenizeOperation.asString((Object)firstArgumentValue);
        boolean returnDelims = StringTokenizeOperation.asBoolean((Object)secondArgumentValue);
        return this.evaluate(evaluator, (CollectionTypeId)returnTypeId, sourceValue, delims, returnDelims);
    }

    @NonNull
    private SequenceValue evaluate(@NonNull DomainEvaluator evaluator, @NonNull CollectionTypeId returnTypeId, @Nullable Object sourceValue, @NonNull String delims, boolean returnDelims) {
        String sourceString = StringTokenizeOperation.asString((Object)sourceValue);
        StringTokenizer tokenizer = new StringTokenizer(sourceString, delims, returnDelims);
        ArrayList<String> results = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            results.add(nextToken);
        }
        return StringTokenizeOperation.createSequenceValue((CollectionTypeId)returnTypeId, results);
    }
}

