/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class SelectIteration
extends AbstractIteration {
    @NonNull
    public static final SelectIteration INSTANCE = new SelectIteration();

    @NonNull
    public CollectionValue.Accumulator createAccumulatorValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return SelectIteration.createCollectionAccumulatorValue((CollectionTypeId)((CollectionTypeId)accumulatorTypeId));
    }

    @Nullable
    protected Object updateAccumulator(@NonNull DomainIterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        assert (!(bodyVal instanceof InvalidValueException));
        if (bodyVal == null) {
            throw new InvalidValueException(EvaluatorMessages.UndefinedBody, new Object[]{"select"});
        }
        if (bodyVal == TRUE_VALUE) {
            Object value = iterationManager.get();
            CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
            assert (accumulatorValue != null);
            accumulatorValue.add(value);
        } else if (bodyVal != Boolean.FALSE) {
            throw new InvalidValueException(EvaluatorMessages.NonBooleanBody, new Object[]{"select"});
        }
        return CARRY_ON;
    }
}

