/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.SetValueImpl;

public class IsUniqueIteration
extends AbstractIteration {
    @NonNull
    public static final IsUniqueIteration INSTANCE = new IsUniqueIteration();

    @NonNull
    public SetValueImpl.Accumulator createAccumulatorValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return new SetValueImpl.Accumulator(TypeId.SET.getSpecializedId(new ElementId[]{accumulatorTypeId}));
    }

    @NonNull
    protected Object resolveTerminalValue(@NonNull DomainIterationManager iterationManager) {
        return true;
    }

    @Nullable
    protected Object updateAccumulator(@NonNull DomainIterationManager iterationManager) {
        CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        Object bodyVal = iterationManager.evaluateBody();
        assert (!(bodyVal instanceof InvalidValueException));
        if (accumulatorValue.includes(bodyVal) == TRUE_VALUE) {
            return false;
        }
        accumulatorValue.add(bodyVal);
        return CARRY_ON;
    }
}

