/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainFragment;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTemplateParameter;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypeParameters;
import org.eclipse.ocl.examples.domain.elements.FeatureFilter;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.AbstractInheritance;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.DomainProperties;
import org.eclipse.ocl.examples.library.executor.ExecutorFragment;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeArgument;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.examples.library.oclstdlib.OCLstdlibTables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExecutorType
extends AbstractInheritance
implements DomainType,
ExecutorTypeArgument {
    private ExecutorFragment[] fragments = null;
    private int[] indexes = null;
    @NonNull
    private final DomainTypeParameters typeParameters;
    private DomainProperties allProperties;

    public ExecutorType(@NonNull String name, @NonNull ExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(name, (DomainPackage)evaluationPackage, flags);
        this.typeParameters = new DomainTypeParameters((DomainTemplateParameter[])typeParameters);
    }

    @NonNull
    public Iterable<? extends DomainOperation> getAllOperations(@Nullable FeatureFilter featureFilter) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Iterable<? extends DomainProperty> getAllProperties(@Nullable FeatureFilter featureFilter) {
        DomainProperties allProperties2 = this.allProperties;
        if (allProperties2 == null) {
            this.allProperties = allProperties2 = new DomainProperties((DomainInheritance)this);
        }
        return allProperties2.getAllProperties(featureFilter);
    }

    @NonNull
    public AbstractInheritance.FragmentIterable getAllSuperFragments() {
        return new AbstractInheritance.FragmentIterable((DomainFragment[])DomainUtil.nonNullState((Object)this.fragments));
    }

    public int getDepth() {
        return this.indexes.length - 2;
    }

    public ExecutorFragment getFragment(int fragmentNumber) {
        return this.fragments[fragmentNumber];
    }

    public int getIndex(int fragmentNumber) {
        return this.indexes[fragmentNumber];
    }

    public int getIndexes() {
        return this.indexes.length;
    }

    @NonNull
    public List<? extends DomainOperation> getLocalOperations() {
        return this.getSelfFragment().getLocalOperations();
    }

    @NonNull
    public List<? extends DomainProperty> getLocalProperties() {
        return this.getSelfFragment().getLocalProperties();
    }

    @NonNull
    public List<? extends DomainType> getLocalSuperTypes() {
        return this.getSelfFragment().getLocalSuperTypes();
    }

    @Nullable
    public DomainProperty getMemberProperty(@NonNull String name) {
        DomainProperties allProperties2 = this.allProperties;
        if (allProperties2 == null) {
            this.allProperties = allProperties2 = new DomainProperties((DomainInheritance)this);
        }
        return allProperties2.getMemberProperty(name);
    }

    @NonNull
    public String getMetaTypeName() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public List<? extends DomainProperty> getOwnedAttribute() {
        return this.getSelfFragment().getLocalProperties();
    }

    @NonNull
    public List<? extends DomainOperation> getOwnedOperation() {
        return this.getSelfFragment().getLocalOperations();
    }

    @NonNull
    public ExecutorFragment getSelfFragment() {
        return (ExecutorFragment)((Object)DomainUtil.nonNullState((Object)((Object)this.getFragment(this.fragments.length - 1))));
    }

    @NonNull
    public DomainStandardLibrary getStandardLibrary() {
        return OCLstdlibTables.LIBRARY;
    }

    @NonNull
    public final AbstractInheritance.FragmentIterable getSuperFragments(int depth) {
        return new AbstractInheritance.FragmentIterable((DomainFragment[])DomainUtil.nonNullState((Object)this.fragments), this.indexes[depth], this.indexes[depth + 1]);
    }

    @NonNull
    public DomainType getType() {
        return this;
    }

    @NonNull
    public TypeId getTypeId() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainTypeParameters getTypeParameters() {
        return this.typeParameters;
    }

    public void initFragments(@NonNull ExecutorFragment[] fragments, int[] depthCounts) {
        int[] indexes = new int[depthCounts.length + 1];
        indexes[0] = 0;
        int i = 0;
        while (i < depthCounts.length) {
            indexes[i + 1] = indexes[i] + depthCounts[i];
            ++i;
        }
        this.fragments = fragments;
        this.indexes = indexes;
    }
}

