/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluationEnvironment;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainLogger;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExecutorManager
implements DomainEvaluator {
    private static final int DEFAULT_REGEX_CACHE_LIMIT = 16;
    private static final float DEFAULT_REGEX_CACHE_LOAD_FACTOR = 0.75f;
    @NonNull
    protected final DomainStandardLibrary standardLibrary;
    private boolean isCanceled = false;
    private Map<String, Pattern> regexPatterns = null;

    public ExecutorManager(@NonNull DomainStandardLibrary standardLibrary) {
        this.standardLibrary = standardLibrary;
    }

    @NonNull
    protected Map<String, Pattern> createRegexCache() {
        return new LinkedHashMap<String, Pattern>(16, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
                return this.size() > 16;
            }
        };
    }

    public void dispose() {
    }

    @NonNull
    public Value evaluate(@NonNull DomainExpression body) {
        throw new UnsupportedOperationException();
    }

    public Value evaluateIteration(DomainType returnType, CollectionValue sourceVal, DomainTypedElement accumulator, DomainExpression body, DomainTypedElement[] iterators) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainType getDynamicTypeOf(@Nullable Object value) {
        return this.getIdResolver().getDynamicTypeOf(value);
    }

    @NonNull
    public DomainEvaluationEnvironment getEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public DomainLogger getLogger() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Pattern getRegexPattern(@NonNull String regex) {
        Object object;
        if (this.regexPatterns == null) {
            object = this;
            synchronized (object) {
                if (this.regexPatterns == null) {
                    this.regexPatterns = this.createRegexCache();
                }
            }
        }
        object = this.regexPatterns;
        synchronized (object) {
            Pattern pattern = this.regexPatterns.get(regex);
            if (pattern == null) {
                pattern = Pattern.compile(regex);
                assert (pattern != null);
                this.regexPatterns.put(regex, pattern);
            }
            return pattern;
        }
    }

    @NonNull
    public DomainStandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value) {
        return this.getIdResolver().getStaticTypeOf(value);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, Object ... values) {
        return this.getIdResolver().getStaticTypeOf(value, values);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return this.getIdResolver().getStaticTypeOf(value, values);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public void setLogger(@Nullable DomainLogger logger) {
    }
}

