/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIterationManager;
import org.eclipse.ocl.examples.domain.library.LibraryTernaryOperation;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public class ExecutorDoubleIterationManager
extends AbstractIterationManager {
    @NonNull
    protected final TypeId returnTypeId;
    @NonNull
    protected final LibraryTernaryOperation body;
    @Nullable
    private Object accumulatorValue;
    @NonNull
    protected final CollectionValue collectionValue;
    @NonNull
    private Iterator<? extends Object> iteratorValue1;
    @NonNull
    private final Iterator<? extends Object> iteratorValue2;
    private Object currentValue1;
    private Object currentValue2;

    public ExecutorDoubleIterationManager(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @NonNull LibraryTernaryOperation body, @Nullable CollectionValue collectionValue, @Nullable Object accumulatorValue) {
        super(evaluator);
        this.returnTypeId = returnTypeId;
        this.body = body;
        this.accumulatorValue = accumulatorValue;
        this.collectionValue = ValuesUtil.asCollectionValue((Object)collectionValue);
        this.iteratorValue1 = this.collectionValue.iterator();
        this.iteratorValue2 = this.collectionValue.iterator();
        this.currentValue1 = this.iteratorValue1.hasNext() ? this.iteratorValue1.next() : null;
        this.currentValue2 = this.iteratorValue2.hasNext() ? this.iteratorValue2.next() : null;
    }

    public boolean advanceIterators() {
        if (this.iteratorValue1.hasNext()) {
            this.currentValue1 = this.iteratorValue1.next();
        } else if (this.iteratorValue2.hasNext()) {
            this.currentValue2 = this.iteratorValue2.next();
            this.iteratorValue1 = this.collectionValue.iterator();
            this.currentValue1 = this.iteratorValue1.hasNext() ? this.iteratorValue1.next() : null;
        } else {
            this.currentValue1 = null;
            this.currentValue2 = null;
        }
        return this.currentValue1 != null;
    }

    @Nullable
    public Object evaluateBody() {
        return this.body.evaluate(this.evaluator, this.returnTypeId, this.accumulatorValue, DomainUtil.nonNullState((Object)this.currentValue1), DomainUtil.nonNullState((Object)this.currentValue2));
    }

    @Nullable
    public Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    @NonNull
    public CollectionValue getSourceCollection() {
        return this.collectionValue;
    }

    public boolean hasCurrent() {
        return this.currentValue1 != null;
    }

    @Nullable
    public Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        return null;
    }
}

