/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainEnumeration;
import org.eclipse.ocl.examples.domain.elements.DomainEnumerationLiteral;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.ids.ClassId;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.DataTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.EnumerationId;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.LambdaTypeId;
import org.eclipse.ocl.examples.domain.ids.MetaclassId;
import org.eclipse.ocl.examples.domain.ids.NestedPackageId;
import org.eclipse.ocl.examples.domain.ids.NsURIPackageId;
import org.eclipse.ocl.examples.domain.ids.OclInvalidTypeId;
import org.eclipse.ocl.examples.domain.ids.OclVoidTypeId;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.RootPackageId;
import org.eclipse.ocl.examples.domain.ids.TemplateBinding;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TemplateableTypeId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.ids.UnspecifiedId;
import org.eclipse.ocl.examples.domain.types.AbstractTuplePart;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.Bag;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.OCLValue;
import org.eclipse.ocl.examples.domain.values.OrderedSet;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.BagImpl;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.OrderedSetImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.library.executor.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdResolver
implements IdResolver {
    @NonNull
    protected final DomainStandardLibrary standardLibrary;
    @NonNull
    private final Map<Object, DomainType> key2type = new HashMap<Object, DomainType>();
    private Map<EnumerationLiteralId, Enumerator> enumerationLiteral2enumerator = null;
    private Map<Enumerator, EnumerationLiteralId> enumerator2enumerationLiteralId = null;
    private Map<String, Map<DomainType, WeakReference<DomainTypedElement>>> tupleParts = null;

    public AbstractIdResolver(@NonNull DomainStandardLibrary standardLibrary) {
        this.standardLibrary = standardLibrary;
    }

    @Nullable
    public Object boxedValueOf(@Nullable Object unboxedValue) {
        if (unboxedValue == null) {
            return unboxedValue;
        }
        if (unboxedValue instanceof Value) {
            return unboxedValue;
        }
        if (unboxedValue instanceof Boolean) {
            return unboxedValue;
        }
        if (unboxedValue instanceof String) {
            return unboxedValue;
        }
        if (unboxedValue instanceof Number) {
            if (unboxedValue instanceof Integer || unboxedValue instanceof Long || unboxedValue instanceof Short || unboxedValue instanceof Byte) {
                return ValuesUtil.integerValueOf((long)((Number)unboxedValue).longValue());
            }
            if (unboxedValue instanceof Float || unboxedValue instanceof Double) {
                return ValuesUtil.realValueOf((double)((Number)unboxedValue).doubleValue());
            }
            if (unboxedValue instanceof BigDecimal) {
                return ValuesUtil.realValueOf((BigDecimal)((BigDecimal)unboxedValue));
            }
            if (unboxedValue instanceof BigInteger) {
                return ValuesUtil.integerValueOf((BigInteger)((BigInteger)unboxedValue));
            }
        } else {
            if (unboxedValue instanceof Character) {
                return ValuesUtil.integerValueOf((int)((Character)unboxedValue).charValue());
            }
            if (unboxedValue.getClass().isArray()) {
                try {
                    Object[] unboxedValues = (Object[])unboxedValue;
                    DomainType dynamicType = this.getDynamicTypeOf(unboxedValues);
                    if (dynamicType == null) {
                        dynamicType = this.standardLibrary.getOclInvalidType();
                    }
                    TypeId elementTypeId = dynamicType.getTypeId();
                    CollectionTypeId collectedTypeId = TypeId.SEQUENCE.getSpecializedId(new ElementId[]{elementTypeId});
                    return this.createSequenceOfEach(collectedTypeId, (Object[])unboxedValue);
                }
                catch (IllegalArgumentException unboxedValues) {}
            } else {
                if (unboxedValue instanceof Iterable) {
                    Iterable unboxedValues = (Iterable)unboxedValue;
                    DomainType dynamicType = this.getDynamicTypeOf(unboxedValues);
                    if (dynamicType == null) {
                        dynamicType = this.standardLibrary.getOclInvalidType();
                    }
                    TypeId elementTypeId = dynamicType.getTypeId();
                    CollectionTypeId collectedTypeId = TypeId.SEQUENCE.getSpecializedId(new ElementId[]{elementTypeId});
                    if (unboxedValue instanceof LinkedHashSet || unboxedValue instanceof OrderedSet) {
                        return this.createOrderedSetOfAll(collectedTypeId, unboxedValues);
                    }
                    if (unboxedValue instanceof Bag) {
                        return this.createBagOfAll(collectedTypeId, unboxedValues);
                    }
                    if (unboxedValue instanceof Set) {
                        return this.createSetOfAll(collectedTypeId, unboxedValues);
                    }
                    return this.createSequenceOfAll(collectedTypeId, unboxedValues);
                }
                if (unboxedValue instanceof DomainType) {
                    return unboxedValue;
                }
                if (unboxedValue instanceof DomainEnumerationLiteral) {
                    return ((DomainEnumerationLiteral)unboxedValue).getEnumerationLiteralId();
                }
                if (unboxedValue instanceof EEnumLiteral) {
                    return IdManager.getEnumerationLiteralId((EEnumLiteral)((EEnumLiteral)unboxedValue));
                }
                if (unboxedValue instanceof EObject) {
                    return unboxedValue;
                }
                if (unboxedValue instanceof DomainElement) {
                    return unboxedValue;
                }
                if (unboxedValue instanceof EnumerationLiteralId) {
                    return unboxedValue;
                }
                if (unboxedValue instanceof Enumerator) {
                    return this.boxedValueOfEnumerator((Enumerator)unboxedValue);
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Object boxedValueOf(@NonNull Object unboxedValue, @Nullable EClassifier eClassifier) {
        if (unboxedValue instanceof Value) {
            return unboxedValue;
        }
        if (eClassifier instanceof EEnum) {
            EEnum eEnum = (EEnum)eClassifier;
            String name = (String)DomainUtil.nonNullModel((Object)((Enumerator)unboxedValue).getName());
            EnumerationId enumId = IdManager.getEnumerationId((EEnum)eEnum);
            EnumerationLiteralId enumerationLiteralId = enumId.getEnumerationLiteralId(name);
            return enumerationLiteralId;
        }
        return this.boxedValueOf(unboxedValue);
    }

    @Nullable
    public Object boxedValueOf(@NonNull Object unboxedValue, @NonNull ETypedElement eFeature, @Nullable TypeId typeId) {
        EClassifier eClassifier = eFeature.getEType();
        if (typeId instanceof CollectionTypeId) {
            ArrayList<Object> unboxedValues = (ArrayList<Object>)unboxedValue;
            if (eClassifier instanceof EDataType) {
                ArrayList<Object> values = new ArrayList<Object>(unboxedValues.size());
                for (Object e : unboxedValues) {
                    if (e == null) continue;
                    values.add(this.boxedValueOf(e, eClassifier));
                }
                unboxedValues = values;
            }
            return this.createCollectionOfAll((CollectionTypeId)typeId, unboxedValues);
        }
        return this.boxedValueOf(unboxedValue, eClassifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object boxedValueOfEnumerator(@NonNull Enumerator unboxedValue) {
        EnumerationLiteralId enumerationLiteralId;
        Map<Enumerator, EnumerationLiteralId> enumerator2enumerationLiteralId2 = this.enumerator2enumerationLiteralId;
        if (enumerator2enumerationLiteralId2 == null) {
            AbstractIdResolver abstractIdResolver = this;
            synchronized (abstractIdResolver) {
                enumerator2enumerationLiteralId2 = this.enumerator2enumerationLiteralId;
                if (enumerator2enumerationLiteralId2 == null) {
                    this.enumerator2enumerationLiteralId = enumerator2enumerationLiteralId2 = new HashMap<Enumerator, EnumerationLiteralId>();
                    for (DomainPackage dPackage : this.standardLibrary.getAllPackages()) {
                        for (DomainType dType : dPackage.getOwnedType()) {
                            if (!(dType instanceof DomainEnumeration)) continue;
                            for (DomainEnumerationLiteral dEnumerationLiteral : ((DomainEnumeration)dType).getEnumerationLiterals()) {
                                Enumerator enumerator = dEnumerationLiteral.getEnumerator();
                                EnumerationLiteralId enumerationLiteralId2 = dEnumerationLiteral.getEnumerationLiteralId();
                                this.enumerator2enumerationLiteralId.put(enumerator, enumerationLiteralId2);
                            }
                        }
                    }
                }
            }
        }
        if ((enumerationLiteralId = enumerator2enumerationLiteralId2.get(unboxedValue)) == null) {
            throw new InvalidValueException("Unknown enumeration " + unboxedValue.getName(), new Object[0]);
        }
        return enumerationLiteralId;
    }

    @NonNull
    public BagValue createBagOfAll(@NonNull CollectionTypeId typeId, @NonNull Iterable<? extends Object> unboxedValues) {
        BagImpl boxedValues = new BagImpl();
        for (Object object : unboxedValues) {
            boxedValues.add(this.boxedValueOf(object));
        }
        return ValuesUtil.createBagValue((CollectionTypeId)typeId, (Bag)boxedValues);
    }

    @NonNull
    public BagValue createBagOfEach(@NonNull CollectionTypeId typeId, Object ... unboxedValues) {
        BagImpl boxedValues = new BagImpl();
        Object[] objectArray = unboxedValues;
        int n = unboxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object unboxedValue = objectArray[n2];
            boxedValues.add(this.boxedValueOf(unboxedValue));
            ++n2;
        }
        return ValuesUtil.createBagValue((CollectionTypeId)typeId, (Bag)boxedValues);
    }

    @NonNull
    public CollectionValue createCollectionOfAll(boolean isOrdered, boolean isUnique, @NonNull TypeId elementTypeId, @NonNull Iterable<? extends Object> unboxedValues) {
        if (isOrdered) {
            if (isUnique) {
                return this.createOrderedSetOfAll(TypeId.ORDERED_SET.getSpecializedId(new ElementId[]{elementTypeId}), unboxedValues);
            }
            return this.createSequenceOfAll(TypeId.SEQUENCE.getSpecializedId(new ElementId[]{elementTypeId}), unboxedValues);
        }
        if (isUnique) {
            return this.createSetOfAll(TypeId.SET.getSpecializedId(new ElementId[]{elementTypeId}), unboxedValues);
        }
        return this.createBagOfAll(TypeId.BAG.getSpecializedId(new ElementId[]{elementTypeId}), unboxedValues);
    }

    @NonNull
    public CollectionValue createCollectionOfAll(@NonNull CollectionTypeId collectedId, @NonNull Iterable<?> unboxedValues) {
        CollectionTypeId collectionId = collectedId.getGeneralizedId();
        if (collectionId == TypeId.BAG) {
            return this.createBagOfAll(collectedId, unboxedValues);
        }
        if (collectionId == TypeId.ORDERED_SET) {
            return this.createOrderedSetOfAll(collectedId, unboxedValues);
        }
        if (collectionId == TypeId.SEQUENCE) {
            return this.createSequenceOfAll(collectedId, unboxedValues);
        }
        return this.createSetOfAll(collectedId, unboxedValues);
    }

    @Nullable
    public Object createInstance(@NonNull TypeId typeId, @NonNull String stringValue) {
        Id2InstanceVisitor visitor = new Id2InstanceVisitor(stringValue);
        return typeId.accept((IdVisitor)visitor);
    }

    @NonNull
    public OrderedSetValue createOrderedSetOfAll(@NonNull CollectionTypeId typeId, @NonNull Iterable<? extends Object> unboxedValues) {
        OrderedSetImpl boxedValues = new OrderedSetImpl();
        for (Object object : unboxedValues) {
            boxedValues.add(this.boxedValueOf(object));
        }
        return ValuesUtil.createOrderedSetValue((CollectionTypeId)typeId, (Collection)boxedValues);
    }

    @NonNull
    public OrderedSetValue createOrderedSetOfEach(@NonNull CollectionTypeId typeId, Object ... unboxedValues) {
        OrderedSetImpl boxedValues = new OrderedSetImpl();
        Object[] objectArray = unboxedValues;
        int n = unboxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object unboxedValue = objectArray[n2];
            boxedValues.add(this.boxedValueOf(unboxedValue));
            ++n2;
        }
        return ValuesUtil.createOrderedSetValue((CollectionTypeId)typeId, (Collection)boxedValues);
    }

    @NonNull
    public SequenceValue createSequenceOfAll(@NonNull CollectionTypeId typeId, @NonNull Iterable<? extends Object> unboxedValues) {
        ArrayList<Object> boxedValues = new ArrayList<Object>();
        for (Object object : unboxedValues) {
            boxedValues.add(this.boxedValueOf(object));
        }
        return ValuesUtil.createSequenceValue((CollectionTypeId)typeId, boxedValues);
    }

    @NonNull
    public SequenceValue createSequenceOfEach(@NonNull CollectionTypeId typeId, Object ... unboxedValues) {
        ArrayList<Object> boxedValues = new ArrayList<Object>();
        Object[] objectArray = unboxedValues;
        int n = unboxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object unboxedValue = objectArray[n2];
            boxedValues.add(this.boxedValueOf(unboxedValue));
            ++n2;
        }
        return ValuesUtil.createSequenceValue((CollectionTypeId)typeId, boxedValues);
    }

    @NonNull
    public SetValue createSetOfAll(@NonNull CollectionTypeId typeId, @NonNull Iterable<? extends Object> unboxedValues) {
        HashSet<Object> boxedValues = new HashSet<Object>();
        for (Object object : unboxedValues) {
            boxedValues.add(this.boxedValueOf(object));
        }
        return ValuesUtil.createSetValue((CollectionTypeId)typeId, boxedValues);
    }

    @NonNull
    public SetValue createSetOfEach(@NonNull CollectionTypeId typeId, Object ... unboxedValues) {
        HashSet<Object> boxedValues = new HashSet<Object>();
        Object[] objectArray = unboxedValues;
        int n = unboxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object unboxedValue = objectArray[n2];
            boxedValues.add(this.boxedValueOf(unboxedValue));
            ++n2;
        }
        return ValuesUtil.createSetValue((CollectionTypeId)typeId, boxedValues);
    }

    public void dispose() {
        this.tupleParts = null;
        this.key2type.clear();
        this.enumerationLiteral2enumerator = null;
        this.enumerator2enumerationLiteralId = null;
    }

    @NonNull
    public DomainType getCollectionType(@NonNull CollectionTypeId typeId) {
        return this.getCollectionType(typeId, null, null);
    }

    @NonNull
    public DomainType getCollectionType(@NonNull CollectionTypeId typeId, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        CollectionTypeId generalizedId = typeId.getGeneralizedId();
        if (typeId == generalizedId && lower == null && upper == null) {
            if (generalizedId == TypeId.BAG) {
                return this.standardLibrary.getBagType();
            }
            if (generalizedId == TypeId.COLLECTION) {
                return this.standardLibrary.getCollectionType();
            }
            if (generalizedId == TypeId.ORDERED_SET) {
                return this.standardLibrary.getOrderedSetType();
            }
            if (generalizedId == TypeId.SEQUENCE) {
                return this.standardLibrary.getSequenceType();
            }
            if (generalizedId == TypeId.SET) {
                return this.standardLibrary.getSetType();
            }
            if (generalizedId == TypeId.UNIQUE_COLLECTION) {
                return this.standardLibrary.getUniqueCollectionType();
            }
            throw new UnsupportedOperationException();
        }
        TypeId elementTypeId = typeId.getElementTypeId();
        DomainType elementType = this.getType(elementTypeId, null);
        if (generalizedId == TypeId.BAG) {
            return this.standardLibrary.getBagType(elementType, lower, upper);
        }
        if (generalizedId == TypeId.COLLECTION) {
            return this.standardLibrary.getCollectionType(this.standardLibrary.getCollectionType(), elementType, lower, upper);
        }
        if (generalizedId == TypeId.ORDERED_SET) {
            return this.standardLibrary.getOrderedSetType(elementType, lower, upper);
        }
        if (generalizedId == TypeId.SEQUENCE) {
            return this.standardLibrary.getSequenceType(elementType, lower, upper);
        }
        if (generalizedId == TypeId.SET) {
            return this.standardLibrary.getSetType(elementType, lower, upper);
        }
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainType getDynamicTypeOf(@Nullable Object value) {
        if (value instanceof CollectionValue) {
            CollectionValue collectionValue = (CollectionValue)value;
            DomainType elementType = this.getDynamicTypeOf(collectionValue.iterable());
            if (elementType == null) {
                elementType = this.getType(collectionValue.getTypeId().getElementTypeId(), null);
            }
            CollectionTypeId collectedId = collectionValue.getTypeId();
            CollectionTypeId collectionId = collectedId.getGeneralizedId();
            TypeId elementTypeId = elementType.getTypeId();
            collectedId = collectionId.getSpecializedId(new ElementId[]{elementTypeId});
            IntegerValue size = collectionValue.size();
            return this.getCollectionType(collectedId, size, size);
        }
        return this.getStaticTypeOf(value);
    }

    @Nullable
    public DomainType getDynamicTypeOf(Object ... values) {
        DomainType elementType = null;
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            DomainType valueType = this.getDynamicTypeOf(value);
            elementType = elementType == null ? valueType : elementType.getCommonType((IdResolver)this, valueType);
            ++n2;
        }
        if (elementType == null) {
            elementType = this.standardLibrary.getOclInvalidType();
        }
        return elementType;
    }

    @Nullable
    public DomainType getDynamicTypeOf(@NonNull Iterable<?> values) {
        DomainType elementType = null;
        for (Object value : values) {
            DomainType valueType = this.getDynamicTypeOf(value);
            elementType = elementType == null ? valueType : elementType.getCommonType((IdResolver)this, valueType);
        }
        return elementType;
    }

    @NonNull
    public synchronized DomainType getJavaType(@NonNull Class<?> javaClass) {
        Object type = this.key2type.get(javaClass);
        if (type != null) {
            return type;
        }
        type = new JavaType(this.standardLibrary, javaClass);
        this.key2type.put(javaClass, (DomainType)type);
        return type;
    }

    @NonNull
    public DomainType getMetaclass(@NonNull MetaclassId metaclassId) {
        if (metaclassId == TypeId.METACLASS) {
            return this.standardLibrary.getMetaclassType();
        }
        ElementId elementId = metaclassId.getElementId();
        DomainType elementType = this.getType((TypeId)elementId, null);
        return this.standardLibrary.getMetaclass(elementType);
    }

    @NonNull
    public DomainOperation getOperation(@NonNull OperationId operationId) {
        DomainElement element = (DomainElement)operationId.accept((IdVisitor)this);
        if (element instanceof DomainOperation) {
            return (DomainOperation)element;
        }
        throw new IllegalStateException("No " + operationId);
    }

    @NonNull
    public DomainProperty getProperty(@NonNull PropertyId propertyId) {
        DomainElement element = (DomainElement)propertyId.accept((IdVisitor)this);
        if (element instanceof DomainProperty) {
            return (DomainProperty)element;
        }
        throw new IllegalStateException("No " + propertyId);
    }

    @NonNull
    public DomainStandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value) {
        if (value instanceof DomainType) {
            DomainType type = this.key2type.get(value);
            if (type == null) {
                type = this.standardLibrary.getMetaclass((DomainType)value);
                assert (type != null);
                this.key2type.put(value, type);
            }
            return type;
        }
        if (value instanceof EObject) {
            EClass eClass = ((EObject)value).eClass();
            assert (eClass != null);
            DomainType type = this.key2type.get(eClass);
            if (type == null) {
                type = this.getType((EClassifier)eClass);
                assert (type != null);
                this.key2type.put(eClass, type);
            }
            return type;
        }
        if (value instanceof Value) {
            TypeId typeId = ((Value)value).getTypeId();
            DomainType type = this.key2type.get(typeId);
            if (type == null) {
                type = (DomainType)typeId.accept((IdVisitor)this);
                assert (type != null);
                this.key2type.put(typeId, type);
            }
            return type;
        }
        if (value == null) {
            return this.standardLibrary.getOclVoidType();
        }
        if (value instanceof Boolean) {
            return this.standardLibrary.getBooleanType();
        }
        if (value instanceof String) {
            return this.standardLibrary.getStringType();
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal || value instanceof Double || value instanceof Float) {
                return this.standardLibrary.getRealType();
            }
            if (value instanceof BigInteger || value instanceof Byte || value instanceof Integer || value instanceof Long || value instanceof Short) {
                return this.standardLibrary.getIntegerType();
            }
        } else if (value instanceof EnumerationLiteralId) {
            DomainEnumerationLiteral enumLiteral = (DomainEnumerationLiteral)((EnumerationLiteralId)value).accept((IdVisitor)this);
            assert (enumLiteral != null);
            DomainEnumeration enumeration = enumLiteral.getEnumeration();
            assert (enumeration != null);
            return enumeration;
        }
        Class<?> jClass = value.getClass();
        assert (jClass != null);
        return this.getJavaType(jClass);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, Object ... values) {
        Object bestTypeId = this.getTypeKeyOf(value);
        DomainType bestType = this.key2type.get(bestTypeId);
        assert (bestType != null);
        AbstractCollection assessedTypeKeys = null;
        int count = 0;
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object anotherValue = objectArray[n2];
            Object anotherTypeId = this.getTypeKeyOf(anotherValue);
            if (assessedTypeKeys == null ? anotherTypeId != bestTypeId : !assessedTypeKeys.contains(anotherTypeId)) {
                DomainType anotherType = this.key2type.get(anotherTypeId);
                assert (anotherType != null);
                DomainType commonType = bestType.getCommonType((IdResolver)this, anotherType);
                if (commonType != bestType) {
                    if (assessedTypeKeys == null) {
                        assessedTypeKeys = new ArrayList<Object>();
                        assessedTypeKeys.add(bestTypeId);
                    } else if (count++ == 4) {
                        assessedTypeKeys = new HashSet(assessedTypeKeys);
                    }
                    assessedTypeKeys.add(anotherTypeId);
                    bestType = commonType;
                    bestTypeId = anotherTypeId;
                }
            }
            ++n2;
        }
        return bestType;
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        Object bestTypeKey = this.getTypeKeyOf(value);
        DomainType bestType = this.key2type.get(bestTypeKey);
        assert (bestType != null);
        AbstractCollection assessedTypeKeys = null;
        int count = 0;
        for (Object anotherValue : values) {
            assert (anotherValue != null);
            Object anotherTypeKey = this.getTypeKeyOf(anotherValue);
            if (!(assessedTypeKeys == null ? anotherTypeKey != bestTypeKey : !assessedTypeKeys.contains(anotherTypeKey))) continue;
            DomainType anotherType = this.key2type.get(anotherTypeKey);
            assert (anotherType != null);
            DomainType commonType = bestType.getCommonType((IdResolver)this, anotherType);
            if (commonType == bestType) continue;
            if (assessedTypeKeys == null) {
                assessedTypeKeys = new ArrayList<Object>();
                assessedTypeKeys.add(bestTypeKey);
            } else if (count++ == 4) {
                assessedTypeKeys = new HashSet(assessedTypeKeys);
            }
            assessedTypeKeys.add(anotherTypeKey);
        }
        return bestType;
    }

    @NonNull
    public DomainTypedElement getTuplePart(@NonNull String name, @NonNull TypeId typeId) {
        return this.getTuplePart(name, this.getType(typeId, null));
    }

    @NonNull
    public synchronized DomainTypedElement getTuplePart(@NonNull String name, @NonNull DomainType type) {
        DomainTypedElement tupleProperty;
        Map<DomainType, WeakReference<DomainTypedElement>> typeMap;
        if (this.tupleParts == null) {
            this.tupleParts = new WeakHashMap<String, Map<DomainType, WeakReference<DomainTypedElement>>>();
        }
        if ((typeMap = this.tupleParts.get(name)) == null) {
            typeMap = new WeakHashMap<DomainType, WeakReference<DomainTypedElement>>();
            this.tupleParts.put(name, typeMap);
        }
        if ((tupleProperty = this.weakGet(typeMap, type)) == null) {
            tupleProperty = new AbstractTuplePart(type, name);
            typeMap.put(type, new WeakReference<DomainTypedElement>(tupleProperty));
        }
        return tupleProperty;
    }

    @NonNull
    public abstract DomainTupleType getTupleType(@NonNull TupleTypeId var1);

    @NonNull
    public abstract DomainType getType(@NonNull EClassifier var1);

    @NonNull
    public DomainType getType(@NonNull TypeId typeId, @Nullable Object context) {
        DomainElement type = (DomainElement)typeId.accept((IdVisitor)this);
        assert (type != null);
        return (DomainType)type;
    }

    @NonNull
    private Object getTypeKeyOf(@Nullable Object value) {
        if (value instanceof EObject) {
            EClass typeKey = ((EObject)value).eClass();
            assert (typeKey != null);
            DomainType type = this.key2type.get(typeKey);
            if (type == null) {
                type = this.getType((EClassifier)typeKey);
                assert (type != null);
                this.key2type.put(typeKey, type);
            }
            return typeKey;
        }
        if (value instanceof Value) {
            TypeId typeKey = ((Value)value).getTypeId();
            DomainType type = this.key2type.get(typeKey);
            if (type == null) {
                type = (DomainType)typeKey.accept((IdVisitor)this);
                assert (type != null);
                this.key2type.put(typeKey, type);
            }
            return typeKey;
        }
        if (value == null) {
            OclVoidTypeId typeKey = TypeId.OCL_VOID;
            this.key2type.put(typeKey, this.standardLibrary.getOclVoidType());
            return typeKey;
        }
        Class<?> typeKey = value.getClass();
        assert (typeKey != null);
        DomainType type = this.key2type.get(typeKey);
        if (type != null) {
            return typeKey;
        }
        if (value instanceof Boolean) {
            type = this.standardLibrary.getBooleanType();
        } else if (value instanceof String) {
            type = this.standardLibrary.getStringType();
        }
        if (type != null) {
            this.key2type.put(typeKey, type);
            return typeKey;
        }
        throw new UnsupportedOperationException();
    }

    public boolean oclEquals(@Nullable Object thisValue, @Nullable Object thatValue) {
        if (thisValue == thatValue) {
            return true;
        }
        if (thisValue instanceof OCLValue) {
            if (thatValue instanceof OCLValue) {
                return ((OCLValue)thisValue).oclEquals((OCLValue)thatValue);
            }
            if ((thatValue = this.boxedValueOf(thatValue)) instanceof OCLValue) {
                return ((OCLValue)thisValue).oclEquals((OCLValue)thatValue);
            }
            return false;
        }
        if (thatValue instanceof OCLValue) {
            if ((thisValue = this.boxedValueOf(thisValue)) instanceof OCLValue) {
                return ((OCLValue)thisValue).oclEquals((OCLValue)thatValue);
            }
            return false;
        }
        if (thisValue != null) {
            if (thatValue != null) {
                return thisValue.equals(thatValue);
            }
            return false;
        }
        return thatValue == null;
    }

    @Nullable
    public Object unboxedValueOf(@Nullable Object boxedValue) {
        if (boxedValue instanceof Value) {
            return ((Value)boxedValue).asEcoreObject((IdResolver)this);
        }
        if (boxedValue instanceof EnumerationLiteralId) {
            return this.unboxedValueOf((EnumerationLiteralId)boxedValue);
        }
        return boxedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Enumerator unboxedValueOf(@NonNull EnumerationLiteralId enumerationLiteralId) {
        Enumerator enumerator;
        if (this.enumerationLiteral2enumerator == null) {
            AbstractIdResolver abstractIdResolver = this;
            synchronized (abstractIdResolver) {
                if (this.enumerationLiteral2enumerator == null) {
                    this.enumerationLiteral2enumerator = new HashMap<EnumerationLiteralId, Enumerator>();
                }
            }
        }
        if ((enumerator = this.enumerationLiteral2enumerator.get(enumerationLiteralId)) == null) {
            Map<EnumerationLiteralId, Enumerator> map = this.enumerationLiteral2enumerator;
            synchronized (map) {
                enumerator = this.enumerationLiteral2enumerator.get(enumerationLiteralId);
                if (enumerator == null) {
                    DomainEnumerationLiteral enumerationLiteral = (DomainEnumerationLiteral)enumerationLiteralId.accept((IdVisitor)this);
                    if (enumerationLiteral != null) {
                        enumerator = enumerationLiteral.getEnumerator();
                        this.enumerationLiteral2enumerator.put(enumerationLiteralId, enumerator);
                    }
                    if (enumerator == null) {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }
        return enumerator;
    }

    @NonNull
    public EList<Object> unboxedValuesOfAll(@NonNull Collection<? extends Object> boxedValues) {
        Object[] unboxedValues = new Object[boxedValues.size()];
        int i = 0;
        for (Object object : boxedValues) {
            unboxedValues[i++] = this.unboxedValueOf(object);
        }
        return new EcoreEList.UnmodifiableEList(null, null, i, unboxedValues);
    }

    @NonNull
    public EList<Object> unboxedValuesOfEach(Object ... boxedValues) {
        Object[] unboxedValues = new Object[boxedValues.length];
        int i = 0;
        Object[] objectArray = boxedValues;
        int n = boxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object boxedValue = objectArray[n2];
            unboxedValues[i++] = this.unboxedValueOf(boxedValue);
            ++n2;
        }
        return new EcoreEList.UnmodifiableEList(null, null, boxedValues.length, unboxedValues);
    }

    @NonNull
    public DomainType visitClassId(@NonNull ClassId id) {
        DomainPackage parentPackage = (DomainPackage)id.getParent().accept((IdVisitor)this);
        assert (parentPackage != null);
        DomainType nestedType = this.standardLibrary.getNestedType(parentPackage, id.getName());
        if (nestedType == null) {
            nestedType = this.standardLibrary.getNestedType(parentPackage, id.getName());
            throw new UnsupportedOperationException();
        }
        return nestedType;
    }

    @NonNull
    public DomainType visitCollectedId(@NonNull CollectionTypeId id) {
        DomainType elementType = (DomainType)id.getElementTypeId().accept((IdVisitor)this);
        if (elementType == null) {
            throw new UnsupportedOperationException();
        }
        CollectionTypeId collectionTypeId = id.getGeneralizedId();
        if (collectionTypeId == TypeId.METACLASS) {
            return this.standardLibrary.getMetaclass(elementType);
        }
        DomainType collectionType = this.getCollectionType(collectionTypeId);
        return this.standardLibrary.getCollectionType(collectionType, elementType, null, null);
    }

    @NonNull
    public DomainType visitCollectionTypeId(@NonNull CollectionTypeId id) {
        return this.getCollectionType(id);
    }

    @NonNull
    public DomainType visitDataTypeId(@NonNull DataTypeId id) {
        DomainPackage parentPackage = (DomainPackage)id.getParent().accept((IdVisitor)this);
        assert (parentPackage != null);
        DomainType nestedType = this.standardLibrary.getNestedType(parentPackage, id.getName());
        if (nestedType == null && (nestedType = this.standardLibrary.getNestedType(parentPackage, id.getName())) == null) {
            throw new UnsupportedOperationException();
        }
        return nestedType;
    }

    @NonNull
    public DomainEnumeration visitEnumerationId(@NonNull EnumerationId id) {
        DomainPackage parentPackage = (DomainPackage)id.getParent().accept((IdVisitor)this);
        assert (parentPackage != null);
        DomainType nestedType = this.standardLibrary.getNestedType(parentPackage, id.getName());
        if (nestedType == null) {
            nestedType = this.standardLibrary.getNestedType(parentPackage, id.getName());
            throw new UnsupportedOperationException();
        }
        if (!(nestedType instanceof DomainEnumeration)) {
            throw new UnsupportedOperationException();
        }
        return (DomainEnumeration)nestedType;
    }

    @NonNull
    public DomainEnumerationLiteral visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
        DomainElement parent = (DomainElement)id.getParentId().accept((IdVisitor)this);
        if (!(parent instanceof DomainEnumeration)) {
            throw new UnsupportedOperationException();
        }
        DomainEnumerationLiteral enumerationLiteral = ((DomainEnumeration)parent).getEnumerationLiteral(id.getName());
        if (enumerationLiteral == null) {
            throw new UnsupportedOperationException();
        }
        return enumerationLiteral;
    }

    @NonNull
    public DomainType visitInvalidId(@NonNull OclInvalidTypeId id) {
        return this.standardLibrary.getOclInvalidType();
    }

    @NonNull
    public DomainType visitLambdaTypeId(@NonNull LambdaTypeId id) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainType visitMetaclassId(@NonNull MetaclassId id) {
        return this.getMetaclass(id);
    }

    @NonNull
    public DomainPackage visitNestedPackageId(@NonNull NestedPackageId packageId) {
        DomainPackage parentPackage = (DomainPackage)packageId.getParent().accept((IdVisitor)this);
        assert (parentPackage != null);
        DomainPackage nestedPackage = this.standardLibrary.getNestedPackage(parentPackage, packageId.getName());
        if (nestedPackage == null) {
            throw new UnsupportedOperationException();
        }
        return nestedPackage;
    }

    @NonNull
    public DomainPackage visitNsURIPackageId(@NonNull NsURIPackageId id) {
        DomainPackage nsURIPackage = this.standardLibrary.getNsURIPackage(id.getNsURI());
        if (nsURIPackage == null) {
            throw new UnsupportedOperationException();
        }
        return nsURIPackage;
    }

    @NonNull
    public DomainType visitNullId(@NonNull OclVoidTypeId id) {
        return this.standardLibrary.getOclVoidType();
    }

    @NonNull
    public DomainOperation visitOperationId(@NonNull OperationId id) {
        DomainType domainType = (DomainType)id.getParent().accept((IdVisitor)this);
        if (domainType == null) {
            throw new UnsupportedOperationException();
        }
        DomainInheritance inheritance = this.standardLibrary.getInheritance(domainType);
        DomainOperation memberOperation = inheritance.getMemberOperation(id);
        if (memberOperation == null) {
            throw new UnsupportedOperationException();
        }
        return memberOperation;
    }

    @NonNull
    public DomainType visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
        DomainType primitiveType = this.standardLibrary.getPrimitiveType(id);
        if (primitiveType == null) {
            throw new UnsupportedOperationException();
        }
        return primitiveType;
    }

    @NonNull
    public DomainProperty visitPropertyId(@NonNull PropertyId id) {
        DomainType domainType = (DomainType)id.getParent().accept((IdVisitor)this);
        if (domainType == null) {
            throw new UnsupportedOperationException();
        }
        DomainInheritance inheritance = this.standardLibrary.getInheritance(domainType);
        DomainProperty memberProperty = inheritance.getMemberProperty(id.getName());
        if (memberProperty == null) {
            throw new UnsupportedOperationException();
        }
        return memberProperty;
    }

    @NonNull
    public DomainPackage visitRootPackageId(@NonNull RootPackageId id) {
        DomainPackage rootPackage = this.standardLibrary.getRootPackage(id.getName());
        if (rootPackage == null) {
            throw new UnsupportedOperationException();
        }
        return rootPackage;
    }

    @NonNull
    public DomainElement visitTemplateBinding(@NonNull TemplateBinding id) {
        return id.getTemplateParameter();
    }

    @NonNull
    public DomainElement visitTemplateParameterId(@NonNull TemplateParameterId id) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainType visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
        return this.getType((TypeId)id, null);
    }

    @NonNull
    public DomainTypedElement visitTuplePartId(@NonNull TuplePartId id) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainType visitTupleTypeId(@NonNull TupleTypeId id) {
        return this.getTupleType(id);
    }

    @NonNull
    public DomainType visitUnspecifiedId(@NonNull UnspecifiedId id) {
        return (DomainType)id.getSpecifier();
    }

    protected <K, V> V weakGet(@NonNull Map<K, WeakReference<V>> map, @NonNull K key) {
        WeakReference<V> ref = map.get(key);
        if (ref == null) {
            return null;
        }
        Object value = ref.get();
        if (value == null) {
            map.remove(key);
        }
        return (V)value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Id2InstanceVisitor
    implements IdVisitor<Object> {
        @NonNull
        protected final String stringValue;

        private Id2InstanceVisitor(@NonNull String stringValue) {
            this.stringValue = stringValue;
        }

        @Nullable
        public Object visitClassId(@NonNull ClassId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitCollectionTypeId(@NonNull CollectionTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitDataTypeId(@NonNull DataTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitEnumerationId(@NonNull EnumerationId id) {
            return id.getEnumerationLiteralId(this.stringValue);
        }

        @Nullable
        public Object visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitInvalidId(@NonNull OclInvalidTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitLambdaTypeId(@NonNull LambdaTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitMetaclassId(@NonNull MetaclassId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitNestedPackageId(@NonNull NestedPackageId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitNsURIPackageId(@NonNull NsURIPackageId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitNullId(@NonNull OclVoidTypeId id) {
            return null;
        }

        @Nullable
        public Object visitOperationId(@NonNull OperationId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
            if (id == TypeId.BOOLEAN) {
                return Boolean.valueOf(this.stringValue);
            }
            if (id == TypeId.STRING) {
                return this.stringValue;
            }
            if (id == TypeId.INTEGER) {
                return ValuesUtil.integerValueOf((String)this.stringValue);
            }
            if (id == TypeId.REAL) {
                return ValuesUtil.realValueOf((String)this.stringValue);
            }
            if (id == TypeId.UNLIMITED_NATURAL) {
                return ValuesUtil.integerValueOf((String)this.stringValue);
            }
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitPropertyId(@NonNull PropertyId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitRootPackageId(@NonNull RootPackageId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitTemplateBinding(@NonNull TemplateBinding id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitTemplateParameterId(@NonNull TemplateParameterId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitTuplePartId(@NonNull TuplePartId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitTupleTypeId(@NonNull TupleTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Object visitUnspecifiedId(@NonNull UnspecifiedId id) {
            throw new UnsupportedOperationException();
        }
    }
}

