/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.ecore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTemplateParameter;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.PackageId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.ecore.EcoreIdResolver;
import org.eclipse.ocl.examples.library.ecore.EcoreReflectiveEnumeration;
import org.eclipse.ocl.examples.library.ecore.EcoreReflectiveType;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreReflectivePackage
extends ExecutorPackage {
    @NonNull
    protected final EcoreIdResolver idResolver;
    protected final EPackage ePackage;
    @Nullable
    protected Map<EClassifier, DomainInheritance> types = null;
    @Nullable
    protected Map<String, EcoreReflectivePackage> nestedPackages = null;

    public EcoreReflectivePackage(@NonNull EPackage ePackage, @NonNull EcoreIdResolver idResolver, @NonNull PackageId packageId) {
        super((String)DomainUtil.nonNullEMF((Object)ePackage.getName()), ePackage.getNsPrefix(), ePackage.getNsURI(), packageId);
        this.idResolver = idResolver;
        this.ePackage = ePackage;
    }

    @NonNull
    protected synchronized Map<EClassifier, DomainInheritance> computeClasses() {
        this.types = new HashMap<EClassifier, DomainInheritance>();
        HashMap<EClassifier, DomainInheritance> types2 = this.types;
        for (EClassifier eClassifier : this.ePackage.getEClassifiers()) {
            if (eClassifier == null) continue;
            EcoreReflectiveType executorType = eClassifier instanceof EEnum ? new EcoreReflectiveEnumeration(this, 0, (EEnum)eClassifier, new DomainTemplateParameter[0]) : new EcoreReflectiveType(this, 0, eClassifier, new DomainTemplateParameter[0]);
            types2.put(eClassifier, (DomainInheritance)executorType);
        }
        return types2;
    }

    @NonNull
    public EcoreIdResolver getIdResolver() {
        return this.idResolver;
    }

    public List<? extends DomainPackage> getNestedPackage() {
        Map<String, EcoreReflectivePackage> nestedPackages2 = this.nestedPackages;
        if (nestedPackages2 == null) {
            this.nestedPackages = nestedPackages2 = new HashMap<String, EcoreReflectivePackage>();
            for (EPackage eSubPackage : this.ePackage.getESubpackages()) {
                if (eSubPackage == null) continue;
                PackageId subPackageId = IdManager.getPackageId((EPackage)eSubPackage);
                EcoreReflectivePackage executorPackage = new EcoreReflectivePackage(eSubPackage, this.idResolver, subPackageId);
                nestedPackages2.put(eSubPackage.getName(), executorPackage);
            }
        }
        return new ArrayList<EcoreReflectivePackage>(nestedPackages2.values());
    }

    public DomainPackage getNestingPackage() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public List<DomainInheritance> getOwnedType() {
        Map<EClassifier, DomainInheritance> types2 = this.types;
        if (types2 == null) {
            types2 = this.computeClasses();
        }
        ArrayList<DomainInheritance> values2 = new ArrayList<DomainInheritance>(types2.values());
        return values2;
    }

    public DomainInheritance getType(String typeName) {
        for (DomainInheritance type : this.getOwnedType()) {
            if (!type.getName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    @NonNull
    public DomainStandardLibrary getStandardLibrary() {
        return this.idResolver.getStandardLibrary();
    }
}

