/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.collection;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractUntypedBinaryOperation;
import org.eclipse.ocl.examples.domain.values.CollectionValue;

public class CollectionSelectByKindOperation
extends AbstractUntypedBinaryOperation {
    @NonNull
    public static final CollectionSelectByKindOperation INSTANCE = new CollectionSelectByKindOperation();

    @NonNull
    public CollectionValue evaluate(@NonNull DomainEvaluator evaluator, @Nullable Object sourceVal, @Nullable Object argVal) {
        CollectionValue collectionValue = CollectionSelectByKindOperation.asCollectionValue((Object)sourceVal);
        DomainType requiredElementType = CollectionSelectByKindOperation.asType((Object)argVal);
        DomainStandardLibrary standardLibrary = evaluator.getStandardLibrary();
        boolean changedContents = false;
        ArrayList newElements = new ArrayList();
        for (Object element : collectionValue.iterable()) {
            if (element == null) {
                changedContents = true;
                continue;
            }
            DomainType elementType = evaluator.getIdResolver().getDynamicTypeOf(element);
            if (elementType.conformsTo(standardLibrary, requiredElementType)) {
                newElements.add(element);
                continue;
            }
            changedContents = true;
        }
        if (changedContents) {
            return evaluator.getIdResolver().createCollectionOfAll(collectionValue.isOrdered(), collectionValue.isUnique(), (TypeId)collectionValue.getTypeId(), newElements);
        }
        return collectionValue;
    }
}

