/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.providers.decorators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.viewpoint.Decoration;
import org.eclipse.sirius.viewpoint.description.DecorationDescription;
import org.eclipse.swt.graphics.Image;

public class DescribedDecorator
extends AbstractDecorator {
    private List<IDecoration> decorations = Collections.emptyList();

    public DescribedDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
    }

    public void activate() {
    }

    public void refresh() {
        this.removeDecorations();
        View view = (View)this.getDecoratorTarget().getAdapter(View.class);
        if (view != null && view.eResource() != null) {
            DDiagramElement element;
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (editPart == null || editPart.getParent() == null || editPart.getViewer() == null) {
                return;
            }
            if (editPart instanceof GraphicalEditPart) {
                IFigure figure = ((GraphicalEditPart)editPart).getFigure();
                Dimension size = figure.getSize();
                if (size.width < 10 && size.width > 0 && size.height < 10 && size.height > 0) {
                    return;
                }
            }
            int margin = -1;
            if (editPart instanceof GraphicalEditPart) {
                margin = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
            }
            if ((element = ((IDiagramElementEditPart)editPart).resolveDiagramElement()) != null) {
                for (Decoration decoration : element.getDecorations()) {
                    Image image = this.getImage(decoration);
                    if (image == null) continue;
                    this.addDecoration(this.getDecoratorTarget().addShapeDecoration(image, this.getPosition(decoration), margin, false));
                }
            }
        }
    }

    private IDecoratorTarget.Direction getPosition(Decoration decoration) {
        IDecoratorTarget.Direction direction = IDecoratorTarget.Direction.SOUTH_WEST;
        if (decoration.getDescription() != null) {
            switch (decoration.getDescription().getPosition().getValue()) {
                case 8: {
                    direction = IDecoratorTarget.Direction.CENTER;
                    break;
                }
                case 0: {
                    direction = IDecoratorTarget.Direction.NORTH;
                    break;
                }
                case 2: {
                    direction = IDecoratorTarget.Direction.SOUTH;
                    break;
                }
                case 1: {
                    direction = IDecoratorTarget.Direction.WEST;
                    break;
                }
                case 3: {
                    direction = IDecoratorTarget.Direction.EAST;
                    break;
                }
                case 5: {
                    direction = IDecoratorTarget.Direction.NORTH_EAST;
                    break;
                }
                case 4: {
                    direction = IDecoratorTarget.Direction.NORTH_WEST;
                    break;
                }
                case 7: {
                    direction = IDecoratorTarget.Direction.SOUTH_EAST;
                    break;
                }
                case 6: {
                    direction = IDecoratorTarget.Direction.SOUTH_WEST;
                    break;
                }
            }
        }
        return direction;
    }

    private Image getImage(Decoration decoration) {
        DecorationDescription description = decoration.getDescription();
        if (description != null) {
            return WorkspaceImageFigure.flyWeightImage(description.getDecoratorPath());
        }
        return null;
    }

    private void removeDecorations() {
        for (IDecoration decoration : this.decorations) {
            if (decoration instanceof IFigure && ((IFigure)decoration).getParent() != null) {
                ((IFigure)decoration).getParent().remove((IFigure)decoration);
            }
            GraphicalEditPart ownerEditPart = (GraphicalEditPart)this.getDecoratorTarget().getAdapter(GraphicalEditPart.class);
            ownerEditPart.getViewer().getVisualPartMap().remove(decoration);
        }
        this.decorations = new ArrayList<IDecoration>();
    }

    public void deactivate() {
        this.removeDecorations();
    }

    public List<IDecoration> getDecorations() {
        return this.decorations;
    }

    public void addDecoration(IDecoration decoration) {
        this.decorations.add(decoration);
    }
}

