/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.NavigateToCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.EMFCommandFactoryUI;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationNavigationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;

public class NavigateToMenuContribution
implements IContributionItemProvider {
    private static final String NAVIGATE_REPRESENTATION_GROUP_SEPARATOR = "navigateRepresentationGroup";
    private AdapterFactory adapterFactory;

    private AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = DialectUIManager.INSTANCE.createAdapterFactory();
        }
        return this.adapterFactory;
    }

    public void contributeToPopupMenu(IMenuManager menu, IWorkbenchPart part) {
        SiriusDiagramEditor diagrampart;
        EObject element;
        if (part instanceof SiriusDiagramEditor && (element = (diagrampart = (SiriusDiagramEditor)part).getDiagramEditPart().resolveSemanticElement()) instanceof DSemanticDiagram) {
            IGraphicalEditPart curPart;
            EObject designerObj;
            DSemanticDiagram designerDiag = (DSemanticDiagram)element;
            EditPart editpart = diagrampart.getDiagramGraphicalViewer().getFocusEditPart();
            if (editpart instanceof IGraphicalEditPart && (designerObj = (curPart = (IGraphicalEditPart)editpart).resolveSemanticElement()) instanceof DSemanticDecorator) {
                this.buildOpenExistingRepresentationsMenu(menu, designerDiag, editpart, designerObj);
            }
        }
    }

    private void buildOpenExistingRepresentationsMenu(IMenuManager menu, DSemanticDiagram designerDiag, EditPart editpart, EObject designerObj) {
        Session session;
        EObject semantic = ((DSemanticDecorator)designerObj).getTarget();
        if (semantic != null && (session = SessionManager.INSTANCE.getSession(semantic)) != null) {
            menu.insertBefore("additions", (IContributionItem)new Separator("generator"));
            IMenuManager navigate = (IMenuManager)menu.find("navigateMenu");
            TransactionalEditingDomain transDomain = TransactionUtil.getEditingDomain((EObject)designerDiag);
            Collection otherRepresentations = DialectManager.INSTANCE.getRepresentations(semantic, session);
            for (DRepresentation representation : otherRepresentations) {
                if (EcoreUtil.equals((EObject)designerDiag, (EObject)representation) || !this.isFromActiveSirius(session, representation)) continue;
                navigate.add(this.buildOpenRepresentationAction(session, representation, editpart, transDomain));
            }
            if (designerObj instanceof DRepresentationElement) {
                this.buildNavigableRepresentationsMenu(navigate, designerObj, session, editpart, transDomain);
            }
        }
    }

    private boolean isFromActiveSirius(Session session, DRepresentation representation) {
        RepresentationDescription description = DialectManager.INSTANCE.getDescription(representation);
        Viewpoint vp = ViewpointRegistry.getInstance().getViewpoint(description);
        return vp != null && session.getSelectedViewpoints(false).contains(vp);
    }

    private void buildNavigableRepresentationsMenu(IMenuManager navigate, EObject designerObj, Session session, EditPart editpart, TransactionalEditingDomain transDomain) {
        DRepresentationElement element = (DRepresentationElement)designerObj;
        Separator createGroup = new Separator(NAVIGATE_REPRESENTATION_GROUP_SEPARATOR);
        navigate.add((IContributionItem)createGroup);
        for (RepresentationNavigationDescription navDesc : element.getMapping().getNavigationDescriptions()) {
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(element.getTarget());
            Option diagram = new EObjectQuery((EObject)element).getParentDiagram();
            if (diagram.some()) {
                interpreter.setVariable("diagram", diagram.get());
            } else {
                interpreter.setVariable("diagram", null);
            }
            HashMap<Object, Object> variables = new HashMap<Object, Object>();
            variables.put(navDesc.getContainerVariable(), element.getTarget());
            variables.put(navDesc.getContainerViewVariable(), element);
            InitInterpreterVariablesTask init = new InitInterpreterVariablesTask(variables, interpreter, (UICallBack)new EMFCommandFactoryUI());
            init.execute();
            boolean precondition = true;
            if (!StringUtil.isEmpty((String)navDesc.getPrecondition())) {
                try {
                    precondition = interpreter.evaluateBoolean(element.getTarget(), navDesc.getPrecondition());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                }
            }
            if (precondition) {
                this.buildOpenRepresentationActions(navigate, interpreter, navDesc, element, session, editpart, transDomain);
            }
            interpreter.unSetVariable("diagram");
        }
    }

    private void buildOpenRepresentationActions(IMenuManager navigate, IInterpreter interpreter, RepresentationNavigationDescription navDesc, DRepresentationElement element, Session session, EditPart editpart, TransactionalEditingDomain transDomain) {
        Collection<EObject> candidates = this.findCandidates(element, navDesc, interpreter);
        Collection representations = DialectManager.INSTANCE.getRepresentations(navDesc.getRepresentationDescription(), session);
        for (DRepresentation representation : representations) {
            if (!this.isFromActiveSirius(session, representation) || !(representation instanceof DSemanticDecorator) || !candidates.contains(((DSemanticDecorator)representation).getTarget())) continue;
            interpreter.setVariable(navDesc.getRepresentationNameVariable().getName(), (Object)representation.getName());
            String label = new StringBuffer("Open ").append(navDesc.getName()).append(" : ").append(representation.getName()).toString();
            if (!StringUtil.isEmpty((String)navDesc.getNavigationNameExpression())) {
                try {
                    label = interpreter.evaluateString(element.getTarget(), navDesc.getNavigationNameExpression());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getRepresentationNavigationDescription_NavigationNameExpression(), (Throwable)e);
                }
            }
            navigate.appendToGroup(NAVIGATE_REPRESENTATION_GROUP_SEPARATOR, this.buildOpenRepresentationAction(session, representation, editpart, transDomain, label));
        }
    }

    private Collection<EObject> findCandidates(DRepresentationElement element, RepresentationNavigationDescription navDesc, IInterpreter interpreter) {
        Collection candidates;
        if (!StringUtil.isEmpty((String)navDesc.getBrowseExpression())) {
            RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
            EAttribute browseExpressionFeature = ToolPackage.eINSTANCE.getRepresentationNavigationDescription_BrowseExpression();
            candidates = safeInterpreter.evaluateCollection(element.getTarget(), (EObject)navDesc, (EStructuralFeature)browseExpressionFeature);
        } else {
            ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(element.getTarget());
            candidates = Lists.newArrayList((Iterator)modelAccessor.eAllContents(element.getTarget()));
        }
        return candidates;
    }

    private IAction buildOpenRepresentationAction(Session session, DRepresentation representation, EditPart editpart, TransactionalEditingDomain transDomain) {
        String representationName = representation.getName();
        if (StringUtil.isEmpty((String)representationName)) {
            representationName = "(unnamed)";
            if (representation instanceof DDiagram) {
                representationName = String.valueOf(representationName) + " " + new IdentifiedElementQuery((IdentifiedElement)((DDiagram)representation).getDescription()).getLabel();
            }
        }
        return this.buildOpenRepresentationAction(session, representation, editpart, transDomain, "Open " + representationName);
    }

    private IAction buildOpenRepresentationAction(final Session session, final DRepresentation representation, EditPart editpart, final TransactionalEditingDomain transDomain, String label) {
        ImageDescriptor imageDescriptor = null;
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.getAdapterFactory().adapt((Notifier)representation, IItemLabelProvider.class);
        if (labelProvider != null) {
            imageDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)representation));
        }
        if (imageDescriptor == null) {
            imageDescriptor = SiriusTransPlugin.getBundledImageDescriptor((String)"/icons/LinkToSirius.gif");
        }
        return new Action(label, imageDescriptor){

            public void run() {
                super.run();
                transDomain.getCommandStack().execute((Command)new NavigateToCommand(session, representation));
            }
        };
    }

    public void contributeToActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void disposeContributions(IWorkbenchPartDescriptor arg0) {
    }

    public void updateActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void addProviderChangeListener(IProviderChangeListener arg0) {
    }

    public boolean provides(IOperation arg0) {
        return true;
    }

    public void removeProviderChangeListener(IProviderChangeListener arg0) {
    }
}

