/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.handler;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.helper.concern.ConcernService;
import org.eclipse.sirius.diagram.description.concern.ConcernDescription;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.Filter;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.filter.VariableFilter;
import org.eclipse.sirius.diagram.ui.tools.internal.filter.FilterTools;
import org.eclipse.sirius.diagram.ui.tools.internal.handler.AbstractChangeActivation;
import org.eclipse.sirius.tools.api.command.SiriusCommand;

public class ChangeFilterActivation
extends AbstractChangeActivation {
    private final FilterDescription filter;

    public ChangeFilterActivation(IDiagramWorkbenchPart part, DDiagram diagram, FilterDescription filter, boolean activate) {
        super(part, diagram, activate);
        this.filter = filter;
    }

    @Override
    public void run() {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.diagram);
        SiriusCommand command = new SiriusCommand(domain, null);
        command.getTasks().add(new AbstractCommandTask(){

            public void execute() {
                NotificationUtil.sendNotification((EObject)ChangeFilterActivation.this.diagram, (int)0, (int)5);
                if (ChangeFilterActivation.this.activate) {
                    ChangeFilterActivation.this.handleActivation(ChangeFilterActivation.this.diagram, ChangeFilterActivation.this.filter);
                } else {
                    ChangeFilterActivation.this.diagram.getActivatedFilters().remove((Object)ChangeFilterActivation.this.filter);
                    ConcernService.resetCurrentConcern((DDiagram)ChangeFilterActivation.this.diagram);
                }
            }

            public String getLabel() {
                return "hide or show filter";
            }
        });
        command.setLabel(this.activate ? "Activate " : "Deactivate " + this.filter.getName() + " filter");
        domain.getCommandStack().execute((Command)command);
    }

    private static boolean handleVariableInit(CompositeFilterDescription composite, DSemanticDiagram vp) throws InterruptedException {
        boolean containsVariableFilters = false;
        for (Filter objFilter : composite.getFilters()) {
            if (!(objFilter instanceof VariableFilter)) continue;
            VariableFilter filter = (VariableFilter)objFilter;
            Map<String, EObject> variables = FilterTools.askForFilterValues(vp, filter);
            filter.setFilterContext(variables);
            containsVariableFilters = true;
        }
        return containsVariableFilters;
    }

    private void handleActivation(DDiagram diagram, FilterDescription filterDescription) {
        ConcernDescription oldConcern = null;
        boolean containsVariableFilters = false;
        EList activatedFilters = diagram.getActivatedFilters();
        ArrayList activatedFiltersCopy = new ArrayList(activatedFilters);
        if (diagram.getCurrentConcern() != null) {
            oldConcern = diagram.getCurrentConcern();
            ConcernService.resetCurrentConcern((DDiagram)diagram);
        }
        try {
            if (filterDescription instanceof CompositeFilterDescription && diagram instanceof DSemanticDiagram) {
                containsVariableFilters = ChangeFilterActivation.handleVariableInit((CompositeFilterDescription)filterDescription, (DSemanticDiagram)diagram);
            }
            if (containsVariableFilters && activatedFiltersCopy.size() > 0) {
                activatedFilters.clear();
            }
            activatedFilters.add(filterDescription);
            if (containsVariableFilters && activatedFiltersCopy.size() > 0) {
                activatedFilters.addAll(activatedFiltersCopy);
            }
        }
        catch (InterruptedException interruptedException) {
            ConcernService.setCurrentConcern((DDiagram)diagram, (ConcernDescription)oldConcern);
        }
    }
}

