/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.ui.IEditorPart;

public final class GMFHelper {
    private GMFHelper() {
    }

    public static Point getAbsoluteLocation(Node node) {
        Node currentNode = node;
        Point absoluteNodeLocation = GMFHelper.getLocation(currentNode);
        if (currentNode.eContainer() instanceof Node) {
            currentNode = (Node)currentNode.eContainer();
            Point parentNodeLocation = GMFHelper.getAbsoluteLocation(currentNode);
            absoluteNodeLocation.translate(parentNodeLocation);
        }
        return absoluteNodeLocation;
    }

    public static Point getLocation(Node node) {
        Point location = new Point(0, 0);
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            Node parentNode;
            LayoutConstraint parentLayoutConstraint;
            DNode dNode;
            AbstractDNode parentAbstractDNode;
            Bounds gmfBounds = (Bounds)layoutConstraint;
            location.x = gmfBounds.getX();
            location.y = gmfBounds.getY();
            if (node.getElement() instanceof DNode && node.getElement().eContainer() instanceof AbstractDNode && (parentAbstractDNode = (AbstractDNode)(dNode = (DNode)node.getElement()).eContainer()).getOwnedBorderedNodes().contains((Object)dNode) && (parentLayoutConstraint = (parentNode = (Node)node.eContainer()).getLayoutConstraint()) instanceof Bounds) {
                Bounds parentBounds = (Bounds)parentLayoutConstraint;
                int position = CanonicalDBorderItemLocator.findClosestSideOfParent(new Rectangle(gmfBounds.getX(), gmfBounds.getY(), gmfBounds.getWidth(), gmfBounds.getHeight()), new Rectangle(parentBounds.getX(), parentBounds.getY(), parentBounds.getWidth(), parentBounds.getHeight()));
                GMFHelper.updateLocation(location, position, parentBounds, gmfBounds);
            }
        }
        return location;
    }

    private static void updateLocation(Point location, int position, Bounds parentBounds, Bounds gmfBounds) {
        switch (position) {
            case 1: 
            case 4: {
                if (location.x != 0) break;
                location.x += (parentBounds.getWidth() - gmfBounds.getWidth()) / 2;
                break;
            }
            case 8: 
            case 16: {
                if (location.y != 0) break;
                location.y += (parentBounds.getHeight() - gmfBounds.getHeight()) / 2;
                break;
            }
        }
    }

    public static Rectangle getAbsoluteBounds(Node node) {
        Node currentNode = node;
        Rectangle absoluteNodeBounds = GMFHelper.getBounds(currentNode);
        if (currentNode.eContainer() instanceof Node) {
            currentNode = (Node)currentNode.eContainer();
            Point parentNodeLocation = GMFHelper.getAbsoluteLocation(currentNode);
            absoluteNodeBounds = absoluteNodeBounds.getTranslated(parentNodeLocation);
        }
        return absoluteNodeBounds;
    }

    public static Option<Rectangle> getAbsoluteBounds(Edge edge) {
        Option<Rectangle> optionalSourceBounds = GMFHelper.getAbsoluteBounds(edge.getSource());
        Option<Rectangle> optionalTargetBounds = GMFHelper.getAbsoluteBounds(edge.getTarget());
        if (optionalSourceBounds.some() && optionalTargetBounds.some()) {
            return Options.newSome((Object)((Rectangle)optionalSourceBounds.get()).union((Rectangle)optionalTargetBounds.get()));
        }
        return Options.newNone();
    }

    public static Option<Rectangle> getAbsoluteBounds(View view) {
        Option<Rectangle> result = Options.newNone();
        if (view instanceof Node) {
            result = Options.newSome((Object)GMFHelper.getAbsoluteBounds((Node)view));
        } else if (view instanceof Edge) {
            result = GMFHelper.getAbsoluteBounds((Edge)view);
        }
        return result;
    }

    public static Rectangle getBounds(Node node) {
        return GMFHelper.getBounds(node, false);
    }

    public static Rectangle getBounds(Node node, boolean useFigureForAutoSizeConstraint) {
        return GMFHelper.getBounds(node, useFigureForAutoSizeConstraint, false);
    }

    public static Rectangle getBounds(Node node, boolean useFigureForAutoSizeConstraint, boolean forceFigureAutoSize) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        EObject element = node.getElement();
        if (element instanceof AbstractDNode) {
            AbstractDNode abstractDNode = (AbstractDNode)element;
            if (layoutConstraint instanceof Location) {
                bounds.x = ((Location)layoutConstraint).getX();
                bounds.y = ((Location)layoutConstraint).getY();
            }
            if (layoutConstraint instanceof Size) {
                bounds.width = ((Size)layoutConstraint).getWidth();
                bounds.height = ((Size)layoutConstraint).getHeight();
            } else {
                bounds.width = -1;
                bounds.height = -1;
            }
            if (new ViewQuery((View)node).isForNameEditPart()) {
                if (abstractDNode.getName() == null || abstractDNode.getName().length() == 0) {
                    if (bounds.width == -1) {
                        bounds.width = 0;
                    }
                    if (bounds.height == -1) {
                        bounds.height = 0;
                    }
                } else {
                    GMFHelper.replaceAutoSize(node, bounds, useFigureForAutoSizeConstraint, new Dimension(50, 20));
                }
            } else {
                GMFHelper.replaceAutoSize(node, bounds, useFigureForAutoSizeConstraint, null);
            }
        }
        return bounds;
    }

    private static void replaceAutoSize(Node node, Rectangle bounds, boolean useFigureForAutoSizeConstraint, Dimension providedDefaultSize) {
        if (bounds.width == -1 || bounds.height == -1) {
            EObject element;
            Dimension defaultSize = providedDefaultSize;
            if (providedDefaultSize == null && (element = node.getElement()) instanceof AbstractDNode) {
                defaultSize = GMFHelper.getDefaultSize((AbstractDNode)element);
            }
            if (useFigureForAutoSizeConstraint) {
                Option<GraphicalEditPart> optionalTargetEditPart = GMFHelper.getGraphicalEditPart((View)node);
                if (optionalTargetEditPart.some()) {
                    GraphicalEditPart graphicalEditPart = (GraphicalEditPart)optionalTargetEditPart.get();
                    if (graphicalEditPart instanceof AbstractDiagramElementContainerEditPart) {
                        ((AbstractDiagramElementContainerEditPart)graphicalEditPart).forceFigureAutosize();
                        ((GraphicalEditPart)graphicalEditPart.getParent()).getFigure().validate();
                    }
                    Rectangle figureBounds = graphicalEditPart.getFigure().getBounds();
                    if (bounds.width == -1) {
                        bounds.width = figureBounds.width;
                    }
                    if (bounds.height == -1) {
                        bounds.height = figureBounds.height;
                    }
                }
            } else {
                Point bottomRight = GMFHelper.getBottomRight(node);
                if (bounds.width == -1) {
                    bounds.width = bottomRight.x > defaultSize.width ? bottomRight.x : defaultSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = bottomRight.y > defaultSize.height ? bottomRight.y : defaultSize.height;
                }
            }
            if (bounds.width == -1) {
                bounds.width = defaultSize.width;
            }
            if (bounds.height == -1) {
                bounds.height = defaultSize.height;
            }
        }
    }

    public static Point getBottomRight(Node node) {
        int right = 0;
        int bottom = 0;
        UnmodifiableIterator children = Iterators.filter((Iterator)node.getChildren().iterator(), Node.class);
        while (children.hasNext()) {
            Node child = (Node)children.next();
            if (new NodeQuery(node).isBorderedNode()) continue;
            Rectangle bounds = GMFHelper.getBounds(child);
            Point bottomRight = bounds.getBottomRight();
            if (bottomRight.x > right) {
                right = bottomRight.x;
            }
            if (bottomRight.y <= bottom) continue;
            bottom = bottomRight.y;
        }
        return new Point(right, bottom);
    }

    private static Dimension getDefaultSize(AbstractDNode abstractDNode) {
        Dimension defaultSize = new Dimension(-1, -1);
        if (abstractDNode instanceof DNode) {
            defaultSize = new DNodeQuery((DNode)abstractDNode).getDefaultDimension();
        } else if (abstractDNode instanceof DNodeContainer || abstractDNode instanceof DNodeList) {
            defaultSize = LayoutUtils.DEFAULT_CONTAINER_DIMENSION;
        }
        return defaultSize;
    }

    private static Option<GraphicalEditPart> getGraphicalEditPart(View view) {
        Map editPartRegistry;
        EditPart targetEditPart;
        Option result = Options.newNone();
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (view != null && editor instanceof DiagramEditor && (targetEditPart = (EditPart)(editPartRegistry = ((DiagramEditor)editor).getDiagramGraphicalViewer().getEditPartRegistry()).get(view)) instanceof GraphicalEditPart) {
            result = Options.newSome((Object)((GraphicalEditPart)targetEditPart));
        }
        return result;
    }
}

