/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INotableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.layout.FreeFormLayoutEx;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.ISiriusEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DCompartmentConnectionRefreshMgr;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.SelectionCommandAppender;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirXYLayoutEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.NodeCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusContainerDropPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusPopupBarEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeContainerViewNodeContainerCompartmentItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.canonicals.DumnySiriusCanonicalEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.operation.RegionContainerUpdateLayoutOperation;
import org.eclipse.sirius.diagram.ui.tools.api.figure.InvisibleResizableCompartmentFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies.ContainerCompartmentNodeEditPolicy;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.tool.MappingBasedToolDescription;

public abstract class AbstractDNodeContainerCompartmentEditPart
extends ShapeCompartmentEditPart
implements INotableEditPart,
ISiriusEditPart {
    private static final int DEFAULT_MARGIN = 4;

    public AbstractDNodeContainerCompartmentEditPart(View view) {
        super(view);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateConnectionRequest || request instanceof ReconnectRequest) {
            return this.getParent();
        }
        return this;
    }

    public Command getCommand(Request _request) {
        Command command;
        if (_request instanceof ReconnectRequest) {
            return this.getParent().getCommand(_request);
        }
        if (_request instanceof CreateConnectionRequest) {
            Command command2 = this.getParent().getCommand(_request);
            return command2;
        }
        if (_request instanceof EditCommandRequestWrapper && ((EditCommandRequestWrapper)_request).getEditCommandRequest() instanceof CreateRelationshipRequest) {
            return this.getParent().getCommand(_request);
        }
        if (_request instanceof CreateRequest && ((CreateRequest)_request).getNewObject() instanceof MappingBasedToolDescription && (command = super.getCommand(_request)) != null) {
            return SelectionCommandAppender.addSelectionCommand(command, (GraphicalEditPart)this);
        }
        command = super.getCommand(_request);
        return command;
    }

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    protected void refreshVisuals() {
        DNodeContainer container;
        EObject eObj = this.resolveSemanticElement();
        if (eObj instanceof DNodeContainer && (container = (DNodeContainer)eObj).getOwnedStyle() != null && container.getOwnedStyle() instanceof FlatContainerStyle) {
            ResizableCompartmentFigure rcf;
            int borderSize;
            FlatContainerStyle ownedStyle = (FlatContainerStyle)container.getOwnedStyle();
            RGBValues borderColor = ownedStyle.getBorderColor();
            if (borderColor != null) {
                this.getFigure().setForegroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(borderColor));
            }
            if ((borderSize = ownedStyle.getBorderSize().intValue()) == 0) {
                borderSize = 1;
            }
            if (this.getFigure() instanceof ResizableCompartmentFigure && (rcf = (ResizableCompartmentFigure)this.getFigure()).getScrollPane() != null) {
                int margin = borderSize + 4;
                MarginBorder border = this.isRegionContainerCompartment() ? new MarginBorder(margin, borderSize, borderSize, borderSize) : new MarginBorder(margin, margin, margin, margin);
                rcf.getScrollPane().setBorder((Border)border);
            }
        }
        super.refreshVisuals();
    }

    public IFigure createFigure() {
        IMapMode mapMode = this.getMapMode();
        InvisibleResizableCompartmentFigure scf = new InvisibleResizableCompartmentFigure(this.getCompartmentName(), mapMode);
        scf.getContentPane().setLayoutManager(this.getLayoutManager());
        scf.getContentPane().addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        scf.setTitleVisibility(false);
        scf.setToolTip(null);
        return scf;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeContainerViewNodeContainerCompartmentItemSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new SiriusContainerDropPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new DumnySiriusCanonicalEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new NodeCreationEditPolicy());
        this.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
        this.removeEditPolicy("LayoutEditPolicy");
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new AirXYLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ContainerCompartmentNodeEditPolicy());
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new SiriusPopupBarEditPolicy());
    }

    protected void setRatio(Double ratio) {
        if (this.getFigure().getParent() != null && this.getFigure().getParent().getLayoutManager() instanceof ConstrainedToolbarLayout) {
            super.setRatio(ratio);
        }
    }

    protected List getModelChildren() {
        ArrayList modelChildren = Lists.newArrayList((Iterable)Iterables.filter((Iterable)super.getModelChildren(), View.class));
        DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
        if (this.isRegionContainerCompartment() && this.getModel() instanceof View) {
            RegionContainerUpdateLayoutOperation.sortRegions((View)this.getModel(), modelChildren);
        }
        return modelChildren;
    }

    private boolean isRegionContainerCompartment() {
        Option<DNodeContainerExperimentalQuery> query = this.getDNodeContainerQuery();
        return query.some() && ((DNodeContainerExperimentalQuery)query.get()).isRegionContainer();
    }

    private Option<DNodeContainerExperimentalQuery> getDNodeContainerQuery() {
        DNodeContainerExperimentalQuery query = null;
        EObject eObject = this.resolveSemanticElement();
        if (eObject instanceof DNodeContainer) {
            query = new DNodeContainerExperimentalQuery((DNodeContainer)eObject);
        }
        return Options.newSome(query);
    }

    public void refresh() {
        if (this.resolveSemanticElement() != null && this.resolveSemanticElement().eResource() != null) {
            super.refresh();
        }
    }

    protected Set getConnectionNodes(ShapeCompartmentEditPart scep) {
        HashSet endPoints = new HashSet();
        Object modelObject = scep.getModel();
        if (scep.getViewer() == null || modelObject == null || !(modelObject instanceof View)) {
            return endPoints;
        }
        if (((View)modelObject).getDiagram() == null) {
            return endPoints;
        }
        Diagram diagram = ((View)modelObject).getDiagram();
        Map registry = scep.getViewer().getEditPartRegistry();
        EList edges = diagram.getEdges();
        for (Edge edge : edges) {
            Object cep;
            EditPart endPoint = (EditPart)registry.get(edge.getSource());
            if (this.isChildOf((EditPart)scep, endPoint)) {
                cep = registry.get(edge);
                if (cep == null) continue;
                endPoints.add(cep);
                continue;
            }
            endPoint = (EditPart)registry.get(edge.getTarget());
            if (!this.isChildOf((EditPart)scep, endPoint) || (cep = registry.get(edge)) == null) continue;
            endPoints.add(cep);
        }
        return endPoints;
    }

    protected boolean isChildOf(EditPart parent, EditPart child) {
        EditPart walker = child;
        while (walker != null && walker != parent) {
            walker = walker.getParent();
        }
        return walker != null;
    }

    public boolean canAttachNote() {
        return true;
    }

    protected ShapeCompartmentEditPart.ConnectionRefreshMgr createConnectionRefreshMgr() {
        return new DCompartmentConnectionRefreshMgr();
    }

    protected LayoutManager getLayoutManager() {
        Object layoutManager = null;
        Option<DNodeContainerExperimentalQuery> query = this.getDNodeContainerQuery();
        if (query.some() && ((DNodeContainerExperimentalQuery)query.get()).isRegionContainer()) {
            if (((DNodeContainerExperimentalQuery)query.get()).isVerticalStackContainer()) {
                layoutManager = new RegionContainerLayoutManager(true);
            } else if (((DNodeContainerExperimentalQuery)query.get()).isHorizontaltackContainer()) {
                layoutManager = new RegionContainerLayoutManager(false);
            }
        }
        if (layoutManager == null) {
            layoutManager = super.getLayoutManager();
        }
        return layoutManager;
    }

    private static class RegionContainerLayoutManager
    extends FreeFormLayoutEx {
        private final boolean isVertical;

        public RegionContainerLayoutManager(boolean isVertical) {
            this.isVertical = isVertical;
        }

        public void layout(IFigure parent) {
            Rectangle bounds;
            Iterator children = parent.getChildren().iterator();
            Point offset = this.getOrigin(parent);
            int maxWidth = 0;
            int maxHeight = 0;
            int minY = Integer.MAX_VALUE;
            HashMap regionsBounds = Maps.newHashMap();
            while (children.hasNext()) {
                IFigure f = (IFigure)children.next();
                bounds = (Rectangle)this.getConstraint(f);
                if (bounds == null) continue;
                bounds = this.computeFreeFormLayoutExBounds(f, bounds.getCopy());
                regionsBounds.put(f, bounds);
                maxWidth = Math.max(maxWidth, bounds.width);
                maxHeight = Math.max(maxHeight, bounds.height);
                minY = Math.min(minY, bounds.y);
            }
            int y = minY;
            int x = 0;
            for (IFigure f : parent.getChildren()) {
                bounds = (Rectangle)regionsBounds.get(f);
                bounds.x = x;
                bounds.y = y;
                if (this.isVertical) {
                    bounds.width = maxWidth;
                    y += bounds.height;
                } else {
                    bounds.height = maxHeight;
                    x += bounds.width;
                }
                this.setConstraint(f, bounds);
                f.setBounds(bounds.translate(offset));
            }
        }

        private Rectangle computeFreeFormLayoutExBounds(IFigure f, Rectangle copy) {
            Rectangle bounds = copy;
            int widthHint = bounds.width;
            int heightHint = bounds.height;
            if (widthHint == -1 || heightHint == -1) {
                Dimension prefSize = f.getPreferredSize(widthHint, heightHint);
                if (widthHint == -1) {
                    bounds.width = prefSize.width;
                }
                if (heightHint == -1) {
                    bounds.height = prefSize.height;
                }
            }
            Dimension min = f.getMinimumSize(widthHint, heightHint);
            Dimension max = f.getMaximumSize();
            if (min.width > bounds.width) {
                bounds.width = min.width;
            } else if (max.width < bounds.width) {
                bounds.width = max.width;
            }
            if (min.height > bounds.height) {
                bounds.height = min.height;
            } else if (max.height < bounds.height) {
                bounds.height = max.height;
            }
            return bounds;
        }
    }
}

