/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.diagram.common.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;

public abstract class CreateDiagramHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain editingDomain;
        ServicesRegistry registry;
        try {
            registry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
            editingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)registry);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
        RecordingCommand command = new RecordingCommand(editingDomain, "Create EMF Diagram"){

            protected void doExecute() {
                CreateDiagramHandler.this.addNewDiagram(registry);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
        return null;
    }

    public Object execute(final ServicesRegistry servicesRegistry) throws ExecutionException {
        TransactionalEditingDomain editingDomain;
        try {
            editingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)servicesRegistry);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
        RecordingCommand command = new RecordingCommand(editingDomain, "Create EMF Diagram"){

            protected void doExecute() {
                CreateDiagramHandler.this.addNewDiagram(servicesRegistry);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
        return null;
    }

    protected abstract void addNewDiagram(ServicesRegistry var1);

    protected void addNewDiagram(String name, String type, EObject diagram, ServicesRegistry registry) {
        Diagram di2Diagram = NotationFactory.eINSTANCE.createDiagram();
        di2Diagram.setVisible(true);
        di2Diagram.setType(type);
        if (name != null) {
            di2Diagram.setName(name);
        }
        NotationUtils.getNotationModel().addDiagram(di2Diagram);
        try {
            ((IPageManager)registry.getService(IPageManager.class)).openPage((Object)di2Diagram);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }
}

