/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers3.ui.view;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers3.ui.view.LayersExplorerView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class LayersExplorerViewUtils {
    public static final String LayersExplorerViewId = "org.eclipse.papyrus.layers.ui.view.layersexplorer";

    public static void openView(ExecutionEvent event) {
        try {
            HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().showView(LayersExplorerViewId);
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public static void openView(IEvaluationContext context) {
        try {
            LayersExplorerViewUtils.getActiveWorkbenchWindow(context).getActivePage().showView(LayersExplorerViewId);
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public static LayersExplorerView findView(ExecutionEvent event) throws NotFoundException {
        IViewPart part = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().findView(LayersExplorerViewId);
        if (part instanceof LayersExplorerView) {
            return (LayersExplorerView)part;
        }
        throw new NotFoundException("Can't find LayersExplorerView.");
    }

    public static LayersExplorerView findView(IEvaluationContext context) throws NotFoundException {
        IViewPart part = LayersExplorerViewUtils.getActiveWorkbenchWindow(context).getActivePage().findView(LayersExplorerViewId);
        if (part instanceof LayersExplorerView) {
            return (LayersExplorerView)part;
        }
        throw new NotFoundException("Can't find LayersExplorerView.");
    }

    public static boolean isViewOpened(ExecutionEvent event) {
        try {
            return LayersExplorerViewUtils.findView(event) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static boolean isViewOpened(IEvaluationContext context) {
        try {
            return LayersExplorerViewUtils.findView(context) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow(IEvaluationContext context) {
        Object o = HandlerUtil.getVariable((Object)context, (String)"activeWorkbenchWindow");
        if (o instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)o;
        }
        return null;
    }
}

