/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers3.ui.view;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.provider.NotationItemProviderAdapterFactory;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainerChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.SashWindowsEventsProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.layers.runtime.ILayersStackApplicationEventListener;
import org.eclipse.papyrus.layers.runtime.LayersStackAndApplicationLifeCycleEventNotifier;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.ui.Activator;
import org.eclipse.papyrus.layers3.ui.view.LayersTreeViewerFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wb.swt.SWTResourceManager;

public class LayersExplorerView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    private Label nameLabel;
    private Label containerLabel;
    private LayersModel currentLayersModel = null;
    private ServicesRegistry currentServicesRegistry = null;
    protected SashWindowsEventsProvider sashEventsProvider;
    protected IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(IPage newPage) {
            LayersExplorerView.this.setActivePage(newPage);
        }
    };
    protected ISashWindowsContainerChangedListener containerChangedListener = new ISashWindowsContainerChangedListener(){

        public void sashWindowsContainerChanged(ISashWindowsContainer newContainer) {
            LayersExplorerView.this.activeSashWindowContainerChanged(newContainer);
        }
    };
    protected TreeViewer layersExplorerTree;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            Activator.log.info(String.valueOf(this.getClass().getName()) + " is disposed !!!" + e.widget);
        }
    };
    protected ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (Activator.log.isDebugEnabled()) {
                Activator.log.debug(String.valueOf(((Object)((Object)LayersExplorerView.this)).getClass().getSimpleName()) + ".selectionChanged(" + event.getSelection() + ")");
            }
        }
    };
    protected LayersStackAndApplicationLifeCycleEventNotifier currentLayersStackNotifier = null;
    protected ILayersStackApplicationEventListener layersStackLifeCycleEventListener = new ILayersStackApplicationEventListener(){

        public void layerStackRemoved(Notification msg) {
            LayersExplorerView.this.refreshLayersExplorerTree();
        }

        public void layerStackAdded(Notification msg) {
            LayersExplorerView.this.refreshLayersExplorerTree();
        }
    };

    public String getContributorId() {
        return "TreeOutlinePage";
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    protected void init() {
        this.sashEventsProvider = new SashWindowsEventsProvider(this.getSite().getPage());
        this.sashEventsProvider.addPageChangedListener(this.pageChangedListener);
        this.sashEventsProvider.addSashWindowsContainerChangedListener(this.containerChangedListener);
        this.activeSashWindowContainerChanged(this.sashEventsProvider.activeSashWindowsContainer());
    }

    public void dispose() {
        super.dispose();
        if (this.sashEventsProvider != null) {
            this.sashEventsProvider.removePageChangedListener(this.pageChangedListener);
            this.sashEventsProvider.removeSashWindowsContainerChangedListener(this.containerChangedListener);
            this.sashEventsProvider = null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    protected void createlayersExplorerTreeControl(Composite parent) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new NotationItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.layersExplorerTree.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.layersExplorerTree.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite headerComposite = new Composite(composite, 2048);
        headerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        headerComposite.setLayout((Layout)new GridLayout(2, false));
        Label diagramNameLabel = new Label(headerComposite, 0);
        diagramNameLabel.setText("Diagram");
        this.nameLabel = new Label(headerComposite, 2048);
        GridData gd_nameLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_nameLabel.horizontalIndent = 2;
        this.nameLabel.setLayoutData((Object)gd_nameLabel);
        this.nameLabel.setBackground(SWTResourceManager.getColor(1));
        this.nameLabel.setText("Hello World");
        this.nameLabel.setText("container");
        Label containerNameLabel = new Label(headerComposite, 0);
        containerNameLabel.setText("Container");
        this.containerLabel = new Label(headerComposite, 2048);
        GridData gd_containerLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_containerLabel.horizontalIndent = 2;
        this.containerLabel.setLayoutData((Object)gd_containerLabel);
        this.containerLabel.setBackground(SWTResourceManager.getColor(1));
        this.layersExplorerTree = new TreeViewer(composite, 2);
        LayersTreeViewerFactory.initContentAndLabelProviders(this.layersExplorerTree);
        LayersTreeViewerFactory.initContextMenuFor(this.getSite(), (StructuredViewer)this.layersExplorerTree);
        Tree tree = this.layersExplorerTree.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        parent.addDisposeListener(this.disposeListener);
        this.layersExplorerTree.getTree().addDisposeListener(this.disposeListener);
        this.init();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.layersExplorerTree);
        this.layersExplorerTree.addSelectionChangedListener(this.selectionChangedListener);
    }

    public void setFocus() {
        this.layersExplorerTree.getTree().setFocus();
    }

    protected void activeSashWindowContainerChanged(ISashWindowsContainer newContainer) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("activeSashWindowContainerChanged(" + (newContainer != null ? newContainer : "noContainer") + ")");
        }
        if (newContainer == null) {
            this.currentServicesRegistry = null;
            this.currentLayersModel = null;
            this.switchLayersStackLifeCycleEventListener(null);
            this.setLabels(null);
            this.setEmptyTreeInput();
            return;
        }
        this.currentServicesRegistry = null;
        this.currentLayersModel = null;
        try {
            this.currentServicesRegistry = this.getServiceRegistry();
            this.currentLayersModel = this.getLayersModel();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.currentServicesRegistry = null;
            this.currentLayersModel = null;
            this.switchLayersStackLifeCycleEventListener(null);
            this.setLabels(null);
            this.setEmptyTreeInput();
            return;
        }
        this.switchLayersStackLifeCycleEventListener(this.currentLayersModel.getLayersStackLifeCycleEventNotifier());
        this.setLabels(newContainer);
        this.refreshLayersExplorerTree();
    }

    private LayersModel getLayersModel() throws ServiceException, NotFoundException {
        ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)this.currentServicesRegistry);
        LayersModel model = (LayersModel)modelSet.getModelChecked("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        return model;
    }

    private ServicesRegistry getServiceRegistry() throws NotFoundException {
        IEditorPart editor = this.sashEventsProvider.activeSashWindowsContainerOwner();
        if (editor == null) {
            throw new NotFoundException();
        }
        ServicesRegistry registry = (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
        if (registry == null) {
            throw new NotFoundException();
        }
        return registry;
    }

    private void switchLayersStackLifeCycleEventListener(LayersStackAndApplicationLifeCycleEventNotifier newNotifier) {
        if (this.currentLayersStackNotifier != null) {
            this.currentLayersStackNotifier.removeLayersModelEventListener(this.layersStackLifeCycleEventListener);
        }
        this.currentLayersStackNotifier = newNotifier;
        if (this.currentLayersStackNotifier != null) {
            this.currentLayersStackNotifier.addLayersModelEventListener(this.layersStackLifeCycleEventListener);
        }
    }

    protected void setActivePage(IPage newPage) {
        this.setActivePageLabel(newPage);
        this.refreshLayersExplorerTree();
    }

    private void setEmptyTreeInput() {
        this.setTreeInput(null);
    }

    protected void resetTreeInput() {
        IEditorPart editor = this.sashEventsProvider.activeSashWindowsContainerOwner();
        if (editor == null) {
            this.setEmptyTreeInput();
            return;
        }
        ServicesRegistry registry = (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
        if (registry == null) {
            Activator.log.info("New editor has no ServiceRegistry");
            this.setEmptyTreeInput();
            return;
        }
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)registry);
            LayersModel model = (LayersModel)modelSet.getModelChecked("org.eclipse.papyrus.layers.runtime.model.LayersModel");
            Diagram currentDiagram = this.getCurrentDiagram();
            if (currentDiagram == null) {
                this.setEmptyTreeInput();
                return;
            }
            LayersStackApplication application = model.lookupLayerStackApplication();
            if (application == null) {
                this.setEmptyTreeInput();
                return;
            }
            this.setTreeInput(application.lookupLayersStackFor(currentDiagram));
            this.layersExplorerTree.setSelection((ISelection)new StructuredSelection(model.getLayerStackApplication().getLayersStacks().get(0)), true);
            return;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            this.setEmptyTreeInput();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            this.setEmptyTreeInput();
        }
        catch (org.eclipse.papyrus.layers.stackmodel.NotFoundException e) {
            this.setEmptyTreeInput();
        }
    }

    public void refreshTreeInput() {
        this.layersExplorerTree.refresh();
    }

    private Diagram getCurrentDiagram() {
        IPage page = this.sashEventsProvider.activeSashWindowsPage();
        if (!(page instanceof IEditorPage) || !(((IEditorPage)page).getIEditorPart() instanceof DiagramDocumentEditor)) {
            return null;
        }
        DiagramDocumentEditor diagramEditor = (DiagramDocumentEditor)((IEditorPage)page).getIEditorPart();
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram == null) {
            return null;
        }
        return diagram;
    }

    private void setTreeInput(Object input) {
        this.layersExplorerTree.setInput(input);
    }

    protected void setLabels(ISashWindowsContainer newContainer) {
        if (newContainer != null) {
            this.containerLabel.setText(newContainer.toString());
            this.setActivePageLabel(newContainer.getActiveSashWindowsPage());
        } else {
            this.containerLabel.setText("nocontainer");
            this.setActivePageLabel(null);
        }
    }

    protected void setSashWindowContainerLabel(ISashWindowsContainer newContainer) {
        if (newContainer != null) {
            this.containerLabel.setText(newContainer.toString());
        } else {
            this.containerLabel.setText("nocontainer");
        }
    }

    protected void setActivePageLabel(IPage newPage) {
        if (newPage != null) {
            this.nameLabel.setText(newPage.getPageTitle());
        } else {
            this.nameLabel.setText("nopage");
        }
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        String menuId = "org.eclipse.papyrus.layers.stackmodel.diagram.ui.contextmenu";
        this.getSite().registerContextMenu(menuId, contextMenu, (ISelectionProvider)viewer);
    }

    public void refreshLayersExplorerTree() {
        LayersStack currentLayersStack = this.lookupCurrentLayersStack();
        if (currentLayersStack != null) {
            this.setTreeInput(currentLayersStack);
            this.layersExplorerTree.setSelection((ISelection)new StructuredSelection((Object)currentLayersStack), true);
        } else {
            this.setEmptyTreeInput();
        }
    }

    private LayersStack lookupCurrentLayersStack() {
        LayersStackApplication application;
        Diagram currentDiagram;
        block6: {
            block5: {
                if (this.currentLayersModel == null || this.currentServicesRegistry == null) {
                    Activator.log.info("Error - " + ((Object)((Object)this)).getClass().getSimpleName() + " - currentLayersModel and currentServicesRegistry should not be null.");
                    return null;
                }
                try {
                    currentDiagram = this.getCurrentDiagram();
                    if (currentDiagram != null) break block5;
                    return null;
                }
                catch (org.eclipse.papyrus.layers.stackmodel.NotFoundException notFoundException) {
                    return null;
                }
            }
            application = this.currentLayersModel.lookupLayerStackApplication();
            if (application != null) break block6;
            return null;
        }
        return application.lookupLayersStackFor(currentDiagram);
    }
}

