/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers3.ui.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.AbstractLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerExpression;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.ui.Activator;
import org.eclipse.papyrus.layers3.ui.commands.AbstractLayersCommand;

public class CreateLayerOperatorsFromParameter
extends AbstractLayersCommand {
    private static int creationCount = 0;
    private String newLayerID;
    private LayersStackApplication application;

    @Override
    protected boolean preExecute(ExecutionEvent event, IEvaluationContext context, List<Object> selections) throws ExecutionException {
        if (!this.isEnabled(context, selections)) {
            return false;
        }
        this.newLayerID = event.getParameter("org.eclipse.papyrus.layers.ui.createLayerOperator.parameters");
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("Create Layer Operators '" + this.newLayerID + "'.");
        }
        try {
            this.application = this.lookupLayersStackApplicationChecked(context);
        }
        catch (org.eclipse.papyrus.layers.stackmodel.NotFoundException e) {
            return false;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ServiceException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context, List<Object> selections) {
        AbstractLayerOperator layerOperator;
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".doExecute()");
        }
        try {
            layerOperator = this.application.getLayerOperatorDescriptorRegistry().createLayerOperator(this.newLayerID);
            layerOperator.setName("layer" + creationCount++);
            layerOperator.setApplication(this.application);
        }
        catch (LayersException e) {
            Activator.log.error("Log - " + ((Object)((Object)this)).getClass().getName() + " - " + e.getMessage(), (Throwable)e);
            return;
        }
        Object selection = selections.get(0);
        if (selection instanceof LayersStack) {
            LayersStack stack = (LayersStack)selection;
            stack.setLayers((LayerExpression)layerOperator);
        } else {
            LayerOperator operator = (LayerOperator)selection;
            operator.getLayers().add((Object)layerOperator);
        }
    }

    @Override
    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        if (selections.size() != 1) {
            return false;
        }
        Object first = selections.get(0);
        boolean res = first instanceof LayerOperator || first instanceof LayersStack;
        return res;
    }

    @Override
    public String getCommandName() {
        return "Create Layer Operator";
    }
}

