/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers3.ui.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.AbstractLayer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers3.ui.commands.AbstractLayersCommand;
import org.eclipse.swt.widgets.Display;

public class AttachPropertyToLayer
extends AbstractLayersCommand {
    @Override
    public String getCommandName() {
        return "Attach a property";
    }

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context, List<Object> selections) {
        if (!this.isEnabled(context, selections)) {
            return;
        }
        String currentName = "";
        String newName = null;
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Attach a Property to Layer", "Enter the name of an existing property", currentName, null);
        if (dialog.open() == 0) {
            newName = dialog.getValue();
            if (newName == null || newName.length() <= 0) {
                return;
            }
        } else {
            return;
        }
        try {
            LayersStackApplication application = this.lookupLayersStackApplicationChecked(context);
            Property property = application.getPropertyRegistry().getProperty(newName);
            AbstractLayer layer = (AbstractLayer)this.getSelections(context).get(0);
            layer.addPropertyInstance(property);
        }
        catch (LayersException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        return this.selectionFirstElementInstanceOf(selections, AbstractLayer.class);
    }
}

