/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers3.ui.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.layers.notationmodel.edit.NotationItemProviderAdapterFactory;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.AbstractLayer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.ui.Activator;
import org.eclipse.papyrus.layers3.ui.commands.AbstractLayersCommand;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;

public class AttachDiagramViewsToLayer
extends AbstractLayersCommand {
    @Override
    public String getCommandName() {
        return "Attach multiple views";
    }

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context, List<Object> selections) {
        if (!this.isEnabled(context, selections)) {
            return;
        }
        try {
            LayersStackApplication application = this.lookupLayersStackApplicationChecked(context);
            AbstractLayer layer = (AbstractLayer)this.getSelections(context).get(0);
            Diagram diagram = layer.getOwningLayersStack().getDiagram();
            UMLItemProviderAdapterFactory domainAdapterFactory = new UMLItemProviderAdapterFactory();
            NotationItemProviderAdapterFactory adapterFactory = new NotationItemProviderAdapterFactory((AdapterFactory)domainAdapterFactory);
            AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
            CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
            dialog.setTitle("Diagram Views Selection");
            dialog.setMessage("Select Views to attach to the current layer:");
            dialog.setInput((Object)diagram);
            EList initialSelection = layer.getViews();
            dialog.setInitialSelections((Object[])initialSelection.toArray(new View[0]));
            if (dialog.open() != 0) {
                return;
            }
            Object[] res = dialog.getResult();
            ArrayList<View> finalSelection = new ArrayList<View>(res.length);
            ArrayList<View> unchangedProperties = new ArrayList<View>(initialSelection.size());
            ArrayList<View> setProperties = new ArrayList<View>(finalSelection.size());
            Object[] objectArray = res;
            int n = res.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                finalSelection.add((View)o);
                if (initialSelection.contains(o)) {
                    unchangedProperties.add((View)o);
                } else {
                    setProperties.add((View)o);
                }
                ++n2;
            }
            ArrayList unsetProperties = new ArrayList(initialSelection);
            unsetProperties.removeAll(unchangedProperties);
            for (View property : unsetProperties) {
                if (Activator.log.isDebugEnabled()) {
                    Activator.log.debug("unset view " + property.getElement());
                }
                layer.getViews().remove((Object)property);
            }
            for (View property : setProperties) {
                if (Activator.log.isDebugEnabled()) {
                    Activator.log.debug("set Property " + property.getElement());
                }
                layer.getViews().add((Object)property);
            }
        }
        catch (LayersException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        return this.selectionFirstElementInstanceOf(selections, AbstractLayer.class);
    }
}

