/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.services.decorator;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;

public class Decoration
extends Figure
implements AncestorListener,
IDecoration {
    private Locator locator;
    private IFigure owner;
    private boolean ignoreParentVisibility;

    public Decoration() {
        this.setFocusTraversable(false);
    }

    public boolean isVisible() {
        Rectangle decorationBounds = this.getBounds().getCopy();
        this.translateToAbsolute((Translatable)decorationBounds);
        IFigure parentFigure = this.getOwnerFigure();
        while (parentFigure != null) {
            if (!this.shouldIgnoreParentVisibility() && !parentFigure.isVisible()) {
                return false;
            }
            if (parentFigure instanceof ResizableCompartmentFigure) {
                Rectangle parentClientArea = parentFigure.getClientArea().getCopy();
                parentFigure.translateToAbsolute((Translatable)parentClientArea);
                if (!parentClientArea.contains(decorationBounds)) {
                    return false;
                }
            }
            parentFigure = parentFigure.getParent();
        }
        return super.isVisible();
    }

    public void validate() {
        if (this.getLocator() != null) {
            this.getLocator().relocate((IFigure)this);
        }
        super.validate();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public IFigure getOwnerFigure() {
        return this.owner;
    }

    public void setOwnerFigure(IFigure figure) {
        this.owner = figure;
    }

    public void addNotify() {
        super.addNotify();
        this.getOwnerFigure().addAncestorListener((AncestorListener)this);
    }

    public void removeNotify() {
        this.getOwnerFigure().removeAncestorListener((AncestorListener)this);
        super.removeNotify();
    }

    public void ancestorMoved(IFigure ancestor) {
        this.revalidate();
    }

    public void ancestorAdded(IFigure ancestor) {
    }

    public void ancestorRemoved(IFigure ancestor) {
    }

    public void setIgnoreParentVisibility(boolean ignoreParentVisibility) {
        this.ignoreParentVisibility = ignoreParentVisibility;
    }

    public boolean shouldIgnoreParentVisibility() {
        return this.ignoreParentVisibility;
    }
}

