/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadRevisionByVersionRequest
extends CDOClientRequest<InternalCDORevision> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionByVersionRequest.class);
    private CDOID id;
    private CDOBranchVersion branchVersion;
    private int referenceChunk;

    public LoadRevisionByVersionRequest(CDOClientProtocol protocol, CDOID id, CDOBranchVersion branchVersion, int referenceChunk) {
        super(protocol, (short)8);
        this.id = id;
        this.branchVersion = branchVersion;
        this.referenceChunk = referenceChunk;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing id: {0}", new Object[]{this.id});
        }
        out.writeCDOID(this.id);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing branchVersion: {0}", new Object[]{this.branchVersion});
        }
        out.writeCDOBranchVersion(this.branchVersion);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing referenceChunk: {0}", new Object[]{this.referenceChunk});
        }
        out.writeInt(this.referenceChunk);
    }

    @Override
    protected InternalCDORevision confirming(CDODataInput in) throws IOException {
        return RevisionInfo.readResult((CDODataInput)in, (CDOID)this.id, (CDOBranch)this.branchVersion.getBranch());
    }

    public String toString() {
        return MessageFormat.format("LoadRevisionByVersionRequest(id={0}, branchVersion={1}, referenceChunk={2})", this.id, this.branchVersion, this.referenceChunk);
    }
}

