/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBranchesRequest
extends CDOClientRequest<Integer> {
    private int startID;
    private int endID;
    private CDOBranchHandler handler;

    public LoadBranchesRequest(CDOClientProtocol protocol, int startID, int endID, CDOBranchHandler handler) {
        super(protocol, (short)36);
        this.startID = startID;
        this.endID = endID;
        this.handler = handler;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeInt(this.startID);
        out.writeInt(this.endID);
    }

    @Override
    protected Integer confirming(CDODataInput in) throws IOException {
        int count = 0;
        while (in.readByte() == 1) {
            CDOBranch branch = in.readCDOBranch();
            this.handler.handleBranch(branch);
            ++count;
        }
        return count;
    }
}

