/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IOvalAnchorableFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableOvalAnchor;

public class ContainmentFigure
extends DefaultSizeNodeFigure
implements IOvalAnchorableFigure {
    public ContainmentFigure() {
        this(20, 20);
    }

    public ContainmentFigure(int width, int height) {
        super(width, height);
    }

    public ContainmentFigure(Dimension dim) {
        super(dim);
    }

    public ContainmentFigure(int diameter) {
        this(diameter, diameter);
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBounds());
        graphics.fillOval(r);
        --r.width;
        --r.height;
        graphics.drawOval(r);
        graphics.pushState();
        graphics.setBackgroundColor(ColorConstants.black);
        Rectangle rect1 = this.getBounds().getCopy();
        int scaleFactor_horizontale = rect1.height / 2;
        int scaleFactor_verticale = rect1.width / 2;
        graphics.drawLine(rect1.x, rect1.y + scaleFactor_horizontale, rect1.x + (int)Math.floor(rect1.width * scaleFactor_horizontale), rect1.y - (1 - scaleFactor_horizontale));
        graphics.drawLine(rect1.x + scaleFactor_verticale, rect1.y, rect1.x - (1 - scaleFactor_verticale), rect1.y + (int)Math.floor(rect1.height * scaleFactor_verticale));
        graphics.popState();
    }

    public final Rectangle getOvalBounds() {
        return this.getBounds();
    }

    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        if (p == null) {
            return this.createDefaultAnchor();
        }
        return new SlidableOvalAnchor((IOvalAnchorableFigure)this, p);
    }

    protected ConnectionAnchor createDefaultAnchor() {
        return new SlidableOvalAnchor((IOvalAnchorableFigure)this);
    }

    protected void fillShape(Graphics graphics) {
        graphics.pushState();
        graphics.setBackgroundColor(ColorConstants.white);
        graphics.fillOval(this.getBounds());
        graphics.popState();
        Dimension dim = new Dimension(20, 20);
        this.setMaximumSize(dim);
    }
}

