/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.ide.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.internal.team.RepositoryManager;
import org.eclipse.emf.cdo.internal.team.RepositoryTeamProvider;
import org.eclipse.emf.cdo.internal.ui.perspectives.CDOPerspective;
import org.eclipse.emf.cdo.ui.internal.ide.bundle.OM;
import org.eclipse.emf.cdo.ui.internal.ide.messages.Messages;
import org.eclipse.emf.cdo.ui.internal.ide.wizards.CDOShareProjectWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class CDOProjectCreationWizard
extends Wizard
implements IWorkbenchWizard {
    private WizardNewProjectCreationPage projectCreationPage;
    private CDOShareProjectWizardPage sharePage;
    private IProject newProject;
    private IWorkbench workbench;

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        try {
            RepositoryTeamProvider.mapProject((IProject)this.newProject, (String)this.sharePage.getSessionDescription());
        }
        catch (TeamException ex) {
            OM.LOG.equals((Object)ex);
            return false;
        }
        RepositoryManager.INSTANCE.addElement(this.newProject);
        if (!CDOPerspective.isCurrent()) {
            this.openCDOExplorerPerspective(this.workbench);
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.projectCreationPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.projectCreationPage.setTitle(Messages.getString("CDOProjectCreationWizard.4"));
        this.projectCreationPage.setDescription(Messages.getString("CDOProjectCreationWizard.2"));
        super.addPage((IWizardPage)this.projectCreationPage);
        this.sharePage = new CDOShareProjectWizardPage("shareProject");
        this.sharePage.setTitle(Messages.getString("TeamConfigurationWizard_2"));
        super.addPage((IWizardPage)this.sharePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("CDOProjectCreationWizard.4"));
        this.initializeDefaultPageImageDescriptor();
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = OM.getImageDescriptor("icons/full/wizban/wizard_icon.gif");
        this.setDefaultPageImageDescriptor(desc);
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject newProjectHandle = this.projectCreationPage.getProjectHandle();
        URI location = null;
        if (!this.projectCreationPage.useDefaults()) {
            location = this.projectCreationPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CreateProjectOperation op = new CreateProjectOperation(description, Messages.getString("CDOProjectCreationWizard.0"));
                try {
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)CDOProjectCreationWizard.this.getShell()));
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExecutionException && t.getCause() instanceof CoreException) {
                CoreException cause = (CoreException)t.getCause();
                StatusAdapter status = cause.getStatus().getCode() == 275 ? new StatusAdapter((IStatus)new Status(2, "org.eclipse.emf.cdo.ui.ide", cause.getMessage(), (Throwable)cause)) : new StatusAdapter((IStatus)new Status(cause.getStatus().getSeverity(), "org.eclipse.emf.cdo.ui.ide", cause.getMessage(), (Throwable)cause));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.getString("CDOProjectCreationWizard.1"));
                StatusManager.getManager().handle(status, 4);
            } else {
                StatusAdapter status = new StatusAdapter((IStatus)new Status(2, "org.eclipse.emf.cdo.ui.ide", t.getMessage(), t));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.getString("CDOProjectCreationWizard.1"));
                StatusManager.getManager().handle(status, 5);
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    public void openCDOExplorerPerspective(final IWorkbench workbench) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    boolean result = MessageDialog.openQuestion((Shell)CDOProjectCreationWizard.this.getShell(), (String)Messages.getString("CDOProjectCreationWizard.5"), (String)Messages.getString("CDOProjectCreationWizard.6"));
                    if (result) {
                        workbench.showPerspective("org.eclipse.emf.cdo.ui.CDOExplorerPerspective", workbench.getActiveWorkbenchWindow());
                    }
                }
                catch (WorkbenchException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        });
    }
}

