/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.Constants;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.GeneralOrderingUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.MessageUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TickUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TimeElementUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.DestructionOccurrenceSpecificationEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.MessageOccurrenceSpecificationEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.OccurrenceSpecificationEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;

public final class OccurrenceSpecificationUtils {
    private static final String AUTOGENERATED_OCCURRENCE_SPECIFICATION_NAME = "org.eclipse.papyrus.uml.diagram.timing.autogeneratedOccurrenceSpecificationName";

    private OccurrenceSpecificationUtils() {
    }

    public static boolean isOccurrenceSpecificationEditPart(int visualID) {
        return visualID == 12 || visualID == 13 || visualID == 27;
    }

    public static boolean isOccurrenceSpecificationEditPart(EditPart editPart) {
        return editPart instanceof OccurrenceSpecificationEditPartCN || editPart instanceof MessageOccurrenceSpecificationEditPartCN || editPart instanceof DestructionOccurrenceSpecificationEditPartCN;
    }

    public static boolean isOccurrenceSpecificationView(View view) {
        int visualID = UMLVisualIDRegistry.getVisualID(view);
        return OccurrenceSpecificationUtils.isOccurrenceSpecificationEditPart(visualID);
    }

    private static EAnnotation getAutogeneratedAnnotation(OccurrenceSpecification occurrenceSpecification) {
        return occurrenceSpecification.getEAnnotation(AUTOGENERATED_OCCURRENCE_SPECIFICATION_NAME);
    }

    public static void setAutogeneratedName(OccurrenceSpecification occurrenceSpecification, boolean autogenerated) {
        EAnnotation eAnnotation = OccurrenceSpecificationUtils.getAutogeneratedAnnotation(occurrenceSpecification);
        if (autogenerated && eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(AUTOGENERATED_OCCURRENCE_SPECIFICATION_NAME);
            occurrenceSpecification.getEAnnotations().add((Object)eAnnotation);
        } else if (!autogenerated && eAnnotation != null) {
            occurrenceSpecification.getEAnnotations().remove((Object)eAnnotation);
        }
    }

    public static boolean isAutogeneratedName(OccurrenceSpecification occurrenceSpecification) {
        EAnnotation eAnnotation = OccurrenceSpecificationUtils.getAutogeneratedAnnotation(occurrenceSpecification);
        return eAnnotation != null;
    }

    public static Collection<EObject> getElementsToDelete(OccurrenceSpecification occurrenceSpecification) {
        HashSet<EObject> elementsToDestroy = new HashSet<EObject>();
        Set crossReferencingViews = CrossReferencerUtil.getCrossReferencingViews((EObject)occurrenceSpecification, (String)"PapyrusUMLTimingDiagram");
        for (View view : crossReferencingViews) {
            elementsToDestroy.addAll(OccurrenceSpecificationUtils.getElementsToRemove(view, false));
        }
        return elementsToDestroy;
    }

    public static Collection<View> getViewsToHide(View occurrenceSpecificationView) {
        HashSet<View> viewsToHide = new HashSet<View>();
        Collection<EObject> elementsToRemove = OccurrenceSpecificationUtils.getElementsToRemove(occurrenceSpecificationView, true);
        for (EObject eObject : elementsToRemove) {
            if (eObject instanceof View) {
                viewsToHide.add((View)eObject);
                continue;
            }
            throw new IllegalStateException("Only views should be returned");
        }
        return viewsToHide;
    }

    public static Collection<EObject> getElementsToRemove(View occurrenceSpecificationView, boolean hideOnly) {
        HashSet<EObject> elementsToRemove = new HashSet<EObject>();
        if (OccurrenceSpecificationUtils.isOccurrenceSpecificationView(occurrenceSpecificationView)) {
            List<Node> associatedTickViews = TickUtils.getAssociatedTickViews(occurrenceSpecificationView);
            elementsToRemove.addAll(associatedTickViews);
            View interactionView = ViewUtils.findSuperViewWithId(occurrenceSpecificationView, 2);
            EObject eContainer = occurrenceSpecificationView.eContainer();
            if (eContainer instanceof Node) {
                View following;
                Node node = (Node)eContainer;
                EList children = node.getChildren();
                int childrenSize = children.size();
                int index = children.indexOf((Object)occurrenceSpecificationView);
                boolean done = false;
                if (index == 0) {
                    if (index + 1 < childrenSize && (following = (View)children.get(index + 1)).getType().equals(Constants.verticalLineId)) {
                        elementsToRemove.add((EObject)following);
                    }
                    done = true;
                }
                if (!done && index + 2 < childrenSize) {
                    View following1 = (View)children.get(index + 1);
                    View following2 = (View)children.get(index + 2);
                    if (following1.getType().equals(Constants.verticalLineId) && following2.getType().equals(Constants.fullStateInvariantId)) {
                        elementsToRemove.add((EObject)following1);
                        elementsToRemove.add((EObject)following2);
                        if (!hideOnly) {
                            elementsToRemove.add(following2.getElement());
                        }
                        elementsToRemove.addAll(StateInvariantUtils.getRelatedElementsToRemove(following2.getElement(), hideOnly, interactionView));
                        done = true;
                    }
                }
                if (!done && index + 1 < childrenSize && ((following = (View)children.get(index + 1)).getType().equals(Constants.fullStateInvariantId) || following.getType().equals(Constants.compactStateInvariantId))) {
                    elementsToRemove.add((EObject)following);
                    if (!hideOnly) {
                        elementsToRemove.add(following.getElement());
                    }
                    elementsToRemove.addAll(StateInvariantUtils.getRelatedElementsToRemove(following.getElement(), hideOnly, interactionView));
                }
            }
            OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)occurrenceSpecificationView.getElement();
            elementsToRemove.addAll(OccurrenceSpecificationUtils.getRelatedElementsToRemove((EObject)occurrenceSpecification, hideOnly, interactionView));
        }
        return elementsToRemove;
    }

    public static Collection<? extends EObject> getRelatedElementsToRemove(EObject occurrenceSpecification, boolean hideOnly, View interactionView) {
        Assert.isLegal((boolean)(occurrenceSpecification instanceof OccurrenceSpecification));
        HashSet<Object> elementsToRemove = new HashSet<Object>();
        elementsToRemove.addAll(TimeElementUtils.getTimeElementsToRemove(occurrenceSpecification, hideOnly, interactionView));
        elementsToRemove.addAll(MessageUtils.getReferencingMessagesToRemove(occurrenceSpecification, hideOnly, interactionView));
        elementsToRemove.addAll(GeneralOrderingUtils.getReferencingGeneralOrderingsToRemove(occurrenceSpecification, hideOnly, interactionView));
        return elementsToRemove;
    }

    private static void deleteEverythingAfterOrBefore(OccurrenceSpecification occurrenceSpecification, View occurrenceSpecificationView, boolean before) {
        EList coveredLifelines = occurrenceSpecification.getCovereds();
        for (Lifeline lifeline : coveredLifelines) {
            EList coveredBys = lifeline.getCoveredBys();
            int index = coveredBys.indexOf((Object)occurrenceSpecification);
            if (index == -1) continue;
            if (before && index + 1 < coveredBys.size() && !(coveredBys.get(index + 1) instanceof StateInvariant) && OccurrenceSpecificationUtils.movePreviousStateInvariantAfter((EList<InteractionFragment>)coveredBys, occurrenceSpecification)) {
                --index;
            }
            ArrayList<InteractionFragment> fragmentsToRemove = new ArrayList<InteractionFragment>();
            int i = before ? index - 1 : index + 1;
            while (!(before ? i < 0 : i >= coveredBys.size())) {
                fragmentsToRemove.add((InteractionFragment)coveredBys.get(i));
                int n = i = before ? i - 1 : i + 1;
            }
            for (InteractionFragment fragmentToRemove : fragmentsToRemove) {
                Collection<Object> relatedElementsToRemove = Collections.emptyList();
                if (fragmentToRemove instanceof OccurrenceSpecification) {
                    OccurrenceSpecification occurrence = (OccurrenceSpecification)fragmentToRemove;
                    relatedElementsToRemove = OccurrenceSpecificationUtils.getRelatedElementsToRemove((EObject)occurrence, false, null);
                } else if (fragmentToRemove instanceof StateInvariant) {
                    StateInvariant stateInvariant = (StateInvariant)fragmentToRemove;
                    relatedElementsToRemove = StateInvariantUtils.getRelatedElementsToRemove((EObject)stateInvariant, false, null);
                }
                for (EObject eObject : relatedElementsToRemove) {
                    DestroyElementCommand.destroy((EObject)eObject);
                }
                DestroyElementCommand.destroy((EObject)fragmentToRemove);
            }
        }
        Collection<Object> views = occurrenceSpecificationView == null ? CrossReferencerUtil.getCrossReferencingViews((EObject)occurrenceSpecification, (String)"PapyrusUMLTimingDiagram") : Collections.singletonList(occurrenceSpecificationView);
        for (View view : views) {
            View childView;
            int visualID;
            View parentView = (View)view.eContainer();
            EList children = parentView.getChildren();
            int index = children.indexOf((Object)view);
            if (index == -1) continue;
            ArrayList<View> viewsToRemove = new ArrayList<View>();
            int i = before ? index - 1 : index + 1;
            while (!(before ? i < 0 : i >= children.size())) {
                View childView2 = (View)children.get(i);
                int visualID2 = UMLVisualIDRegistry.getVisualID(childView2);
                if (OccurrenceSpecificationUtils.isOccurrenceSpecificationEditPart(visualID2) || StateInvariantUtils.isStateInvariantEditPart(visualID2) || visualID2 == 39) {
                    viewsToRemove.add(childView2);
                }
                int n = i = before ? i - 1 : i + 1;
            }
            if (before && index + 1 < children.size() && (visualID = UMLVisualIDRegistry.getVisualID(childView = (View)children.get(index + 1))) == 39) {
                viewsToRemove.add(childView);
            }
            for (View viewToRemove : viewsToRemove) {
                ViewUtil.destroy((View)viewToRemove);
            }
        }
    }

    private static boolean movePreviousStateInvariantAfter(EList<InteractionFragment> fragments, OccurrenceSpecification occurrenceSpecification) {
        int umlIndex = fragments.indexOf((Object)occurrenceSpecification);
        int previousStateInvariantIndex = OccurrenceSpecificationUtils.findPreviousStateInvariantIndex(umlIndex, fragments);
        if (previousStateInvariantIndex == -1) {
            Activator.log.error((Throwable)new IllegalStateException("No StateInvariant after or before the OccurrenceSpecification"));
            return false;
        }
        StateInvariant stateInvariant = (StateInvariant)fragments.get(previousStateInvariantIndex);
        fragments.move(umlIndex, previousStateInvariantIndex);
        Set stateInvariantViews = CrossReferencerUtil.getCrossReferencingViews((EObject)stateInvariant, (String)"PapyrusUMLTimingDiagram");
        for (View stateInvariantView : stateInvariantViews) {
            View parentView = (View)stateInvariantView.eContainer();
            EList children = parentView.getPersistedChildren();
            int viewIndex = -1;
            int i = 0;
            while (i < children.size()) {
                View view = (View)children.get(i);
                if (view.getElement() == occurrenceSpecification) {
                    viewIndex = i;
                    break;
                }
                ++i;
            }
            children.move(viewIndex, (Object)stateInvariantView);
        }
        return true;
    }

    private static int findPreviousStateInvariantIndex(int index, EList<InteractionFragment> fragments) {
        int i = index - 1;
        while (i >= 0) {
            InteractionFragment fragment = (InteractionFragment)fragments.get(i);
            if (fragment instanceof StateInvariant) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static void deleteEverythingAfter(OccurrenceSpecification occurrenceSpecification, View occurrenceSpecificationView) {
        OccurrenceSpecificationUtils.deleteEverythingAfterOrBefore(occurrenceSpecification, occurrenceSpecificationView, false);
    }

    public static void deleteEverythingBefore(OccurrenceSpecification occurrenceSpecification, View occurrenceSpecificationView) {
        OccurrenceSpecificationUtils.deleteEverythingAfterOrBefore(occurrenceSpecification, occurrenceSpecificationView, true);
    }

    public static int findInsertionIndexFor(Point pt, View compartmentView, EditPartViewer viewer) {
        EList children = compartmentView.getChildren();
        int index = 0;
        for (View view : children) {
            if (view instanceof Node) {
                Node node = (Node)view;
                Object editPart = viewer.getEditPartRegistry().get(node);
                if (editPart instanceof GraphicalEditPart) {
                    GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                    Rectangle bounds = graphicalEditPart.getFigure().getBounds();
                    if (pt.x < bounds.x()) {
                        break;
                    }
                } else {
                    Activator.log.error((Throwable)new Exception("No EditPart found for the Node"));
                }
            }
            ++index;
        }
        return index;
    }

    public static CompoundCommand getHideOccurrenceSpecificationCommand(EditPart occurrenceSpecificationEditPart, Command baseCommand) {
        View view = (View)occurrenceSpecificationEditPart.getModel();
        if (!OccurrenceSpecificationUtils.isOccurrenceSpecificationEditPart(UMLVisualIDRegistry.getVisualID(view))) {
            return null;
        }
        Collection<View> viewsToHide = OccurrenceSpecificationUtils.getViewsToHide(view);
        CompoundCommand compoundCommand = new CompoundCommand(Messages.OccurrenceSpecificationUtils_HideOccurrenceSpecification);
        if (baseCommand != null) {
            compoundCommand.add(baseCommand);
        }
        for (View viewToHide : viewsToHide) {
            compoundCommand.add((Command)new ICommandProxy((ICommand)new DeleteCommand(viewToHide)));
        }
        if (compoundCommand.isEmpty()) {
            return null;
        }
        return compoundCommand;
    }
}

