/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.parsers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class OccurrenceSpecificationNameParser
implements IParser {
    public String getEditString(IAdaptable adaptable, int flags) {
        OccurrenceSpecification occurrenceSpecification = OccurrenceSpecificationNameParser.getOccurrenceSpecification(adaptable);
        if (occurrenceSpecification == null) {
            return "";
        }
        return OccurrenceSpecificationNameParser.nonNullString(occurrenceSpecification.getName());
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable adaptable, final String newString, int flags) {
        final OccurrenceSpecification occurrenceSpecification = OccurrenceSpecificationNameParser.getOccurrenceSpecification(adaptable);
        if (occurrenceSpecification == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)occurrenceSpecification);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return new AbstractTransactionalCommand(editingDomain, Messages.OccurrenceSpecificationNameParser_SetOccurrenceSpecificationName, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                occurrenceSpecification.setName(newString);
                OccurrenceSpecificationUtils.setAutogeneratedName(occurrenceSpecification, false);
                return CommandResult.newOKCommandResult();
            }
        };
    }

    public String getPrintString(IAdaptable adaptable, int flags) {
        OccurrenceSpecification occurrenceSpecification = OccurrenceSpecificationNameParser.getOccurrenceSpecification(adaptable);
        if (occurrenceSpecification == null || OccurrenceSpecificationUtils.isAutogeneratedName(occurrenceSpecification)) {
            return "";
        }
        return occurrenceSpecification.getName();
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return true;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    private static OccurrenceSpecification getOccurrenceSpecification(IAdaptable adaptable) {
        Object adapter = adaptable.getAdapter(EObject.class);
        if (adapter instanceof OccurrenceSpecification) {
            return (OccurrenceSpecification)adapter;
        }
        return null;
    }

    private static String nonNullString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

