/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport.event;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class ViewportEventHandler
implements ILayerEventHandler<IStructuralChangeEvent> {
    private final ViewportLayer viewportLayer;

    public ViewportEventHandler(ViewportLayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        int i;
        Range afterPositionRange;
        IUniqueIndexLayer scrollableLayer = this.viewportLayer.getScrollableLayer();
        if (event.isHorizontalStructureChanged()) {
            int startX;
            this.viewportLayer.invalidateHorizontalStructure();
            int columnOffset = 0;
            int minimumOriginColumnPosition = this.viewportLayer.getMinimumOriginColumnPosition();
            Collection<StructuralDiff> columnDiffs = event.getColumnDiffs();
            if (columnDiffs != null) {
                if (minimumOriginColumnPosition < 0) {
                    minimumOriginColumnPosition = scrollableLayer.getColumnPositionByX(this.viewportLayer.getMinimumOrigin().getX());
                }
                block8: for (StructuralDiff columnDiff : columnDiffs) {
                    switch (columnDiff.getDiffType()) {
                        case ADD: {
                            afterPositionRange = columnDiff.getAfterPositionRange();
                            if (minimumOriginColumnPosition <= 0) break;
                            int i2 = afterPositionRange.start;
                            while (i2 < afterPositionRange.end) {
                                if (i2 < minimumOriginColumnPosition) {
                                    ++columnOffset;
                                }
                                ++i2;
                            }
                            continue block8;
                        }
                        case DELETE: {
                            Range beforePositionRange = columnDiff.getBeforePositionRange();
                            if (minimumOriginColumnPosition <= 0) break;
                            i = beforePositionRange.start;
                            while (i < beforePositionRange.end) {
                                if (i < minimumOriginColumnPosition) {
                                    --columnOffset;
                                }
                                ++i;
                            }
                            continue block8;
                        }
                    }
                }
            }
            int minimumOriginColumn = minimumOriginColumnPosition + columnOffset;
            if (this.viewportLayer.getMinColumnPosition() >= 0) {
                minimumOriginColumn = this.viewportLayer.getMinColumnPosition();
            }
            if ((startX = scrollableLayer.getStartXOfColumnPosition(minimumOriginColumn)) < 0 && minimumOriginColumnPosition > 0) {
                int columnCount = scrollableLayer.getColumnCount();
                startX = columnCount == 0 ? 0 : scrollableLayer.getStartXOfColumnPosition(columnCount - 1) + scrollableLayer.getColumnWidthByPosition(columnCount - 1);
            }
            this.viewportLayer.setMinimumOriginX(startX);
        }
        if (event.isVerticalStructureChanged()) {
            int startY;
            this.viewportLayer.invalidateVerticalStructure();
            int rowOffset = 0;
            int minimumOriginRowPosition = this.viewportLayer.getMinimumOriginRowPosition();
            Collection<StructuralDiff> rowDiffs = event.getRowDiffs();
            if (rowDiffs != null) {
                if (minimumOriginRowPosition < 0) {
                    minimumOriginRowPosition = scrollableLayer.getRowPositionByY(this.viewportLayer.getMinimumOrigin().getY());
                }
                block11: for (StructuralDiff rowDiff : rowDiffs) {
                    switch (rowDiff.getDiffType()) {
                        case ADD: {
                            afterPositionRange = rowDiff.getAfterPositionRange();
                            if (minimumOriginRowPosition <= 0) break;
                            int i3 = afterPositionRange.start;
                            while (i3 < afterPositionRange.end) {
                                if (i3 < minimumOriginRowPosition) {
                                    ++rowOffset;
                                }
                                ++i3;
                            }
                            continue block11;
                        }
                        case DELETE: {
                            Range beforePositionRange = rowDiff.getBeforePositionRange();
                            if (minimumOriginRowPosition <= 0) break;
                            i = beforePositionRange.start;
                            while (i < beforePositionRange.end) {
                                if (i < minimumOriginRowPosition) {
                                    --rowOffset;
                                }
                                ++i;
                            }
                            continue block11;
                        }
                    }
                }
            }
            int minimumOriginRow = minimumOriginRowPosition + rowOffset;
            if (this.viewportLayer.getMinRowPosition() >= 0) {
                minimumOriginRow = this.viewportLayer.getMinRowPosition();
            }
            if ((startY = scrollableLayer.getStartYOfRowPosition(minimumOriginRow)) < 0 && minimumOriginRowPosition > 0) {
                int rowCount = scrollableLayer.getRowCount();
                startY = rowCount == 0 ? 0 : scrollableLayer.getStartYOfRowPosition(rowCount - 1) + scrollableLayer.getRowHeightByPosition(rowCount - 1);
            }
            this.viewportLayer.setMinimumOriginY(startY);
        }
    }
}

