/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractTextPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public class VerticalTextPainter
extends AbstractTextPainter {
    private boolean rotateClockwise = false;

    public VerticalTextPainter() {
        this(false, true);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg) {
        this(wrapText, paintBg, 0);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, int spacing) {
        this(wrapText, paintBg, spacing, false);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, boolean calculate) {
        this(wrapText, paintBg, 0, calculate);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, boolean calculateByTextLength, boolean calculateByTextHeight) {
        this(wrapText, paintBg, 0, calculateByTextLength, calculateByTextHeight);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculate) {
        super(wrapText, paintBg, spacing, calculate);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculateByTextLength, boolean calculateByTextHeight) {
        super(wrapText, paintBg, spacing, calculateByTextLength, calculateByTextHeight);
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return gc.textExtent((String)this.convertDataType((ILayerCell)cell, (IConfigRegistry)configRegistry)).y + this.spacing * 2;
    }

    @Override
    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return this.getLengthFromCache(gc, this.convertDataType(cell, configRegistry)) + this.spacing * 2 + 1;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        block13: {
            Rectangle originalClipping;
            block14: {
                block16: {
                    String[] lines;
                    int contentHeight;
                    String text;
                    int fontHeight;
                    boolean strikethrough;
                    boolean underline;
                    IStyle cellStyle;
                    block15: {
                        if (this.paintBg) {
                            super.paintCell(cell, gc, rectangle, configRegistry);
                        }
                        if (!this.paintFg) break block13;
                        originalClipping = gc.getClipping();
                        gc.setClipping(rectangle.intersection(originalClipping));
                        cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
                        this.setupGCFromConfig(gc, cellStyle);
                        underline = this.renderUnderlined(cellStyle);
                        strikethrough = this.renderStrikethrough(cellStyle);
                        fontHeight = gc.getFontMetrics().getHeight();
                        text = this.convertDataType(cell, configRegistry);
                        text = this.getTextToDisplay(cell, gc, rectangle.height, text);
                        int numberOfNewLines = this.getNumberOfNewLines(text);
                        contentHeight = fontHeight * numberOfNewLines + this.spacing * 2;
                        int contentToCellDiff = cell.getBounds().width - rectangle.width;
                        if (contentHeight > rectangle.width && this.calculateByTextHeight) {
                            ILayer layer = cell.getLayer();
                            layer.doCommand(new ColumnResizeCommand(layer, cell.getColumnPosition(), contentHeight + contentToCellDiff));
                        }
                        if (text == null || text.length() <= 0) break block14;
                        if (numberOfNewLines != 1) break block15;
                        int contentWidth = Math.min(this.getLengthFromCache(gc, text), rectangle.height);
                        Transform transform = new Transform(gc.getDevice());
                        if (!this.isRotateClockwise()) {
                            transform.rotate(-90.0f);
                            int xOffset = -rectangle.x + (-contentWidth - rectangle.y) - CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentWidth);
                            int yOffset = rectangle.x + -rectangle.y + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentHeight) + this.spacing;
                            transform.translate((float)xOffset, (float)yOffset);
                        } else {
                            transform.rotate(90.0f);
                            int horizontalPadding = CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentHeight);
                            if (horizontalPadding != 0) {
                                horizontalPadding += gc.getFontMetrics().getLeading();
                            }
                            int xOffset = rectangle.y - rectangle.x + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentWidth);
                            int yOffset = -contentHeight - rectangle.y - rectangle.x - horizontalPadding + this.spacing;
                            transform.translate((float)xOffset, (float)yOffset);
                        }
                        gc.setTransform(transform);
                        gc.drawText(text, rectangle.x, rectangle.y, 3);
                        if (!underline && !strikethrough) break block16;
                        if (underline) {
                            int underlineY = rectangle.y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                            gc.drawLine(rectangle.x, underlineY, rectangle.x + gc.textExtent((String)text).x, underlineY);
                        }
                        if (!strikethrough) break block16;
                        int strikeY = rectangle.y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2;
                        gc.drawLine(rectangle.x, strikeY, rectangle.x + gc.textExtent((String)text).x, strikeY);
                        break block16;
                    }
                    int lineAdjustment = 0;
                    String[] stringArray = lines = text.split("\n");
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        int lineContentWidth = Math.min(this.getLengthFromCache(gc, line), rectangle.height);
                        Transform transform = new Transform(gc.getDevice());
                        if (!this.isRotateClockwise()) {
                            transform.rotate(-90.0f);
                            int xOffset = -rectangle.x + (-lineContentWidth - rectangle.y) - CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, lineContentWidth);
                            int yOffset = rectangle.x + -rectangle.y + lineAdjustment + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentHeight) + this.spacing;
                            transform.translate((float)xOffset, (float)yOffset);
                        } else {
                            transform.rotate(90.0f);
                            int horizontalPadding = CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentHeight);
                            if (horizontalPadding != 0) {
                                horizontalPadding += gc.getFontMetrics().getLeading();
                            }
                            int xOffset = rectangle.y - rectangle.x + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, lineContentWidth);
                            int yOffset = -contentHeight - rectangle.y - rectangle.x + lineAdjustment - horizontalPadding + this.spacing;
                            transform.translate((float)xOffset, (float)yOffset);
                        }
                        gc.setTransform(transform);
                        gc.drawText(line, rectangle.x, rectangle.y, 3);
                        if (underline || strikethrough) {
                            if (underline) {
                                int underlineY = rectangle.y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                                gc.drawLine(rectangle.x, underlineY, rectangle.x + gc.textExtent((String)line).x, underlineY);
                            }
                            if (strikethrough) {
                                int strikeY = rectangle.y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2;
                                gc.drawLine(rectangle.x, strikeY, rectangle.x + gc.textExtent((String)line).x, strikeY);
                            }
                        }
                        lineAdjustment += fontHeight;
                        ++n2;
                    }
                }
                gc.setTransform(null);
            }
            gc.setClipping(originalClipping);
        }
    }

    @Override
    protected void setNewMinLength(ILayerCell cell, int contentHeight) {
        int cellLength = cell.getBounds().height;
        if (cellLength < contentHeight) {
            ILayer layer = cell.getLayer();
            layer.doCommand(new RowResizeCommand(layer, cell.getRowPosition(), contentHeight));
        }
    }

    @Override
    protected int calculatePadding(ILayerCell cell, int availableLength) {
        return cell.getBounds().height - availableLength;
    }

    public boolean isRotateClockwise() {
        return this.rotateClockwise;
    }

    public void setRotateClockwise(boolean rotateClockwise) {
        this.rotateClockwise = rotateClockwise;
    }
}

