/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.editor;

import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ITabMouseEvent;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ITabMouseEventsListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.IHandlerService;

public class TabMouseEventListener
implements ITabMouseEventsListener {
    private static final String RENAME_COMMAND_ID = "org.eclipse.papyrus.infra.core.sasheditor.command.tabdoubleclick";
    protected IWorkbenchPartSite site;

    public TabMouseEventListener(ISashWindowsContainer container, IWorkbenchPartSite site) {
        this.site = site;
        this.initialize(container);
    }

    private void initialize(ISashWindowsContainer container) {
        container.addFolderTabMouseEventListener(this);
    }

    public void dispose(ISashWindowsContainer container) {
        if (container != null) {
            container.removeFolderTabMouseEventListener(this);
        }
        this.dispose();
    }

    public void dispose() {
        this.site = null;
    }

    protected IWorkbenchPartSite getSite() {
        return this.site;
    }

    protected void executeCommand(ITabMouseEvent event) {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        try {
            handlerService.executeCommand(RENAME_COMMAND_ID, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void executeCommandWithContext(ITabMouseEvent event) {
    }

    public void mouseDoubleClick(ITabMouseEvent event) {
        this.executeCommand(event);
    }

    public void mouseUp(ITabMouseEvent event) {
    }

    public void mouseDown(ITabMouseEvent event) {
    }
}

