/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple;

import java.util.Arrays;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IAbstractPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple.AbstractModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple.AbstractPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple.TabFolderModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SashPanelModel
extends AbstractPanelModel
implements ISashPanelModel {
    protected AbstractPanelModel[] children = new AbstractPanelModel[2];
    protected List<AbstractPanelModel> childrenList = Arrays.asList(this.children);
    protected int sashDirection;

    public SashPanelModel(AbstractModel parent, AbstractPanelModel leftChild, AbstractPanelModel rightChild, int sashDirection) {
        super(parent);
        this.children[0] = leftChild;
        this.children[1] = rightChild;
        this.sashDirection = sashDirection;
    }

    public void setLeftChild(AbstractPanelModel child) {
        this.children[0] = child;
    }

    private AbstractPanelModel getLeftChild() {
        return this.children[0];
    }

    public void setRightChild(AbstractPanelModel child) {
        this.children[1] = child;
    }

    private AbstractPanelModel getRightChild() {
        return this.children[1];
    }

    @Override
    public IAbstractPanelModel createChildSashModel(Object rawModel) {
        return (IAbstractPanelModel)rawModel;
    }

    @Override
    public List<?> getChildren() {
        return this.childrenList;
    }

    @Override
    public int getSashDirection() {
        return this.sashDirection;
    }

    @Override
    public void replaceChild(AbstractPanelModel oldChild, AbstractPanelModel newChild) {
        if (this.getLeftChild() == oldChild) {
            this.setLeftChild(newChild);
        } else if (this.getRightChild() == oldChild) {
            this.setRightChild(newChild);
        }
    }

    @Override
    protected TabFolderModel lookupTabFolder(IPageModel tabItem) {
        TabFolderModel parent = this.getLeftChild().lookupTabFolder(tabItem);
        if (parent != null) {
            return parent;
        }
        return this.getRightChild().lookupTabFolder(tabItem);
    }

    protected void delete(AbstractPanelModel childToDelete) {
        AbstractPanelModel otherChild = childToDelete == this.getLeftChild() ? this.getRightChild() : this.getLeftChild();
        AbstractModel parent = this.getParent();
        otherChild.setParent(parent);
        parent.replaceChild(this, otherChild);
    }
}

