/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.factory;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.gef.Tool;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteFactory;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.provider.ElementTypes;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;

public class DiagramPaletteFactory
extends PaletteFactory.Adapter {
    private static HashMap<String, IElementType[]> nodesToolIdTypesMap = new HashMap<String, IElementType[]>(){
        {
            this.put("blockdefinition.tool.actor", new IElementType[]{UMLElementTypes.ACTOR});
            this.put("blockdefinition.tool.block", new IElementType[]{SysMLElementTypes.BLOCK});
            this.put("blockdefinition.tool.constraint", new IElementType[]{UMLElementTypes.CONSTRAINT});
            this.put("blockdefinition.tool.constraintblock", new IElementType[]{SysMLElementTypes.CONSTRAINT_BLOCK});
            this.put("blockdefinition.tool.constraintproperty", new IElementType[]{SysMLElementTypes.CONSTRAINT_PROPERTY});
            this.put("blockdefinition.tool.datatype", new IElementType[]{UMLElementTypes.DATA_TYPE});
            this.put("blockdefinition.tool.dimension", new IElementType[]{SysMLElementTypes.DIMENSION});
            this.put("blockdefinition.tool.enumeration", new IElementType[]{UMLElementTypes.ENUMERATION});
            this.put("blockdefinition.tool.enumerationliteral", new IElementType[]{UMLElementTypes.ENUMERATION_LITERAL});
            this.put("blockdefinition.tool.flowport", new IElementType[]{SysMLElementTypes.FLOW_PORT});
            this.put("blockdefinition.tool.flowproperty", new IElementType[]{SysMLElementTypes.FLOW_PROPERTY});
            this.put("blockdefinition.tool.flowspecification", new IElementType[]{SysMLElementTypes.FLOW_SPECIFICATION});
            this.put("blockdefinition.tool.interface", new IElementType[]{UMLElementTypes.INTERFACE});
            this.put("blockdefinition.tool.operation", new IElementType[]{UMLElementTypes.OPERATION});
            this.put("blockdefinition.tool.part", new IElementType[]{SysMLElementTypes.PART_PROPERTY});
            this.put("blockdefinition.tool.port", new IElementType[]{UMLElementTypes.PORT});
            this.put("blockdefinition.tool.primitivetype", new IElementType[]{UMLElementTypes.PRIMITIVE_TYPE});
            this.put("blockdefinition.tool.property", new IElementType[]{UMLElementTypes.PROPERTY});
            this.put("blockdefinition.tool.reception", new IElementType[]{UMLElementTypes.RECEPTION});
            this.put("blockdefinition.tool.reference", new IElementType[]{SysMLElementTypes.REFERENCE_PROPERTY});
            this.put("blockdefinition.tool.signal", new IElementType[]{UMLElementTypes.SIGNAL});
            this.put("blockdefinition.tool.unit", new IElementType[]{SysMLElementTypes.UNIT});
            this.put("blockdefinition.tool.value", new IElementType[]{SysMLElementTypes.VALUE_PROPERTY});
            this.put("blockdefinition.tool.valuetype", new IElementType[]{SysMLElementTypes.VALUE_TYPE});
            this.remove("blockdefinition.tool.constraint");
            this.put("blockdefinition.tool.constraint", new IElementType[]{UMLElementTypes.CONSTRAINT});
            this.put("blockdefinition.tool.model", new IElementType[]{UMLElementTypes.MODEL});
            this.put("blockdefinition.tool.package", new IElementType[]{UMLElementTypes.PACKAGE});
            this.put("blockdefinition.tool.instancespecification", new IElementType[]{UMLElementTypes.INSTANCE_SPECIFICATION});
            this.put("blockdefinition.tool.slot", new IElementType[]{UMLElementTypes.SLOT});
            this.put("blockdefinition.tool.comment", new IElementType[]{UMLElementTypes.COMMENT});
            this.put("blockdefinition.tool.actorpart", new IElementType[]{SysMLElementTypes.ACTOR_PART_PROPERTY});
        }
    };
    private static HashMap<String, IElementType[]> edgesToolIdTypesMap = new HashMap<String, IElementType[]>(){
        {
            this.put("blockdefinition.tool.association", new IElementType[]{SysMLElementTypes.ASSOCIATION});
            this.put("blockdefinition.tool.dependency", new IElementType[]{UMLElementTypes.DEPENDENCY});
            this.put("blockdefinition.tool.generalization", new IElementType[]{UMLElementTypes.GENERALIZATION});
            this.put("blockdefinition.tool.interfacerealization", new IElementType[]{UMLElementTypes.INTERFACE_REALIZATION});
            this.put("blockdefinition.tool.usage", new IElementType[]{UMLElementTypes.USAGE});
            this.put("blockdefinition.tool.association_none", new IElementType[]{SysMLElementTypes.ASSOCIATION_NONE});
            this.put("blockdefinition.tool.association_none_directed", new IElementType[]{SysMLElementTypes.ASSOCIATION_NONE_DIRECTED});
            this.put("blockdefinition.tool.association_composite", new IElementType[]{SysMLElementTypes.ASSOCIATION_COMPOSITE});
            this.put("blockdefinition.tool.association_composite_directed", new IElementType[]{SysMLElementTypes.ASSOCIATION_COMPOSITE_DIRECTED});
            this.put("blockdefinition.tool.association_shared", new IElementType[]{SysMLElementTypes.ASSOCIATION_SHARED});
            this.put("blockdefinition.tool.association_shared_directed", new IElementType[]{SysMLElementTypes.ASSOCIATION_SHARED_DIRECTED});
            this.put("blockdefinition.tool.comment_constraint_link", new IElementType[]{ElementTypes.COMMENT_ANNOTATED_ELEMENT, ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT});
        }
    };

    public Tool createTool(String toolId) {
        IElementType[] types = nodesToolIdTypesMap.get(toolId);
        if (types != null) {
            return new AspectUnspecifiedTypeCreationTool(Arrays.asList(types));
        }
        types = edgesToolIdTypesMap.get(toolId);
        if (types != null) {
            return new AspectUnspecifiedTypeConnectionTool(Arrays.asList(types));
        }
        return null;
    }
}

