/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.instance.view;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.ui.queryexplorer.adapters.EMFModelConnector;
import org.eclipse.incquery.viewers.runtime.extensions.SelectionHelper;
import org.eclipse.incquery.viewers.runtime.model.IncQueryViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.sources.QueryLabelProvider;
import org.eclipse.incquery.viewers.runtime.sources.TreeContentProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.papyrus.views.search.utils.DefaultServiceRegistryTracker;
import org.eclipse.papyrus.views.search.utils.IServiceRegistryTracker;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Slot;
import org.polarsys.chess.instance.view.ViewLabelProvider;
import org.polarsys.chess.instance.view.util.ChildCHRTSpecItemQuerySpecification;
import org.polarsys.chess.instance.view.util.ChildCHRTSpecQuerySpecification;
import org.polarsys.chess.instance.view.util.ChildPortSlotsOperationItemQuerySpecification;
import org.polarsys.chess.instance.view.util.ChildPortSlotsOperationQuerySpecification;
import org.polarsys.chess.instance.view.util.ChildPortSlotsQuerySpecification;
import org.polarsys.chess.instance.view.util.ChildPrivCHRTSpecItemQuerySpecification;
import org.polarsys.chess.instance.view.util.ChildPrivCHRTSpecQuerySpecification;
import org.polarsys.chess.instance.view.util.ChildPrivateOperationsQuerySpecification;
import org.polarsys.chess.instance.view.util.SwSystemCHGaResourcePlatformQuerySpecification;
import org.polarsys.chess.instance.view.util.SwSystemChild2ItemQuerySpecification;
import org.polarsys.chess.instance.view.util.SwSystemChild2QuerySpecification;
import org.polarsys.chess.instance.view.util.SwSystemRootQuerySpecification;

public class InstanceViewPart
extends ViewPart
implements IPartListener2,
ISelectionProvider,
ITabbedPropertySheetPageContributor {
    TreeViewer viewer;
    SelectionHelper helper = new SelectionHelper();
    AdvancedIncQueryEngine engine = null;
    EMFModelConnector modelConnector;
    IEditorPart editor;
    ViewerState state;

    public InstanceViewPart() {
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        workbenchPage.addPartListener((IPartListener2)this);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent){

            protected void updateSelection(ISelection selection) {
            }

            protected void handlePostSelect(SelectionEvent e) {
                ISelection selection = this.getSelection();
                Object first = ((TreeSelection)selection).getFirstElement();
                Object umlobj = ((Item)first).getParamObject();
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(umlobj);
                StructuredSelection structsel = new StructuredSelection(list, this.getComparer());
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)structsel);
                this.firePostSelectionChanged(event);
            }
        };
        this.viewer.setUseHashlookup(true);
        this.viewer.addSelectionChangedListener(this.helper.trickyListener);
        this.editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.editor != null) {
            this.loadModel(this.editor);
        }
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection thisSelection;
                Object selectedNode;
                TreeViewer viewer;
                viewer.setExpandedState(selectedNode, !(viewer = (TreeViewer)event.getViewer()).getExpandedState(selectedNode = (thisSelection = (IStructuredSelection)event.getSelection()).getFirstElement()));
                try {
                    EObject umlobj = (EObject)((Item)selectedNode).getParamObject();
                    if (umlobj instanceof Slot) {
                        umlobj = ((Slot)umlobj).getDefiningFeature();
                    }
                    URI umlUri = umlobj.eResource().getURI();
                    ScopeEntry scopeEntry = new ScopeEntry(umlUri, (IServiceRegistryTracker)new DefaultServiceRegistryTracker());
                    OpenElementService service = (OpenElementService)scopeEntry.getServicesRegistry().getService(OpenElementService.class);
                    service.openSemanticElement(umlobj);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected Collection<IQuerySpecification<?>> getSpecifications() throws IncQueryException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)SwSystemCHGaResourcePlatformQuerySpecification.instance());
        builder.add((Object)SwSystemRootQuerySpecification.instance());
        builder.add((Object)SwSystemChild2ItemQuerySpecification.instance());
        builder.add((Object)SwSystemChild2QuerySpecification.instance());
        builder.add((Object)ChildPortSlotsQuerySpecification.instance());
        builder.add((Object)ChildPortSlotsOperationItemQuerySpecification.instance());
        builder.add((Object)ChildPortSlotsOperationQuerySpecification.instance());
        builder.add((Object)ChildCHRTSpecItemQuerySpecification.instance());
        builder.add((Object)ChildCHRTSpecQuerySpecification.instance());
        builder.add((Object)ChildPrivCHRTSpecItemQuerySpecification.instance());
        builder.add((Object)ChildPrivCHRTSpecQuerySpecification.instance());
        builder.add((Object)ChildPrivateOperationsQuerySpecification.instance());
        return builder.build();
    }

    protected IncQueryEngine getEngine() {
        return this.engine;
    }

    protected void engineUpdated() {
        try {
            this.state = IncQueryViewerDataModel.newViewerState((IncQueryEngine)this.engine, this.getSpecifications(), (ViewerDataFilter)ViewerDataFilter.UNFILTERED, (Collection)ImmutableSet.of((Object)ViewerState.ViewerStateFeature.CONTAINMENT, (Object)ViewerState.ViewerStateFeature.EDGE));
            InstanceViewPart.bind((AbstractTreeViewer)this.viewer, this.state);
        }
        catch (IncQueryException e) {
            e.printStackTrace();
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof IEditorPart) {
            IEditorPart activeEditor = (IEditorPart)part;
            this.loadModel(activeEditor);
        }
    }

    private void loadModel(IEditorPart activeEditor) {
        if (this.modelConnector != null) {
            EMFModelConnector temp = new EMFModelConnector(activeEditor);
            Notifier oldNotifier = null;
            try {
                oldNotifier = this.modelConnector.getNotifier(IModelConnectorTypeEnum.RESOURCESET);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Notifier newNotifier = temp.getNotifier(IModelConnectorTypeEnum.RESOURCESET);
            if (newNotifier == oldNotifier) {
                return;
            }
            this.modelConnector = temp;
        } else {
            this.modelConnector = new EMFModelConnector(activeEditor);
        }
        this.modelConnector.loadModel(IModelConnectorTypeEnum.RESOURCESET);
        if (this.modelConnector.getKey() != null) {
            try {
                this.engine = (AdvancedIncQueryEngine)AdvancedIncQueryEngine.on((Notifier)this.modelConnector.getKey().getNotifier());
            }
            catch (IncQueryException e) {
                e.printStackTrace();
            }
            this.modelConnector.getKey().setEngine(this.engine);
            this.engineUpdated();
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void dispose() {
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.helper.selectionChangedListeners.add(listener);
        System.out.println(listener.toString());
    }

    public ISelection getSelection() {
        return this.helper.unwrapElements_ViewersElementsToEObjects(this.viewer.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.helper.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(this.helper.unwrapElements_EObjectsToViewersElements(selection, this.state));
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(key);
    }

    public String getContributorId() {
        return "TreeOutlinePage";
    }

    public static void bind(AbstractTreeViewer viewer, ViewerState state) {
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        if (viewer.getContentProvider() != null && viewer.getContentProvider() instanceof TreeContentProvider) {
            ((TreeContentProvider)viewer.getContentProvider()).dispose();
        }
        if (viewer.getLabelProvider() != null && viewer.getLabelProvider() instanceof QueryLabelProvider) {
            ((QueryLabelProvider)viewer.getLabelProvider()).dispose();
        }
        viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(state));
        viewer.setInput((Object)state);
        viewer.refresh();
    }

    public void clearModelConnector() {
        this.modelConnector = null;
    }
}

