/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.basicdeferred;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.psystem.DeferredPConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;

public class Equality
extends DeferredPConstraint {
    private PVariable who;
    private PVariable withWhom;

    public Equality(PBody pSystem, PVariable who, PVariable withWhom) {
        super(pSystem, Equality.buildSet(who, withWhom));
        this.who = who;
        this.withWhom = withWhom;
    }

    private static Set<PVariable> buildSet(PVariable who, PVariable withWhom) {
        HashSet<PVariable> set = new HashSet<PVariable>();
        set.add(who);
        set.add(withWhom);
        return set;
    }

    public boolean isMoot() {
        return this.who.equals(this.withWhom);
    }

    @Override
    public void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (obsolete.equals(this.who)) {
            this.who = replacement;
        }
        if (obsolete.equals(this.withWhom)) {
            this.withWhom = replacement;
        }
    }

    @Override
    protected String toStringRest() {
        return String.valueOf(this.who.getName()) + "=" + this.withWhom.getName();
    }

    public PVariable getWho() {
        return this.who;
    }

    public PVariable getWithWhom() {
        return this.withWhom;
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.emptySet();
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies() {
        HashMap<Set<PVariable>, Set<PVariable>> result = new HashMap<Set<PVariable>, Set<PVariable>>();
        result.put(Collections.singleton(this.who), Collections.singleton(this.withWhom));
        result.put(Collections.singleton(this.withWhom), Collections.singleton(this.who));
        return result;
    }

    @Override
    public boolean isReadyAt(SubPlan plan, IPatternMatcherContext context) {
        return plan.getVisibleVariables().contains(this.who) && plan.getVisibleVariables().contains(this.withWhom);
    }
}

