/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBSchemaVisitor;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.internal.db.ddl.DBIndex;
import org.eclipse.net4j.internal.db.ddl.DBSchemaElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBField;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;
import org.eclipse.net4j.spi.db.ddl.InternalDBTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBField
extends DBSchemaElement
implements InternalDBField {
    public static final int DEFAULT_BOOLEAN_PRECISION = 1;
    public static final int DEFAULT_INTEGER_PRECISION = 10;
    public static final int DEFAULT_DECIMAL_PRECISION = 5;
    public static final int DEFAULT_PRECISION = 0;
    public static final int DEFAULT_SCALE = 0;
    public static final int DEFAULT_CHAR_LENGTH = 1;
    public static final int DEFAULT_VARCHAR_LENGTH = 255;
    private static final ThreadLocal<Boolean> TRACK_CONSTRUCTION = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private static final long serialVersionUID = 1L;
    private IDBTable table;
    private DBType type;
    private int precision;
    private int scale;
    private boolean notNull;
    private int position;
    private transient Exception constructionStackTrace;

    public DBField(IDBTable table, String name, DBType type, int precision, int scale, boolean notNull, int position) {
        super(name);
        this.table = table;
        this.type = type;
        this.precision = precision;
        this.scale = scale;
        this.notNull = notNull;
        this.position = position;
        if (TRACK_CONSTRUCTION.get() == Boolean.TRUE) {
            try {
                throw new Exception("The field " + this + " has been constructed here:");
            }
            catch (Exception ex) {
                this.constructionStackTrace = ex;
            }
        }
    }

    protected DBField() {
    }

    @Override
    public IDBField getWrapper() {
        return (IDBField)super.getWrapper();
    }

    @Override
    public IDBSchemaElement.SchemaElementType getSchemaElementType() {
        return IDBSchemaElement.SchemaElementType.FIELD;
    }

    @Override
    public IDBSchema getSchema() {
        return this.table.getSchema();
    }

    @Override
    public IDBTable getTable() {
        return this.table;
    }

    @Override
    public IDBTable getParent() {
        return this.getTable();
    }

    @Override
    public DBType getType() {
        return this.type;
    }

    @Override
    public void setType(DBType type) {
        this.assertUnlocked();
        this.type = type;
    }

    @Override
    public int getPrecision() {
        if (this.precision == -1) {
            switch (this.type) {
                case BOOLEAN: {
                    return 1;
                }
                case INTEGER: {
                    return 10;
                }
                case CHAR: {
                    return 1;
                }
                case VARCHAR: 
                case VARBINARY: {
                    return 255;
                }
                case NUMERIC: 
                case DECIMAL: {
                    return 5;
                }
            }
            return 0;
        }
        return this.precision;
    }

    @Override
    public void setPrecision(int precision) {
        this.assertUnlocked();
        this.precision = precision;
    }

    @Override
    public int getScale() {
        if (this.scale == -1) {
            return 0;
        }
        return this.scale;
    }

    @Override
    public void setScale(int scale) {
        this.assertUnlocked();
        this.scale = scale;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public void setNotNull(boolean notNull) {
        if (DBIndex.FIX_NULLABLE_INDEX_COLUMNS.get() != Boolean.TRUE) {
            this.assertUnlocked();
        }
        this.notNull = notNull;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        this.assertUnlocked();
        this.position = position;
    }

    @Override
    public String getFullName() {
        return String.valueOf(this.table.getName()) + "." + this.getName();
    }

    @Override
    public void remove() {
        ((InternalDBTable)this.table).removeField(this);
    }

    @Override
    public String formatPrecision() {
        int precision = this.getPrecision();
        if (precision > 0) {
            return "(" + precision + ")";
        }
        return "";
    }

    @Override
    public String formatPrecisionAndScale() {
        if (this.scale == -1) {
            return "(" + this.getPrecision() + ")";
        }
        return "(" + this.getPrecision() + ", " + this.getScale() + ")";
    }

    @Override
    public Exception getConstructionStackTrace() {
        return this.constructionStackTrace;
    }

    @Override
    protected void collectElements(List<IDBSchemaElement> elements) {
    }

    @Override
    protected void doAccept(IDBSchemaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void dumpAdditionalProperties(Writer writer) throws IOException {
        writer.append(", type=");
        writer.append(this.getType().toString());
        writer.append(", precision=");
        writer.append(String.valueOf(this.getPrecision()));
        writer.append(", scale=");
        writer.append(String.valueOf(this.getScale()));
        writer.append(", notNull=");
        writer.append(String.valueOf(this.isNotNull()));
    }

    private void assertUnlocked() {
        ((InternalDBSchema)this.table.getSchema()).assertUnlocked();
    }

    public static void trackConstruction(boolean on) {
        if (on) {
            TRACK_CONSTRUCTION.set(true);
        } else {
            TRACK_CONSTRUCTION.remove();
        }
    }
}

